/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.general;

import java.awt.datatransfer.Transferable;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.vmd.api.model.ComponentProducer;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.common.AcceptPresenter;
import org.netbeans.modules.vmd.api.model.common.AcceptSuggestion;
import org.netbeans.modules.vmd.api.model.common.DocumentSupport;
import org.netbeans.modules.vmd.midp.components.MidpArraySupport;
import org.netbeans.modules.vmd.midp.components.MidpProjectSupport;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;

public abstract class FileAcceptPresenter
extends AcceptPresenter {
    private Map<String, TypeID> extensionsMap = new HashMap<String, TypeID>();
    private Map<String, String> propertyNamesMap = new HashMap<String, String>();

    public FileAcceptPresenter(String string, TypeID typeID, String ... stringArray) {
        super(AcceptPresenter.Kind.TRANSFERABLE);
        this.addFileExtensions(string, typeID, stringArray);
    }

    public FileAcceptPresenter addFileExtensions(String string, TypeID typeID, String ... stringArray) {
        assert (typeID != null);
        assert (stringArray.length != 0);
        for (String string2 : stringArray) {
            this.extensionsMap.put(string2, typeID);
            this.propertyNamesMap.put(string2, string);
        }
        return this;
    }

    public boolean isAcceptable(Transferable transferable, AcceptSuggestion acceptSuggestion) {
        assert (!this.extensionsMap.isEmpty());
        FileObject fileObject = this.getNodeFileObject(transferable);
        if (fileObject == null && !this.belongsToProject(fileObject)) {
            return false;
        }
        DesignDocument designDocument = this.getComponent().getDocument();
        Map<FileObject, String> map = MidpProjectSupport.getAllFilesForProjectByExt(designDocument, this.extensionsMap.keySet());
        if (map.get(fileObject) == null) {
            return false;
        }
        TypeID typeID = this.getTypeForExtension(fileObject.getExt());
        return typeID != null;
    }

    public ComponentProducer.Result accept(Transferable transferable, AcceptSuggestion acceptSuggestion) {
        FileObject fileObject = this.getNodeFileObject(transferable);
        TypeID typeID = this.getTypeForExtension(fileObject.getExt());
        String string = this.getPropertyNameForExtension(fileObject.getExt());
        if (string == null) {
            return super.accept(transferable, acceptSuggestion);
        }
        DesignDocument designDocument = this.getComponent().getDocument();
        ComponentProducer componentProducer = DocumentSupport.getComponentProducer((DesignDocument)designDocument, (String)typeID.toString());
        if (designDocument == null || componentProducer == null) {
            return super.accept(transferable, acceptSuggestion);
        }
        DesignComponent designComponent = componentProducer.createComponent(designDocument).getMainComponent();
        if (this.getComponent().readProperty(string).getKind() == PropertyValue.Kind.ARRAY) {
            MidpArraySupport.append(this.getComponent(), string, designComponent);
        } else {
            this.getComponent().writeProperty(string, PropertyValue.createComponentReference((DesignComponent)designComponent));
        }
        return new ComponentProducer.Result(new DesignComponent[]{designComponent});
    }

    protected boolean belongsToProject(FileObject fileObject) {
        DesignDocument designDocument = this.getComponent().getDocument();
        Map<FileObject, String> map = MidpProjectSupport.getAllFilesForProjectByExt(designDocument, this.extensionsMap.keySet());
        return map.get(fileObject) != null;
    }

    protected InputStream getInputStream(Transferable transferable) {
        try {
            FileObject fileObject = this.getNodeFileObject(transferable);
            return fileObject != null ? fileObject.getInputStream() : null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            Debug.warning((Object[])new Object[]{fileNotFoundException});
            return null;
        }
    }

    protected String getFileClasspath(FileObject fileObject) {
        DesignDocument designDocument = this.getComponent().getDocument();
        Map<FileObject, String> map = MidpProjectSupport.getAllFilesForProjectByExt(designDocument, Arrays.asList(fileObject.getExt()));
        return map.get(fileObject);
    }

    protected FileObject getNodeFileObject(Transferable transferable) {
        Node node = NodeTransfer.node((Transferable)transferable, (int)3);
        if (node == null) {
            return null;
        }
        DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
        if (dataObject == null) {
            return null;
        }
        FileObject fileObject = dataObject.getPrimaryFile();
        return fileObject;
    }

    private TypeID getTypeForExtension(String string) {
        for (String string2 : this.extensionsMap.keySet()) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return this.extensionsMap.get(string2);
        }
        return null;
    }

    private String getPropertyNameForExtension(String string) {
        for (String string2 : this.propertyNamesMap.keySet()) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return this.propertyNamesMap.get(string2);
        }
        return null;
    }
}

