/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.e2e.wsdl;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.e2e.api.schema.SchemaException;
import org.netbeans.modules.e2e.api.wsdl.Binding;
import org.netbeans.modules.e2e.api.wsdl.BindingFault;
import org.netbeans.modules.e2e.api.wsdl.BindingInput;
import org.netbeans.modules.e2e.api.wsdl.BindingOperation;
import org.netbeans.modules.e2e.api.wsdl.BindingOutput;
import org.netbeans.modules.e2e.api.wsdl.Definition;
import org.netbeans.modules.e2e.api.wsdl.Fault;
import org.netbeans.modules.e2e.api.wsdl.Input;
import org.netbeans.modules.e2e.api.wsdl.Message;
import org.netbeans.modules.e2e.api.wsdl.Operation;
import org.netbeans.modules.e2e.api.wsdl.Output;
import org.netbeans.modules.e2e.api.wsdl.Part;
import org.netbeans.modules.e2e.api.wsdl.Port;
import org.netbeans.modules.e2e.api.wsdl.PortType;
import org.netbeans.modules.e2e.api.wsdl.Service;
import org.netbeans.modules.e2e.api.wsdl.extensions.soap.SOAPAddress;
import org.netbeans.modules.e2e.api.wsdl.extensions.soap.SOAPBinding;
import org.netbeans.modules.e2e.api.wsdl.extensions.soap.SOAPBody;
import org.netbeans.modules.e2e.api.wsdl.extensions.soap.SOAPFault;
import org.netbeans.modules.e2e.api.wsdl.extensions.soap.SOAPHeader;
import org.netbeans.modules.e2e.api.wsdl.extensions.soap.SOAPHeaderFault;
import org.netbeans.modules.e2e.api.wsdl.extensions.soap.SOAPOperation;
import org.netbeans.modules.e2e.api.wsdl.wsdl2java.WSDL2Java;
import org.netbeans.modules.e2e.schema.SchemaParser;
import org.netbeans.modules.e2e.wsdl.BindingFaultImpl;
import org.netbeans.modules.e2e.wsdl.BindingImpl;
import org.netbeans.modules.e2e.wsdl.BindingInputImpl;
import org.netbeans.modules.e2e.wsdl.BindingOperationImpl;
import org.netbeans.modules.e2e.wsdl.BindingOutputImpl;
import org.netbeans.modules.e2e.wsdl.DefinitionImpl;
import org.netbeans.modules.e2e.wsdl.FaultImpl;
import org.netbeans.modules.e2e.wsdl.InputImpl;
import org.netbeans.modules.e2e.wsdl.MessageImpl;
import org.netbeans.modules.e2e.wsdl.OperationImpl;
import org.netbeans.modules.e2e.wsdl.OutputImpl;
import org.netbeans.modules.e2e.wsdl.PartImpl;
import org.netbeans.modules.e2e.wsdl.PortImpl;
import org.netbeans.modules.e2e.wsdl.PortTypeImpl;
import org.netbeans.modules.e2e.wsdl.ServiceImpl;
import org.netbeans.modules.e2e.wsdl.WSDLConstants;
import org.netbeans.modules.e2e.wsdl.WSDLException;
import org.netbeans.modules.e2e.wsdl.extensions.soap.SOAPAddressImpl;
import org.netbeans.modules.e2e.wsdl.extensions.soap.SOAPBindingImpl;
import org.netbeans.modules.e2e.wsdl.extensions.soap.SOAPBodyImpl;
import org.netbeans.modules.e2e.wsdl.extensions.soap.SOAPConstants;
import org.netbeans.modules.e2e.wsdl.extensions.soap.SOAPFaultImpl;
import org.netbeans.modules.e2e.wsdl.extensions.soap.SOAPHeaderImpl;
import org.netbeans.modules.e2e.wsdl.extensions.soap.SOAPOperationImpl;
import org.openide.util.Exceptions;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WSDLParser
extends DefaultHandler {
    private static final String SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String DEFINITION = "definitions";
    private static final String MESSAGE = "message";
    private static final String PART = "part";
    private static final String SERVICE = "service";
    private static final String PORT = "port";
    private static final String PORT_TYPE = "portType";
    private static final String OPERATION = "operation";
    private static final String BINDING = "binding";
    private static final String BINDING_OPERATION = "binding-operation";
    private static final String BINDING_INPUT = "binding-input";
    private static final String BINDING_OUTPUT = "binding-output";
    private static final String BINDING_FAULT = "binding-fault";
    private static final String INPUT = "input";
    private static final String OUTPUT = "output";
    private static final String FAULT = "fault";
    private List<WSDL2Java.ValidationResult> validationResults;
    private URL myOriginalWsdlUri;
    private Stack<String> state = new Stack();
    private Definition definition;
    private Message message;
    private Part part;
    private Service service;
    private Port port;
    private PortType portType;
    private Operation operation;
    private Input input;
    private Output output;
    private Fault fault;
    private Binding binding;
    private BindingOperation bindingOperation;
    private BindingInput bindingInput;
    private BindingOutput bindingOutput;
    private BindingFault bindingFault;
    private Map<String, String> prefixMapping = new HashMap<String, String>();
    private String targetNamespace;
    private SOAPAddress soapAddress;
    private SOAPBinding soapBinding;
    private SOAPOperation soapOperation;
    private SOAPBody soapBody;
    private SOAPHeader soapHeader;
    private SOAPHeaderFault soapHeaderFault;
    private SOAPFault soapFault;
    private String tagString;

    public WSDLParser(URL originalWsdlUri) {
        this.validationResults = new ArrayList<WSDL2Java.ValidationResult>();
        this.myOriginalWsdlUri = originalWsdlUri;
    }

    public Definition parse(String uri) throws WSDLException {
        this.definition = new DefinitionImpl();
        SchemaParser schemaParser = new SchemaParser();
        SAXParserFactory spf = SAXParserFactory.newInstance();
        try {
            spf.setNamespaceAware(true);
            SAXParser parser = spf.newSAXParser();
            parser.parse(uri, (DefaultHandler)this);
            try {
                schemaParser.parseLocation(this.myOriginalWsdlUri, this.definition.getTargetNamespace());
            }
            catch (SchemaException ex) {
                throw new WSDLException(ex);
            }
        }
        catch (WSDLException e) {
            this.validationResults.add(new WSDL2Java.ValidationResult(WSDL2Java.ValidationResult.ErrorLevel.FATAL, e.getMessage()));
        }
        catch (SAXException e) {
            this.validationResults.add(new WSDL2Java.ValidationResult(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "Error during parsing : " + e.getMessage()));
        }
        catch (ParserConfigurationException e) {
            this.validationResults.add(new WSDL2Java.ValidationResult(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "Error during parsing : " + e.getMessage()));
        }
        catch (IOException e) {
            this.validationResults.add(new WSDL2Java.ValidationResult(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "Communication error : " + e.getMessage()));
        }
        this.definition.setSchemaHolder(schemaParser.getSchemaHolder());
        this.validationResults.addAll(schemaParser.getValidationResults());
        return this.definition;
    }

    public List<WSDL2Java.ValidationResult> getValidationResults() {
        return Collections.unmodifiableList(this.validationResults);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.prefixMapping.put(prefix, uri);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.tagString = "";
        if (uri.equals("http://schemas.xmlsoap.org/wsdl/soap/")) {
            if (localName.equals(SOAPConstants.ADDRESS.getLocalPart()) & this.state.peek().equals(PORT)) {
                this.soapAddress = new SOAPAddressImpl(attributes.getValue("location"));
                return;
            }
            if (localName.equals(SOAPConstants.BINDING.getLocalPart()) && this.state.peek().equals(BINDING)) {
                String style = attributes.getValue("style") != null ? attributes.getValue("style") : "document";
                this.soapBinding = new SOAPBindingImpl(attributes.getValue("transport"), style);
                return;
            }
            if (localName.equals(SOAPConstants.OPERATION.getLocalPart()) && this.state.peek().equals(BINDING_OPERATION)) {
                this.soapOperation = new SOAPOperationImpl();
                this.soapOperation.setSoapActionURI(attributes.getValue("soapAction"));
                if (attributes.getValue("style") == null && this.soapBinding == null) {
                    throw new SAXException(new WSDLException("Missing mandatory SOAP style definition."));
                }
                String style = attributes.getValue("style") != null ? attributes.getValue("style") : this.soapBinding.getStyle();
                this.soapOperation.setStyle(style);
                return;
            }
            if (localName.equals(SOAPConstants.BODY.getLocalPart()) && (this.state.peek().equals(BINDING_INPUT) || this.state.peek().equals(BINDING_OUTPUT))) {
                this.soapBody = new SOAPBodyImpl(attributes.getValue("use"));
                this.soapBody.setNamespaceURI(attributes.getValue("namespace"));
                return;
            }
            if (localName.equals(SOAPConstants.HEADER.getLocalPart()) && (this.state.peek().equals(BINDING_INPUT) || this.state.peek().equals(BINDING_OUTPUT))) {
                this.soapHeader = new SOAPHeaderImpl(this.parseQName(attributes.getValue(MESSAGE)), attributes.getValue(PART), attributes.getValue("use"));
                this.soapHeader.setNamespaceURI(attributes.getValue("namespace"));
                return;
            }
            if (localName.equals(SOAPConstants.FAULT.getLocalPart()) && this.state.peek().equals(BINDING_FAULT)) {
                this.soapFault = new SOAPFaultImpl(attributes.getValue("name"), attributes.getValue("use"));
                this.soapFault.setNamespaceURI(attributes.getValue("namespace"));
                return;
            }
        }
        if (uri.equals("http://schemas.xmlsoap.org/wsdl/")) {
            if (localName.equals(DEFINITION) && this.state.empty()) {
                this.targetNamespace = attributes.getValue("targetNamespace");
                this.definition.setTargetNamespace(this.targetNamespace);
                this.state.push(DEFINITION);
                return;
            }
            if (localName.equals(WSDLConstants.MESSAGE.getLocalPart()) && this.state.peek().equals(DEFINITION)) {
                this.state.push(MESSAGE);
                String name = attributes.getValue("name");
                this.message = new MessageImpl(new QName(this.targetNamespace, name));
                return;
            }
            if (localName.equals(WSDLConstants.PART.getLocalPart()) && this.state.peek().equals(MESSAGE)) {
                this.state.push(PART);
                this.part = new PartImpl(attributes.getValue("name"), this.parseQName(attributes.getValue("type")), this.parseQName(attributes.getValue("element")));
                return;
            }
            if (localName.equals(WSDLConstants.PORT_TYPE.getLocalPart()) && this.state.peek().equals(DEFINITION)) {
                this.state.push(PORT_TYPE);
                this.portType = new PortTypeImpl(new QName(this.targetNamespace, attributes.getValue("name")));
                return;
            }
            if (localName.equals(WSDLConstants.OPERATION.getLocalPart()) && this.state.peek().equals(PORT_TYPE)) {
                this.state.push(OPERATION);
                this.operation = new OperationImpl(attributes.getValue("name"));
                return;
            }
            if (localName.equals(WSDLConstants.INPUT.getLocalPart()) && this.state.peek().equals(OPERATION)) {
                this.state.push(INPUT);
                QName messageRef = this.parseQName(attributes.getValue(MESSAGE));
                String messageName = messageRef.getLocalPart();
                Message message = this.definition.getMessage(messageRef);
                if (message == null) {
                    message = new MessageImpl.MessageReferenceImpl(messageRef);
                }
                this.input = new InputImpl(attributes.getValue("name"), message);
                return;
            }
            if (localName.equals(WSDLConstants.OUTPUT.getLocalPart()) && this.state.peek().equals(OPERATION)) {
                this.state.push(OUTPUT);
                QName messageRef = this.parseQName(attributes.getValue(MESSAGE));
                String messageName = messageRef.getLocalPart();
                Message message = this.definition.getMessage(messageRef);
                if (message == null) {
                    message = new MessageImpl.MessageReferenceImpl(messageRef);
                }
                this.output = new OutputImpl(attributes.getValue("name"), message);
                return;
            }
            if (localName.equals(WSDLConstants.FAULT.getLocalPart()) && this.state.peek().equals(OPERATION)) {
                this.state.push(FAULT);
                QName messageName = this.parseQName(attributes.getValue(MESSAGE));
                this.fault = new FaultImpl(attributes.getValue("name"), this.definition.getMessage(messageName));
                return;
            }
            if (localName.equals(WSDLConstants.BINDING.getLocalPart()) && this.state.peek().equals(DEFINITION)) {
                this.state.push(BINDING);
                QName typeQName = this.parseQName(attributes.getValue("type"));
                this.binding = new BindingImpl(attributes.getValue("name"));
                PortType portType = this.definition.getPortType(typeQName);
                if (portType == null) {
                    portType = new PortTypeImpl.PortTypeReferenceImpl(typeQName);
                }
                this.binding.setPortType(portType);
                return;
            }
            if (localName.equals(WSDLConstants.OPERATION.getLocalPart()) && this.state.peek().equals(BINDING)) {
                this.state.push(BINDING_OPERATION);
                this.bindingOperation = new BindingOperationImpl(attributes.getValue("name"));
                return;
            }
            if (localName.equals(WSDLConstants.INPUT.getLocalPart()) && this.state.peek().equals(BINDING_OPERATION)) {
                this.state.push(BINDING_INPUT);
                this.bindingInput = new BindingInputImpl(attributes.getValue("name"));
                return;
            }
            if (localName.equals(WSDLConstants.OUTPUT.getLocalPart()) && this.state.peek().equals(BINDING_OPERATION)) {
                this.state.push(BINDING_OUTPUT);
                this.bindingOutput = new BindingOutputImpl(attributes.getValue("name"));
                return;
            }
            if (localName.equals(WSDLConstants.FAULT.getLocalPart()) && this.state.peek().equals(BINDING_OPERATION)) {
                this.state.push(BINDING_FAULT);
                this.bindingFault = new BindingFaultImpl(attributes.getValue("name"));
                return;
            }
            if (localName.equals(WSDLConstants.SERVICE.getLocalPart()) && this.state.peek().equals(DEFINITION)) {
                this.state.push(SERVICE);
                this.service = new ServiceImpl(attributes.getValue("name"));
                return;
            }
            if (localName.equals(WSDLConstants.PORT.getLocalPart()) && this.state.peek().equals(SERVICE)) {
                this.state.push(PORT);
                Binding b = this.definition.getBinding(this.parseQName(attributes.getValue(BINDING)).getLocalPart());
                this.port = new PortImpl(attributes.getValue("name"), b);
                return;
            }
            if (localName.equals(WSDLConstants.IMPORT.getLocalPart()) && this.state.peek().equals(DEFINITION)) {
                try {
                    String namespace = attributes.getValue("namespace");
                    String location = attributes.getValue("location");
                    URI u = this.myOriginalWsdlUri.toURI();
                    URI sl = u.normalize().resolve(location);
                    WSDLParser parser = new WSDLParser(sl.toURL());
                    Definition d = parser.parse(sl.toString());
                    for (Binding b : d.getBindings().values()) {
                        this.definition.addBinding(b);
                    }
                    for (Message m : d.getMessages().values()) {
                        this.definition.addMessage(m);
                    }
                    for (Service s : d.getServices().values()) {
                        this.definition.addService(s);
                    }
                    for (PortType pt : d.getPortTypes().values()) {
                        this.definition.addPortType(pt);
                    }
                    if (d.getSchemaHolder() != null) {
                        this.definition.setSchemaHolder(d.getSchemaHolder());
                    }
                    this.validationResults.addAll(parser.getValidationResults());
                    return;
                }
                catch (WSDLException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
                catch (URISyntaxException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
                catch (MalformedURLException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (uri.equals("http://schemas.xmlsoap.org/wsdl/soap/")) {
            if (localName.equals(SOAPConstants.ADDRESS.getLocalPart()) & this.state.peek().equals(PORT)) {
                this.port.addExtensibilityElement(this.soapAddress);
                return;
            }
            if (localName.equals(SOAPConstants.BINDING.getLocalPart()) && this.state.peek().equals(BINDING)) {
                this.binding.addExtensibilityElement(this.soapBinding);
                return;
            }
            if (localName.equals(SOAPConstants.OPERATION.getLocalPart()) && this.state.peek().equals(BINDING_OPERATION)) {
                this.bindingOperation.addExtensibilityElement(this.soapOperation);
                return;
            }
            if (localName.equals(SOAPConstants.BODY.getLocalPart())) {
                if (this.state.peek().equals(BINDING_INPUT)) {
                    this.bindingInput.addExtensibilityElement(this.soapBody);
                }
                if (this.state.peek().equals(BINDING_OUTPUT)) {
                    this.bindingOutput.addExtensibilityElement(this.soapBody);
                }
                return;
            }
            if (localName.equals(SOAPConstants.HEADER.getLocalPart())) {
                if (this.state.peek().equals(BINDING_INPUT)) {
                    this.bindingInput.addExtensibilityElement(this.soapHeader);
                }
                if (this.state.peek().equals(BINDING_OUTPUT)) {
                    this.bindingOutput.addExtensibilityElement(this.soapHeader);
                }
                return;
            }
            if (localName.equals(SOAPConstants.FAULT.getLocalPart()) && this.state.peek().equals(BINDING_FAULT)) {
                this.bindingFault.addExtensibilityElement(this.soapFault);
                return;
            }
        }
        if (uri.equals("http://schemas.xmlsoap.org/wsdl/")) {
            if (localName.equals(WSDLConstants.DEFINITIONS.getLocalPart()) && this.state.peek().equals(DEFINITION)) {
                this.state.pop();
                return;
            }
            if (localName.equals(WSDLConstants.MESSAGE.getLocalPart()) && this.state.peek().equals(MESSAGE)) {
                this.state.pop();
                this.definition.addMessage(this.message);
                return;
            }
            if (localName.equals(WSDLConstants.PART.getLocalPart()) && this.state.peek().equals(PART)) {
                this.state.pop();
                this.message.addPart(this.part);
                return;
            }
            if (localName.equals(WSDLConstants.PORT_TYPE.getLocalPart()) && this.state.peek().equals(PORT_TYPE)) {
                this.state.pop();
                this.definition.addPortType(this.portType);
                return;
            }
            if (localName.equals(WSDLConstants.OPERATION.getLocalPart()) && this.state.peek().equals(OPERATION)) {
                this.state.pop();
                this.portType.addOperation(this.operation);
                return;
            }
            if (localName.equals(WSDLConstants.INPUT.getLocalPart()) && this.state.peek().equals(INPUT)) {
                this.state.pop();
                this.operation.setInput(this.input);
                return;
            }
            if (localName.equals(WSDLConstants.OUTPUT.getLocalPart()) && this.state.peek().equals(OUTPUT)) {
                this.state.pop();
                this.operation.setOutput(this.output);
                return;
            }
            if (localName.equals(WSDLConstants.FAULT.getLocalPart()) && this.state.peek().equals(FAULT)) {
                this.state.pop();
                this.operation.addFault(this.fault);
                return;
            }
            if (localName.equals(WSDLConstants.BINDING.getLocalPart()) && this.state.peek().equals(BINDING)) {
                this.state.pop();
                this.definition.addBinding(this.binding);
                return;
            }
            if (localName.equals(WSDLConstants.OPERATION.getLocalPart()) && this.state.peek().equals(BINDING_OPERATION)) {
                this.state.pop();
                this.binding.addBindingOperation(this.bindingOperation);
                return;
            }
            if (localName.equals(WSDLConstants.INPUT.getLocalPart()) && this.state.peek().equals(BINDING_INPUT)) {
                this.state.pop();
                this.bindingOperation.setBindingInput(this.bindingInput);
                return;
            }
            if (localName.equals(WSDLConstants.OUTPUT.getLocalPart()) && this.state.peek().equals(BINDING_OUTPUT)) {
                this.state.pop();
                this.bindingOperation.setBindingOutput(this.bindingOutput);
                return;
            }
            if (localName.equals(WSDLConstants.FAULT.getLocalPart()) && this.state.peek().equals(BINDING_FAULT)) {
                this.state.pop();
                this.bindingOperation.addBindingFault(this.bindingFault);
                return;
            }
            if (localName.equals(WSDLConstants.SERVICE.getLocalPart()) && this.state.peek().equals(SERVICE)) {
                this.state.pop();
                this.definition.addService(this.service);
                return;
            }
            if (localName.equals(WSDLConstants.PORT.getLocalPart()) && this.state.peek().equals(PORT)) {
                this.state.pop();
                this.service.addPort(this.port);
                return;
            }
            if (localName.equals(WSDLConstants.DOCUMENTATION.getLocalPart())) {
                if (this.state.peek().equals(OPERATION)) {
                    this.operation.setDocumentation(this.tagString);
                }
                return;
            }
        }
    }

    public QName parseQName(String qName) {
        if (qName == null) {
            return null;
        }
        int colonPos = qName.indexOf(58);
        if (colonPos > 0) {
            String prefix = qName.substring(0, colonPos);
            String uri = this.prefixMapping.get(prefix);
            return new QName(uri, qName.substring(colonPos + 1), prefix);
        }
        return new QName(this.targetNamespace, qName);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.tagString = this.tagString + new String(ch, start, length);
    }
}

