/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.collab.chat;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smackx.packet.DelayInformation;
import org.openide.util.Exceptions;
import org.xmlpull.v1.XmlPullParser;

public class DelayExtensionProvider
implements PacketExtensionProvider {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PacketExtension parseExtension(XmlPullParser parser) throws Exception {
        Date stamp = null;
        try {
            SimpleDateFormat simpleDateFormat = DelayInformation.UTC_FORMAT;
            synchronized (simpleDateFormat) {
                stamp = DelayInformation.UTC_FORMAT.parse(parser.getAttributeValue("", "stamp"));
            }
        }
        catch (ParseException e) {
            try {
                SimpleDateFormat simpleDateFormat = DelayInformation.NEW_UTC_FORMAT;
                synchronized (simpleDateFormat) {
                    stamp = DelayInformation.NEW_UTC_FORMAT.parse(parser.getAttributeValue("", "stamp"));
                }
            }
            catch (ParseException e1) {
                try {
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                    formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
                    stamp = formatter.parse(parser.getAttributeValue("", "stamp"));
                }
                catch (ParseException e2) {
                    try {
                        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz");
                        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
                        String stampString = parser.getAttributeValue("", "stamp");
                        String modifed = stampString.substring(0, 19) + "UTC" + stampString.substring(stampString.length() - 6);
                        stamp = formatter.parse(modifed);
                    }
                    catch (ParseException e3) {
                        Exceptions.printStackTrace((Throwable)e3);
                        stamp = new Date();
                    }
                }
            }
        }
        DelayInformation delayInformation = new DelayInformation(stamp);
        delayInformation.setFrom(parser.getAttributeValue("", "from"));
        delayInformation.setReason(parser.nextText());
        return delayInformation;
    }
}

