/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.dbschema.ColumnPairElement;
import org.netbeans.modules.dbschema.DBElement;
import org.netbeans.modules.dbschema.DBMemberElement;
import org.netbeans.modules.dbschema.ForeignKeyElement;
import org.netbeans.modules.dbschema.IndexElement;
import org.netbeans.modules.dbschema.TableElement;
import org.netbeans.modules.dbschema.nodes.DBElementNodeFactory;
import org.netbeans.modules.dbschema.nodes.DefaultDBFactory;
import org.netbeans.modules.dbschema.nodes.TableElementFilter;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.WeakListeners;

public class TableChildren
extends Children.Keys {
    protected static HashMap propToFilter;
    protected DBElement element;
    protected TableElementFilter filter;
    protected DBElementNodeFactory factory;
    private PropertyChangeListener wPropL;
    private DBElementListener propL;
    protected Collection[] cpl;
    private boolean nodesInited = false;
    private static Comparator comparator;

    public TableChildren(DBElement element) {
        this(DefaultDBFactory.READ_ONLY, element);
    }

    public TableChildren(DBElementNodeFactory factory, DBElement element) {
        this.element = element;
        this.factory = factory;
        this.filter = null;
    }

    public Class getFilterClass() {
        return TableElementFilter.class;
    }

    public Object getFilter() {
        return this.filter;
    }

    public void setFilter(Object filter) {
        if (!(filter instanceof TableElementFilter)) {
            throw new IllegalArgumentException();
        }
        this.filter = (TableElementFilter)filter;
        if (this.nodesInited) {
            this.refreshAllKeys();
        }
    }

    protected void addNotify() {
        this.refreshAllKeys();
        if (this.wPropL == null) {
            this.propL = new DBElementListener();
            this.wPropL = WeakListeners.propertyChange((PropertyChangeListener)this.propL, (Object)this.element);
        }
        this.element.addPropertyChangeListener(this.wPropL);
        this.nodesInited = true;
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
        this.nodesInited = false;
    }

    protected Node[] createNodes(Object key) {
        if (key instanceof ColumnElement) {
            return new Node[]{this.factory.createColumnNode((ColumnElement)key)};
        }
        if (key instanceof ColumnPairElement) {
            return new Node[]{this.factory.createColumnPairNode((ColumnPairElement)key)};
        }
        if (this.element instanceof TableElement) {
            boolean viewSupport = this.isViewSupport((TableElement)this.element);
            if (((TableElement)this.element).isTableOrView() || viewSupport) {
                if (key instanceof IndexElement) {
                    return new Node[]{this.factory.createIndexNode((IndexElement)key)};
                }
                if (key instanceof ForeignKeyElement) {
                    return new Node[]{this.factory.createForeignKeyNode((ForeignKeyElement)key)};
                }
            }
        }
        return new Node[0];
    }

    protected void refreshAllKeys() {
        this.cpl = new Collection[this.getOrder().length];
        this.refreshKeys(63);
    }

    protected void refreshKeys(int filter) {
        int[] order = this.getOrder();
        LinkedList keys = new LinkedList();
        for (int i = 0; i < order.length; ++i) {
            if ((order[i] & filter) != 0 || this.cpl[i] == null) {
                this.cpl[i] = this.getKeysOfType(order[i]);
                keys.addAll(this.cpl[i]);
                continue;
            }
            keys.addAll(this.cpl[i]);
        }
        this.setKeys(keys);
    }

    protected Collection getKeysOfType(int elementType) {
        LinkedList keys = new LinkedList();
        DBMemberElement[] columns = null;
        DBMemberElement[] pairs = null;
        if (this.element instanceof TableElement) {
            columns = ((TableElement)this.element).getColumns();
        }
        if (this.element instanceof IndexElement) {
            columns = ((IndexElement)this.element).getColumns();
        }
        if (this.element instanceof ForeignKeyElement) {
            pairs = ((ForeignKeyElement)this.element).getColumnPairs();
        }
        if ((elementType & 4) != 0) {
            if (columns != null) {
                this.filterModifiers(columns, keys);
            } else if (pairs != null) {
                this.filterModifiers(pairs, keys);
            }
        }
        if (this.element instanceof TableElement) {
            boolean viewSupport = this.isViewSupport((TableElement)this.element);
            if (((TableElement)this.element).isTableOrView() || viewSupport) {
                if ((elementType & 8) != 0) {
                    this.filterModifiers(((TableElement)this.element).getIndexes(), keys);
                }
                if ((elementType & 0x10) != 0) {
                    this.filterModifiers(((TableElement)this.element).getKeys(), keys);
                }
            }
        }
        if (this.filter == null || this.filter.isSorted()) {
            Collections.sort(keys, comparator);
        }
        return keys;
    }

    private boolean isViewSupport(TableElement element) {
        String db = element.getDeclaringSchema().getDatabaseProductName();
        boolean viewSupport = false;
        if (db != null) {
            viewSupport = (db = db.toLowerCase()).indexOf("oracle") != -1 || db.indexOf("microsoft sql server") != -1;
        }
        return viewSupport;
    }

    private void filterModifiers(DBMemberElement[] elements, Collection keys) {
        int k = elements.length;
        for (int i = 0; i < k; ++i) {
            keys.add(elements[i]);
        }
    }

    protected int[] getOrder() {
        return this.filter == null || this.filter.getOrder() == null ? TableElementFilter.DEFAULT_ORDER : this.filter.getOrder();
    }

    static {
        comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof DBMemberElement) {
                    if (o2 instanceof DBMemberElement) {
                        return ((DBMemberElement)o1).getName().getName().compareToIgnoreCase(((DBMemberElement)o2).getName().getName());
                    }
                    return -1;
                }
                if (o2 instanceof DBMemberElement) {
                    return 1;
                }
                return 0;
            }
        };
        propToFilter = new HashMap();
        propToFilter.put("tables", new Integer(3));
        propToFilter.put("columns", new Integer(4));
        propToFilter.put("columnPairs", new Integer(32));
        propToFilter.put("indexes", new Integer(8));
        propToFilter.put("keys", new Integer(16));
    }

    private final class DBElementListener
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Integer i = (Integer)propToFilter.get(evt.getPropertyName());
            if (i != null) {
                TableChildren.this.refreshKeys(i);
            }
        }
    }
}

