/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.awt.Color;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.extexecution.print.ConvertedLine;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.StatusBar;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.ruby.rubyproject.AutoTestSupport;
import org.openide.awt.StatusDisplayer;
import org.openide.util.NbBundle;

public class TestNotifierLineConvertor
implements LineConvertor {
    private static String mostRecentMessage;
    private boolean accumulate;
    private boolean showSuccesses;
    private int examples;
    private int failures;
    private int notImplemented;
    private int tests;
    private int assertions;
    private int errors;
    private boolean seenTestUnit;
    private boolean seenRSpec;
    private boolean seenRake;
    private static final boolean QUIET;
    private static final Pattern TEST_UNIT_PATTERN;
    private static final Pattern RSPEC_PATTERN;
    private static final Pattern RAKE_PATTERN;
    private final Pattern[] PATTERNS = new Pattern[]{TEST_UNIT_PATTERN, RSPEC_PATTERN, RAKE_PATTERN};
    private boolean started;

    public TestNotifierLineConvertor(boolean accumulate, boolean showSuccesses) {
        this.accumulate = accumulate;
        this.showSuccesses = showSuccesses;
    }

    public void start() {
        String lastMessage = mostRecentMessage;
        if (lastMessage != null) {
            String text;
            JTextComponent pane = EditorRegistry.lastFocusedComponent();
            if (pane != null && pane.isShowing() && lastMessage.equals(text = Utilities.getStatusText((JTextComponent)pane))) {
                Utilities.clearStatusText((JTextComponent)pane);
            }
            mostRecentMessage = null;
        }
        this.resetResults();
    }

    public synchronized List<ConvertedLine> convert(String line) {
        if (!this.started) {
            this.started = true;
            this.start();
        }
        if (QUIET) {
            return null;
        }
        for (Pattern pattern : this.PATTERNS) {
            Matcher match = pattern.matcher(line);
            if (!match.matches()) continue;
            if (!this.accumulate) {
                this.resetResults();
            }
            this.addTotals(pattern, match);
            if (this.isError() || this.isWarning() || this.showSuccesses) {
                this.run();
                continue;
            }
            String summary = this.getSummary();
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(TestNotifierLineConvertor.class, (String)"TestsCompleted", (Object)summary));
        }
        return null;
    }

    private void resetResults() {
        this.examples = 0;
        this.failures = 0;
        this.notImplemented = 0;
        this.tests = 0;
        this.assertions = 0;
        this.errors = 0;
        this.seenTestUnit = false;
        this.seenRake = false;
        this.seenRake = false;
    }

    public void run() {
        String summary = this.getSummary();
        String message = this.isError() ? NbBundle.getMessage(AutoTestSupport.class, (String)"TestsFailed", (Object)summary) : NbBundle.getMessage(AutoTestSupport.class, (String)"TestsCompleted", (Object)summary);
        JTextComponent pane = EditorRegistry.lastFocusedComponent();
        if (pane != null) {
            if (pane.isShowing()) {
                mostRecentMessage = message;
                if (this.isError()) {
                    Utilities.setStatusBoldText((JTextComponent)pane, (String)message);
                } else {
                    StatusBar statusBar;
                    EditorUI eui = Utilities.getEditorUI((JTextComponent)pane);
                    if (eui != null && (statusBar = eui.getStatusBar()) != null) {
                        Coloring coloring = null;
                        coloring = this.isWarning() ? new Coloring(null, Color.BLACK, Color.YELLOW) : new Coloring(null, Color.BLACK, Color.GREEN);
                        statusBar.setText("main", message, coloring);
                        return;
                    }
                    Utilities.setStatusText((JTextComponent)pane, (String)message);
                }
            }
        } else {
            StatusDisplayer.getDefault().setStatusText(message);
        }
    }

    boolean recognizeLine(String line) {
        for (Pattern pattern : this.PATTERNS) {
            Matcher match = pattern.matcher(line);
            if (!match.matches()) continue;
            return true;
        }
        return false;
    }

    private void addTotals(Pattern pattern, Matcher matcher) {
        assert (this.PATTERNS.length == 3);
        if (pattern == TEST_UNIT_PATTERN) {
            this.seenTestUnit = true;
            this.tests += Integer.parseInt(matcher.group(1));
            this.assertions += Integer.parseInt(matcher.group(2));
            this.failures += Integer.parseInt(matcher.group(3));
            this.errors += Integer.parseInt(matcher.group(4));
        } else if (pattern == RSPEC_PATTERN) {
            this.seenRSpec = true;
            this.examples += Integer.parseInt(matcher.group(1));
            this.failures += Integer.parseInt(matcher.group(2));
            if (matcher.group(4) != null) {
                this.notImplemented += Integer.parseInt(matcher.group(4));
            }
        } else {
            assert (pattern == RAKE_PATTERN);
            this.seenRake = true;
            ++this.errors;
        }
    }

    private void appendSummary(StringBuilder sb, String s) {
        if (sb.length() > 0) {
            sb.append(", ");
        }
        sb.append(s);
    }

    private String getCountDescription(String oneKey, String manyKey, int count) {
        String countString = Integer.toString(count);
        return NbBundle.getMessage(TestNotifierLineConvertor.class, (String)(count == 1 ? oneKey : manyKey), (Object)countString);
    }

    boolean isError() {
        return this.errors > 0 || this.failures > 0;
    }

    boolean isWarning() {
        return this.notImplemented > 0;
    }

    String getSummary() {
        StringBuilder sb = new StringBuilder(80);
        if (this.seenTestUnit || this.tests > 0) {
            this.appendSummary(sb, this.getCountDescription("OneTest", "ManyTests", this.tests));
        }
        if (this.seenTestUnit || this.assertions > 0) {
            this.appendSummary(sb, this.getCountDescription("OneAssert", "ManyAssert", this.assertions));
        }
        if (this.seenRSpec || this.examples > 0) {
            this.appendSummary(sb, this.getCountDescription("OneExample", "ManyExamples", this.examples));
        }
        if (!this.seenRake || this.seenTestUnit || this.seenRSpec) {
            this.appendSummary(sb, this.getCountDescription("OneFailure", "ManyFailures", this.failures));
        }
        if (this.seenTestUnit || this.errors > 0) {
            this.appendSummary(sb, this.getCountDescription("OneError", "ManyErrors", this.errors));
        }
        if (this.notImplemented > 0) {
            this.appendSummary(sb, this.getCountDescription("OneNotImpl", "ManyNotImpl", this.notImplemented));
        }
        return sb.toString();
    }

    static {
        QUIET = Boolean.getBoolean("ruby.quiet.tests");
        TEST_UNIT_PATTERN = Pattern.compile("(\\d+) tests, (\\d+) assertions, (\\d+) failures, (\\d+) errors\\s?");
        RSPEC_PATTERN = Pattern.compile("(\\d+) examples?, (\\d)+ failures?(, (\\d+) (pending|not implemented))?\\s?");
        RAKE_PATTERN = Pattern.compile("Test failures\\s?");
    }
}

