/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.PlatformComponentFactory;
import org.netbeans.modules.ruby.platform.RubyPlatformCustomizer;
import org.netbeans.modules.ruby.rubyproject.RunFileActionProvider;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class RunFilePanel
extends JPanel {
    private JCheckBox displayDialog;
    private JTextField jvmArgsField;
    private JLabel jvmArgsLabel;
    private JButton managePlatformsButton;
    private JComboBox platformCombo;
    private JLabel platformLabel;
    private JTextField rubyOptionsField;
    private JLabel rubyOptionsLabel;
    private JTextField runArgsField;
    private JLabel runArgsLabel;
    private JTextField workDirField;
    private JLabel workDirLabel;

    public RunFilePanel(RunFileActionProvider.RunFileArgs args, boolean allowPlatformChange) {
        this.initComponents();
        this.initJvmArgs();
        PlatformComponentFactory.addPlatformChangeListener((JComboBox)this.platformCombo, (PlatformComponentFactory.PlatformChangeListener)new PlatformComponentFactory.PlatformChangeListener(){

            public void platformChanged() {
                RunFilePanel.this.initJvmArgs();
            }
        });
        if (args != null) {
            this.runArgsField.setText(args.getRunArgs());
            this.jvmArgsField.setText(args.getJvmArgs());
            this.rubyOptionsField.setText(args.getRubyOpts());
            this.workDirField.setText(args.getWorkDir());
            if (args.getPlatform() != null) {
                this.platformCombo.setSelectedItem(args.getPlatform());
            }
        }
        this.platformCombo.setEnabled(allowPlatformChange);
        this.platformLabel.setEnabled(allowPlatformChange);
        this.managePlatformsButton.setEnabled(allowPlatformChange);
    }

    RunFileActionProvider.RunFileArgs getArgs() {
        return new RunFileActionProvider.RunFileArgs(this.getPlatform(), this.getRunArgs(), this.getJvmArgs(), this.getRubyOpts(), this.getWorkDir(), !this.displayDialog.isSelected());
    }

    private void initJvmArgs() {
        RubyPlatform selected = this.getPlatform();
        boolean enable = selected != null && selected.isJRuby();
        this.jvmArgsField.setEnabled(enable);
        this.jvmArgsLabel.setEnabled(enable);
    }

    private String getJvmArgs() {
        return this.jvmArgsField.getText();
    }

    private String getRunArgs() {
        return this.runArgsField.getText();
    }

    private String getRubyOpts() {
        return this.rubyOptionsField.getText();
    }

    private String getWorkDir() {
        return this.workDirField.getText();
    }

    private RubyPlatform getPlatform() {
        return PlatformComponentFactory.getPlatform((JComboBox)this.platformCombo);
    }

    private void initComponents() {
        this.platformLabel = new JLabel();
        this.platformCombo = PlatformComponentFactory.getRubyPlatformsComboxBox();
        this.managePlatformsButton = new JButton();
        this.runArgsLabel = new JLabel();
        this.runArgsField = new JTextField();
        this.jvmArgsLabel = new JLabel();
        this.jvmArgsField = new JTextField();
        this.displayDialog = new JCheckBox();
        this.rubyOptionsField = new JTextField();
        this.rubyOptionsLabel = new JLabel();
        this.workDirField = new JTextField();
        this.workDirLabel = new JLabel();
        this.platformLabel.setLabelFor(this.platformCombo);
        Mnemonics.setLocalizedText((JLabel)this.platformLabel, (String)NbBundle.getMessage(RunFilePanel.class, (String)"RunFilePanel.platformLabel.text"));
        this.platformCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                RunFilePanel.this.platformComboItemStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.managePlatformsButton, (String)NbBundle.getMessage(RunFilePanel.class, (String)"RunFilePanel.managePlatformsButton.text"));
        this.managePlatformsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunFilePanel.this.managePlatformsButtonActionPerformed(evt);
            }
        });
        this.runArgsLabel.setLabelFor(this.runArgsField);
        Mnemonics.setLocalizedText((JLabel)this.runArgsLabel, (String)NbBundle.getMessage(RunFilePanel.class, (String)"RunFilePanel.runArgsLabel.text"));
        this.runArgsField.setText(NbBundle.getMessage(RunFilePanel.class, (String)"RunFilePanel.runArgsField.text"));
        this.jvmArgsLabel.setLabelFor(this.jvmArgsField);
        Mnemonics.setLocalizedText((JLabel)this.jvmArgsLabel, (String)NbBundle.getMessage(RunFilePanel.class, (String)"RunFilePanel.jvmArgsLabel.text"));
        this.jvmArgsField.setText(NbBundle.getMessage(RunFilePanel.class, (String)"RunFilePanel.jvmArgsField.text"));
        this.jvmArgsField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunFilePanel.this.jvmArgsFieldActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.displayDialog, (String)NbBundle.getMessage(RunFilePanel.class, (String)"RunFilePanel.displayDialog.text"));
        this.displayDialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunFilePanel.this.displayDialogActionPerformed(evt);
            }
        });
        this.rubyOptionsField.setText(NbBundle.getMessage(RunFilePanel.class, (String)"RunFilePanel.rubyOptionsField.text"));
        this.rubyOptionsLabel.setLabelFor(this.rubyOptionsField);
        Mnemonics.setLocalizedText((JLabel)this.rubyOptionsLabel, (String)NbBundle.getMessage(RunFilePanel.class, (String)"RunFilePanel.rubyOptionsLabel.text"));
        this.workDirField.setText(NbBundle.getMessage(RunFilePanel.class, (String)"RunFilePanel.workDirField.text"));
        this.workDirLabel.setLabelFor(this.workDirField);
        Mnemonics.setLocalizedText((JLabel)this.workDirLabel, (String)NbBundle.getMessage(RunFilePanel.class, (String)"RunFilePanel.workDirLabel.text"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.rubyOptionsLabel).add((Component)this.workDirLabel).add((Component)this.platformLabel).add((Component)this.runArgsLabel).add((Component)this.jvmArgsLabel)).add(16, 16, 16).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jvmArgsField, -1, 310, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.platformCombo, 0, 212, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.managePlatformsButton)).add(2, (Component)this.runArgsField, -1, 310, Short.MAX_VALUE).add((Component)this.workDirField, -1, 310, Short.MAX_VALUE).add((Component)this.rubyOptionsField, -1, 310, Short.MAX_VALUE))).add((Component)this.displayDialog)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.platformLabel).add((Component)this.platformCombo, -2, -1, -2).add((Component)this.managePlatformsButton)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.runArgsLabel).add((Component)this.runArgsField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.workDirLabel).add((Component)this.workDirField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.rubyOptionsLabel).add((Component)this.rubyOptionsField, -2, -1, -2)).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jvmArgsLabel).add((Component)this.jvmArgsField, -2, -1, -2)).addPreferredGap(1).add((Component)this.displayDialog).add(18, 18, 18)));
        this.displayDialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunFilePanel.class, (String)"RunFilePanel.displayDialog.AccessibleContext.accessibleDescription"));
    }

    private void jvmArgsFieldActionPerformed(ActionEvent evt) {
    }

    private void managePlatformsButtonActionPerformed(ActionEvent evt) {
        RubyPlatformCustomizer.manage((JComboBox)this.platformCombo);
    }

    private void platformComboItemStateChanged(ItemEvent evt) {
    }

    private void displayDialogActionPerformed(ActionEvent evt) {
    }
}

