/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing.lucene;

import java.io.IOException;
import org.netbeans.modules.parsing.impl.indexing.IndexDocumentImpl;
import org.netbeans.modules.parsing.impl.indexing.IndexFactoryImpl;
import org.netbeans.modules.parsing.impl.indexing.IndexImpl;
import org.netbeans.modules.parsing.impl.indexing.lucene.LuceneDocument;
import org.netbeans.modules.parsing.impl.indexing.lucene.LuceneIndexManager;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class LuceneIndexFactory
implements IndexFactoryImpl {
    @Override
    public IndexDocumentImpl createDocument(Indexable indexable) {
        assert (indexable != null);
        return new LuceneDocument(indexable);
    }

    @Override
    public IndexImpl createIndex(Context ctx) throws IOException {
        FileObject luceneIndexFolder = this.getIndexFolder(ctx.getIndexFolder());
        return LuceneIndexManager.getDefault().getIndex(luceneIndexFolder.getURL(), LuceneIndexManager.Mode.CREATE);
    }

    @Override
    public IndexImpl getIndex(FileObject indexFolder) throws IOException {
        FileObject luceneIndexFolder = this.getIndexFolder(indexFolder);
        return LuceneIndexManager.getDefault().getIndex(luceneIndexFolder.getURL(), LuceneIndexManager.Mode.IF_EXIST);
    }

    private FileObject getIndexFolder(FileObject indexFolder) throws IOException {
        assert (indexFolder != null);
        String indexVersion = Integer.toString(1);
        FileObject luceneIndexFolder = FileUtil.createFolder((FileObject)indexFolder, (String)indexVersion);
        return luceneIndexFolder;
    }
}

