/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.impl.indexing.Util;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class SelectedNodesScheduler
extends Scheduler {
    private Source source;
    private RequestProcessor requestProcessor;

    public SelectedNodesScheduler() {
        TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)new AListener());
        this.refresh();
    }

    private void refresh() {
        if (this.requestProcessor == null) {
            this.requestProcessor = new RequestProcessor("SelectedNodesScheduler");
        }
        this.requestProcessor.post(new Runnable(){

            @Override
            public void run() {
                FileObject fileObject;
                DataObject dataObject;
                Node[] nodes = TopComponent.getRegistry().getActivatedNodes();
                if (nodes.length == 1 && (dataObject = (DataObject)nodes[0].getLookup().lookup(DataObject.class)) != null && dataObject.isValid() && (fileObject = dataObject.getPrimaryFile()).isValid() && Util.canBeParsed(fileObject.getMIMEType())) {
                    SelectedNodesScheduler.this.source = Source.create(fileObject);
                    if (SelectedNodesScheduler.this.source != null) {
                        SelectedNodesScheduler.this.schedule(SelectedNodesScheduler.this.source, new SchedulerEvent(SelectedNodesScheduler.this){});
                        return;
                    }
                }
                SelectedNodesScheduler.this.source = null;
                SelectedNodesScheduler.this.schedule(null, null);
            }
        });
    }

    public String toString() {
        return "SelectedNodesScheduller";
    }

    @Override
    protected SchedulerEvent createSchedulerEvent(SourceModificationEvent event) {
        if (event.getModifiedSource() == this.source) {
            return new SchedulerEvent(this){};
        }
        return null;
    }

    private class AListener
    implements PropertyChangeListener {
        private AListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == null || evt.getPropertyName().equals("activatedNodes")) {
                SelectedNodesScheduler.this.refresh();
            }
        }
    }
}

