/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger;

import java.beans.PropertyChangeEvent;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.modules.ruby.debugger.ContextProviderWrapper;
import org.netbeans.modules.ruby.debugger.EditorUtil;
import org.netbeans.modules.ruby.debugger.RubyDebuggerActionProvider;
import org.netbeans.modules.ruby.debugger.Util;
import org.netbeans.modules.ruby.debugger.model.CallSite;
import org.netbeans.modules.ruby.debugger.ui.CallStackAnnotation;
import org.netbeans.spi.debugger.SessionProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.text.Line;
import org.rubyforge.debugcommons.RubyDebugEventListener;
import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.RubyDebuggerProxy;
import org.rubyforge.debugcommons.model.RubyDebugTarget;
import org.rubyforge.debugcommons.model.RubyFrame;
import org.rubyforge.debugcommons.model.RubyThread;
import org.rubyforge.debugcommons.model.RubyThreadInfo;
import org.rubyforge.debugcommons.model.RubyValue;
import org.rubyforge.debugcommons.model.RubyVariable;

public final class RubySession {
    public static final Logger LOGGER = Logger.getLogger(RubySession.class.getName());
    private static final String RUBY_SESSION = "RubySession";
    static boolean TEST;
    private final RubyThreadInfo[] EMPTY_THREAD_INFOS = new RubyThreadInfo[0];
    private final RubyFrame[] EMPTY_FRAMES = new RubyFrame[0];
    private final RubyVariable[] EMPTY_VARIABLES = new RubyVariable[0];
    private Session session;
    private final RubyDebuggerProxy proxy;
    private RubyDebuggerActionProvider actionProvider;
    private final LineConvertors.FileLocator fileLocator;
    private RubyThread activeThread;
    private RubyFrame selectedFrame;
    private final DebuggerManagerListener sessionListener;
    private State state;
    File runningToFile;
    int runningToLine;

    RubySession(RubyDebuggerProxy proxy, LineConvertors.FileLocator fileLocator) {
        this.proxy = proxy;
        this.fileLocator = fileLocator;
        this.sessionListener = new RubySessionListener();
        this.state = State.STARTING;
        this.runningToLine = -1;
        DebuggerManager.getDebuggerManager().addDebuggerListener("currentSession", this.sessionListener);
    }

    public void setSession(Session session) {
        this.session = session;
    }

    void setActionProvider(RubyDebuggerActionProvider actionProvider) {
        this.actionProvider = actionProvider;
    }

    RubyDebuggerActionProvider getActionProvider() {
        return this.actionProvider;
    }

    public State getState() {
        return this.state;
    }

    void resume() {
        this.beforeProceed();
        this.activeThread.resume();
        EditorUtil.unmarkCurrent();
        this.state = State.RUNNING;
    }

    void stepInto() {
        try {
            this.beforeProceed();
            if (!this.activeThread.canStepInto()) {
                return;
            }
            this.activeThread.stepInto(this.forceNewLine());
            this.state = State.RUNNING;
        }
        catch (RubyDebuggerException e) {
            LOGGER.log(Level.SEVERE, "Cannot step into: " + e.getLocalizedMessage(), e);
        }
    }

    void stepOver() {
        try {
            this.stepOver(this.forceNewLine());
        }
        catch (RubyDebuggerException e) {
            LOGGER.log(Level.SEVERE, "Cannot step over: " + e.getLocalizedMessage(), e);
        }
    }

    void stepOver(boolean forceNewLine) {
        try {
            this.beforeProceed();
            if (!this.activeThread.canStepOver()) {
                return;
            }
            this.activeThread.stepOver(forceNewLine);
            this.state = State.RUNNING;
        }
        catch (RubyDebuggerException e) {
            LOGGER.log(Level.SEVERE, "Cannot step voer: " + e.getLocalizedMessage(), e);
        }
    }

    void stepReturn() {
        try {
            this.beforeProceed();
            this.activeThread.stepReturn();
            this.state = State.RUNNING;
        }
        catch (RubyDebuggerException e) {
            LOGGER.log(Level.SEVERE, "Cannot step return: " + e.getLocalizedMessage(), e);
        }
    }

    void runToCursor() {
        int line;
        File file;
        if (TEST) {
            file = this.runningToFile;
            line = this.runningToLine;
        } else {
            assert (this.runningToFile == null) : "runningToFile is not set";
            this.beforeProceed();
            Line eLine = EditorUtil.getCurrentLine();
            if (eLine == null) {
                return;
            }
            FileObject fo = (FileObject)eLine.getLookup().lookup(FileObject.class);
            if (fo == null) {
                return;
            }
            if (!Util.isRubySource(fo)) {
                return;
            }
            file = FileUtil.toFile((FileObject)fo);
            line = eLine.getLineNumber() + 1;
        }
        if (file != null) {
            try {
                this.runningToFile = file;
                this.runningToLine = line;
                this.activeThread.runTo(file.getAbsolutePath(), line);
                this.state = State.RUNNING;
            }
            catch (RubyDebuggerException e) {
                LOGGER.log(Level.SEVERE, "Cannot run to cursor: " + e.getLocalizedMessage(), e);
            }
        }
    }

    boolean isRunningTo(File f, int line) {
        assert (f != null) : "isRunningTo is not passed null File arg";
        return f.equals(this.runningToFile) && line == this.runningToLine;
    }

    void finish(RubyDebugEventListener listener, boolean terminate) {
        CallStackAnnotation.clearAnnotations();
        DebuggerManager.getDebuggerManager().removeDebuggerListener(this.sessionListener);
        this.proxy.removeRubyDebugEventListener(listener);
        if (terminate) {
            this.proxy.finish(true);
        }
    }

    String getName() {
        return this.getDebuggeePath() + " (localhost:" + this.proxy.getDebugTarget().getPort() + ')';
    }

    private String getDebuggeePath() {
        RubyDebugTarget debugTarget = this.proxy.getDebugTarget();
        String debuggee = debugTarget.getDebuggedFile();
        if (debuggee == null) {
            return "[Remotely attached]";
        }
        File debuggeeF = new File(debuggee);
        String path = debuggeeF.isAbsolute() ? debuggeeF.getAbsolutePath() : new File(debugTarget.getBaseDir(), debugTarget.getDebuggedFile()).getAbsolutePath();
        return path;
    }

    public RubyThreadInfo[] getThreadInfos() {
        try {
            return this.proxy.isReady() ? this.proxy.readThreadInfo() : this.EMPTY_THREAD_INFOS;
        }
        catch (RubyDebuggerException e) {
            this.logIfNotFinished("Cannot read threads from a live proxy", e);
            return this.EMPTY_THREAD_INFOS;
        }
    }

    public RubyFrame[] getFrames() {
        try {
            return this.isSessionSuspended() ? this.activeThread.getFrames() : this.EMPTY_FRAMES;
        }
        catch (RubyDebuggerException e) {
            this.logIfNotFinished("Cannot read frames from a live proxy", e);
            return this.EMPTY_FRAMES;
        }
    }

    private RubyFrame getTopFrame() throws RubyDebuggerException {
        return this.isSessionSuspended() ? this.activeThread.getTopFrame() : null;
    }

    public void selectFrame(RubyFrame frame) {
        this.selectedFrame = frame;
    }

    private RubyFrame getSelectedFrame() {
        try {
            return this.selectedFrame == null ? this.getTopFrame() : this.selectedFrame;
        }
        catch (RubyDebuggerException e) {
            this.logIfNotFinished("Unable to read top stack frame", e);
            return null;
        }
    }

    public boolean isSelectedFrame(RubyFrame frame) {
        return frame.equals((Object)this.getSelectedFrame());
    }

    public RubyVariable[] getGlobalVariables() {
        try {
            return this.isSessionSuspended() ? this.proxy.readGlobalVariables() : this.EMPTY_VARIABLES;
        }
        catch (RubyDebuggerException e) {
            this.logIfNotFinished("Cannot read global variables from a live proxy", e);
            return this.EMPTY_VARIABLES;
        }
    }

    public RubyVariable[] getVariables() {
        try {
            RubyFrame frame = this.getSelectedFrame();
            return frame == null ? this.EMPTY_VARIABLES : frame.getVariables();
        }
        catch (RubyDebuggerException e) {
            this.logIfNotFinished("Cannot read variables from a live proxy", e);
            return this.EMPTY_VARIABLES;
        }
    }

    public RubyVariable[] getChildren(RubyVariable parent) {
        try {
            RubyValue val = parent.getValue();
            return val == null ? this.EMPTY_VARIABLES : val.getVariables();
        }
        catch (RubyDebuggerException e) {
            this.logIfNotFinished("Cannot read variables from a live proxy", e);
            return this.EMPTY_VARIABLES;
        }
    }

    public RubyVariable inspectExpression(String expression) {
        try {
            RubyFrame frame = this.getSelectedFrame();
            return frame == null ? null : frame.inspectExpression(expression);
        }
        catch (RubyDebuggerException e) {
            LOGGER.finer("Unable to inspect expression [" + expression + ']');
            return null;
        }
    }

    void suspend(RubyThread thread, ContextProviderWrapper contextProvider) {
        this.state = State.STOPPED;
        this.runningToFile = null;
        this.runningToLine = -1;
        this.switchThread(thread, contextProvider);
    }

    void switchThread(RubyThread thread, ContextProviderWrapper contextProvider) {
        if (thread.isSuspended()) {
            this.activeThread = thread;
            try {
                RubyFrame frame = this.getTopFrame();
                if (frame == null) {
                    return;
                }
                DebuggerManager.getDebuggerManager().setCurrentSession(this.session);
                EditorUtil.markCurrent(this.resolveAbsolutePath(frame.getFile()), frame.getLine() - 1);
                this.annotateCallStack(thread);
                if (contextProvider != null) {
                    contextProvider.fireModelChanges();
                }
            }
            catch (RubyDebuggerException e) {
                LOGGER.log(Level.SEVERE, "Cannot switch thread" + e.getLocalizedMessage(), e);
            }
        } else {
            LOGGER.finer("Cannot switch to thread which is not suspended [" + thread + "]");
        }
    }

    public void switchThread(int threadID, ContextProviderWrapper contextProvider) {
        RubyThread thread = this.proxy.getDebugTarget().getThreadById(threadID);
        if (thread != null) {
            this.switchThread(thread, contextProvider);
        }
    }

    public boolean isActiveThread(int id) {
        return this.activeThread != null && this.activeThread.getId() == id;
    }

    public boolean isSessionSuspended() {
        return this.activeThread != null && this.activeThread.isSuspended();
    }

    public String resolveAbsolutePath(String path) {
        File file;
        if (new File(path).isAbsolute()) {
            return path;
        }
        String result = null;
        FileObject fo = this.fileLocator.find(path);
        if (fo != null && (file = FileUtil.toFile((FileObject)fo)) != null && file.isFile()) {
            result = file.getAbsolutePath();
        }
        if (result == null) {
            LOGGER.finer("Cannot resolve absolute path for: \"" + path + '\"');
        }
        return result;
    }

    public boolean isSuspended(RubyThreadInfo ti) {
        RubyThread thread = this.proxy.getDebugTarget().getThreadById(ti.getId());
        if (thread != null) {
            return thread.isSuspended();
        }
        LOGGER.warning("There is no thread for: " + ti);
        return false;
    }

    private void annotateCallStack(RubyThread thread) {
        if (TEST) {
            return;
        }
        try {
            RubyFrame[] frames = thread.getFrames();
            assert (frames.length > 0) : "thread has >0 frames";
            CallSite[] callSites = new CallSite[frames.length - 1];
            for (int i = 1; i < frames.length; ++i) {
                CallSite site;
                RubyFrame frame = frames[i];
                callSites[i - 1] = site = new CallSite(this.resolveAbsolutePath(frame.getFile()), frame.getLine() - 1);
            }
            CallStackAnnotation.annotate(callSites);
        }
        catch (RubyDebuggerException e) {
            this.logIfNotFinished("Cannot annotated current call stack. Unable to read frames from a live proxy", e);
        }
    }

    private void refresh() {
        if (this.isSessionSuspended()) {
            this.switchThread(this.activeThread, null);
        }
    }

    private void beforeProceed() {
        this.selectFrame(null);
        CallStackAnnotation.clearAnnotations();
    }

    private boolean forceNewLine() throws RubyDebuggerException {
        RubyFrame frame = this.activeThread.getTopFrame();
        assert (frame != null);
        String path = frame.getFile();
        File f = FileUtil.normalizeFile((File)new File(path));
        FileObject fo = f.isAbsolute() ? FileUtil.toFileObject((File)f) : this.fileLocator.find(path);
        return fo == null ? false : Util.isERBSource(fo);
    }

    RubyDebuggerProxy getProxy() {
        return this.proxy;
    }

    private void logIfNotFinished(String message, RubyDebuggerException e) {
        if (this.proxy.isReady()) {
            LOGGER.log(Level.INFO, message + ": " + e.getLocalizedMessage(), e);
        }
    }

    SessionProvider createSessionProvider() {
        return new SessionProvider(){

            public String getSessionName() {
                return RubySession.this.getName();
            }

            public String getLocationName() {
                return "localhost";
            }

            public String getTypeID() {
                return RubySession.RUBY_SESSION;
            }

            public Object[] getServices() {
                return new Object[0];
            }
        };
    }

    private static class RubySessionListener
    extends DebuggerManagerAdapter {
        private RubySessionListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            RubySession rubySession;
            Session currentSession = DebuggerManager.getDebuggerManager().getCurrentSession();
            if (currentSession != null && "Ruby".equals(currentSession.getCurrentLanguage()) && (rubySession = Util.getCurrentSession()) != null) {
                rubySession.refresh();
            }
        }
    }

    public static enum State {
        STARTING,
        RUNNING,
        STOPPED;

    }
}

