/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.options;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.options.editor.spi.PreferencesCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CodeCompletionPanel
extends JPanel
implements DocumentListener {
    private final Preferences preferences;
    private JTextField autoCompletionTriggersField;
    private JLabel autoCompletionTriggersLabel;
    private JTextField autoCompletionTriggersPreprocField;
    private JLabel autoCompletionTriggersPreprocLabel;
    private JCheckBox autoInsertIncludeDirectives;
    private JSeparator jSeparator1;

    public CodeCompletionPanel(Preferences preferences) {
        this.preferences = preferences;
        this.initComponents();
        this.autoInsertIncludeDirectives.setSelected(preferences.getBoolean("autoInsertIncludeDirectives", true));
        this.autoCompletionTriggersField.setText(preferences.get("cppAutoCompletionTriggers", ".->::"));
        this.autoCompletionTriggersPreprocField.setText(preferences.get("autoCompletionTriggersPreproc", "\"<"));
        this.autoCompletionTriggersField.getDocument().addDocumentListener(this);
        this.autoCompletionTriggersPreprocField.getDocument().addDocumentListener(this);
    }

    public static PreferencesCustomizer.Factory getCustomizerFactory() {
        return new PreferencesCustomizer.Factory(){

            public PreferencesCustomizer create(Preferences preferences) {
                return new CodeCompletionPreferencesCusromizer(preferences);
            }
        };
    }

    private void initComponents() {
        this.autoCompletionTriggersLabel = new JLabel();
        this.autoCompletionTriggersField = new JTextField();
        this.autoInsertIncludeDirectives = new JCheckBox();
        this.autoCompletionTriggersPreprocLabel = new JLabel();
        this.autoCompletionTriggersPreprocField = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.autoCompletionTriggersLabel.setLabelFor(this.autoCompletionTriggersField);
        Mnemonics.setLocalizedText((JLabel)this.autoCompletionTriggersLabel, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionTriggersLabel.text"));
        this.autoCompletionTriggersField.setAlignmentX(1.0f);
        this.autoInsertIncludeDirectives.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.autoInsertIncludeDirectives, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoInclude.text"));
        this.autoInsertIncludeDirectives.setBorder(null);
        this.autoInsertIncludeDirectives.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodeCompletionPanel.this.autoInsertIncludeDirectivesActionPerformed(evt);
            }
        });
        this.autoCompletionTriggersPreprocLabel.setLabelFor(this.autoCompletionTriggersPreprocField);
        Mnemonics.setLocalizedText((JLabel)this.autoCompletionTriggersPreprocLabel, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionTriggersPreprocLabel.text"));
        this.autoCompletionTriggersPreprocField.setAlignmentX(1.0f);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.autoCompletionTriggersLabel).addComponent(this.autoCompletionTriggersPreprocLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.autoCompletionTriggersPreprocField, -2, 86, -2).addComponent(this.autoCompletionTriggersField, -2, 86, -2)).addGap(33, 33, 33)).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.autoInsertIncludeDirectives).addContainerGap(44, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jSeparator1, -1, 377, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.autoCompletionTriggersLabel).addComponent(this.autoCompletionTriggersField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.autoInsertIncludeDirectives).addGap(24, 24, 24).addComponent(this.jSeparator1, -2, -1, -2).addGap(23, 23, 23).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.autoCompletionTriggersPreprocLabel).addComponent(this.autoCompletionTriggersPreprocField, -2, -1, -2)).addContainerGap(168, Short.MAX_VALUE)));
    }

    private void autoInsertIncludeDirectivesActionPerformed(ActionEvent evt) {
        this.preferences.putBoolean("autoInsertIncludeDirectives", this.autoInsertIncludeDirectives.isSelected());
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.update(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.update(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.update(e);
    }

    private void update(DocumentEvent e) {
        if (e.getDocument() == this.autoCompletionTriggersField.getDocument()) {
            this.preferences.put("cppAutoCompletionTriggers", this.autoCompletionTriggersField.getText());
        } else if (e.getDocument() == this.autoCompletionTriggersPreprocField.getDocument()) {
            this.preferences.put("autoCompletionTriggersPreproc", this.autoCompletionTriggersPreprocField.getText());
        }
    }

    private static class CodeCompletionPreferencesCusromizer
    implements PreferencesCustomizer {
        private Preferences preferences;

        private CodeCompletionPreferencesCusromizer(Preferences p) {
            this.preferences = p;
        }

        public String getId() {
            return "org.netbeans.modules.cnd.completion.options";
        }

        public String getDisplayName() {
            return NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanelName");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("netbeans.optionsDialog.editor.codeCompletion.cpp");
        }

        public JComponent getComponent() {
            return new CodeCompletionPanel(this.preferences);
        }
    }
}

