/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.csm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;

public class CsmContext {
    private final int offset;
    private ArrayList<CsmContextEntry> context;
    private CsmObject csmLastObject;

    public CsmContext(int offset) {
        this.offset = offset;
        this.context = new ArrayList();
    }

    public CsmContextEntry get(int index) {
        return this.context.get(index);
    }

    public CsmContextEntry create(CsmScope scope) {
        return new CsmContextEntry(scope);
    }

    public CsmContextEntry create(CsmScope scope, int offset) {
        return new CsmContextEntry(scope, offset);
    }

    protected void add(CsmContextEntry entry) {
        this.context.add(entry);
    }

    public void add(CsmScope scope) {
        this.add(this.create(scope));
    }

    public void add(CsmScope scope, int offset) {
        this.add(this.create(scope, offset));
    }

    public void remove(CsmContextEntry entry) {
        this.context.remove(entry);
    }

    public CsmContextEntry getLastEntry() {
        if (this.isEmpty()) {
            return null;
        }
        return this.get(this.size() - 1);
    }

    public CsmScope getLastScope() {
        if (this.getLastEntry() != null) {
            return this.getLastEntry().getScope();
        }
        return null;
    }

    public CsmObject getLastObject() {
        return this.csmLastObject;
    }

    public void setLastObject(CsmObject obj) {
        this.csmLastObject = obj;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        return this.context.size();
    }

    public Iterator<CsmContextEntry> iterator() {
        return this.context.iterator();
    }

    public ListIterator<CsmContextEntry> reverseIterator() {
        return this.context.listIterator(this.context.size());
    }

    public int getOffset() {
        return this.offset;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("\nlast element is " + this.csmLastObject);
        buf.append("\ncontext for offset ").append(this.offset);
        if (this.isEmpty()) {
            buf.append(" empty");
        } else {
            buf.append(" with ").append(this.size()).append(" elements:\n");
            for (CsmContextEntry elem : this.context) {
                buf.append(elem);
                buf.append("\n");
            }
        }
        return buf.toString();
    }

    public static class CsmContextEntry {
        private CsmScope scope;
        private int offset;
        public static final int WHOLE_SCOPE = -1;

        public CsmContextEntry(CsmScope scope) {
            this(scope, -1);
        }

        public CsmContextEntry(CsmScope scope, int offset) {
            this.scope = scope;
            this.offset = offset;
        }

        public CsmScope getScope() {
            return this.scope;
        }

        public int getOffset() {
            return this.offset;
        }

        public boolean isWholeScope() {
            return this.getOffset() == -1;
        }

        public String toString() {
            CsmOffsetable offs;
            StringBuilder buf = new StringBuilder();
            buf.append("[");
            if (this.isWholeScope()) {
                buf.append("whole scope");
            } else {
                buf.append("jump in ").append(this.getOffset());
            }
            CsmOffsetable csmOffsetable = offs = CsmKindUtilities.isOffsetable((Object)this.scope) ? (CsmOffsetable)this.scope : null;
            if (offs != null) {
                buf.append(" (");
                CsmOffsetable.Position pos = offs.getStartPosition();
                buf.append(pos.getLine()).append(":").append(pos.getColumn()).append(",").append(pos.getOffset());
                buf.append(";");
                pos = offs.getEndPosition();
                buf.append(pos.getLine()).append(":").append(pos.getColumn()).append(",").append(pos.getOffset());
                buf.append(")");
            }
            buf.append(CsmUtilities.getCsmName((CsmObject)this.scope));
            buf.append(" scope - ");
            if (CsmKindUtilities.isScope((CsmObject)this.scope)) {
                buf.append(" [scope object] ");
            }
            if (CsmKindUtilities.isScopeElement((CsmObject)this.scope)) {
                buf.append(" [scope element] ");
            }
            buf.append("]");
            return buf.toString();
        }
    }
}

