/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.openide.util.Lookup;
import org.openidex.search.SearchType;
import sun.nio.cs.ThreadLocalCoders;

final class Utils {
    private static Lookup.Result<SearchType> result;

    private Utils() {
    }

    private static Lookup.Result<SearchType> getSearchTypes0() {
        if (result == null) {
            result = Lookup.getDefault().lookup(new Lookup.Template(SearchType.class));
        }
        return result;
    }

    static Collection<? extends SearchType> getSearchTypes() {
        return Utils.getSearchTypes0().allInstances();
    }

    static Class searchTypeForName(String className) {
        for (Class c : Utils.getSearchTypes0().allClasses()) {
            if (!c.getName().equals(className)) continue;
            return c;
        }
        return null;
    }

    static final Border getExplorerViewBorder() {
        Border border = (Border)UIManager.get("Nb.ScrollPane.border");
        if (border == null) {
            border = BorderFactory.createEtchedBorder();
        }
        return border;
    }

    static List<SearchType> cloneSearchTypes(Collection<? extends SearchType> searchTypes) {
        if (searchTypes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SearchType> clonedSearchTypes = new ArrayList<SearchType>(searchTypes.size());
        for (SearchType searchType : searchTypes) {
            clonedSearchTypes.add((SearchType)searchType.clone());
        }
        return clonedSearchTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CharBuffer getCharSequence(FileInputStream stream, Charset encoding) throws IOException {
        FileChannel channel = stream.getChannel();
        ByteBuffer bbuf = ByteBuffer.allocate((int)channel.size());
        try {
            channel.read(bbuf, 0L);
        }
        catch (ClosedByInterruptException cbie) {
            CharBuffer charBuffer = null;
            return charBuffer;
        }
        finally {
            channel.close();
        }
        bbuf.rewind();
        CharBuffer cbuf = Utils.decodeByteBuffer(bbuf, encoding);
        return cbuf;
    }

    static CharBuffer decodeByteBuffer(ByteBuffer in, Charset charset) throws CharacterCodingException {
        CharsetDecoder decoder = ThreadLocalCoders.decoderFor(charset.name()).onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        int remaining = in.remaining();
        if (remaining == 0) {
            return CharBuffer.allocate(0);
        }
        int n = (int)((float)remaining * decoder.averageCharsPerByte());
        if (n < 16) {
            n = 16;
        }
        CharBuffer out = CharBuffer.allocate(n);
        decoder.reset();
        while (true) {
            CoderResult cr;
            CoderResult coderResult = cr = in.hasRemaining() ? decoder.decode(in, out, true) : CoderResult.UNDERFLOW;
            if (cr.isUnderflow()) {
                cr = decoder.flush(out);
            }
            if (cr.isUnderflow()) break;
            if (cr.isOverflow()) {
                CharBuffer o = CharBuffer.allocate(n <<= 1);
                out.flip();
                o.put(out);
                out = o;
                continue;
            }
            cr.throwException();
        }
        out.flip();
        return out;
    }
}

