/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openfile;

import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.sendopts.CommandException;
import org.netbeans.modules.openfile.OpenFile;
import org.netbeans.spi.sendopts.Env;
import org.netbeans.spi.sendopts.Option;
import org.netbeans.spi.sendopts.OptionProcessor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class Handler
extends OptionProcessor {
    private Option open;
    private Option defaultOpen;

    protected Set<Option> getOptions() {
        if (this.open == null) {
            this.defaultOpen = Option.defaultArguments();
            Option o = Option.additionalArguments((char)'\uffff', (String)"open");
            String bundle = "org.netbeans.modules.openfile.Bundle";
            o = Option.shortDescription((Option)o, (String)bundle, (String)"MSG_OpenOptionDescription");
            this.open = o = Option.displayName((Option)o, (String)bundle, (String)"MSG_OpenOptionDisplayName");
            assert (this.open != null);
            assert (this.defaultOpen != null);
        }
        HashSet<Option> set = new HashSet<Option>();
        set.add(this.open);
        set.add(this.defaultOpen);
        return set;
    }

    protected void process(Env env, Map<Option, String[]> optionValues) throws CommandException {
        String[] argv = optionValues.get(this.open);
        if (argv == null) {
            argv = optionValues.get(this.defaultOpen);
        }
        if (argv == null || argv.length == 0) {
            throw new CommandException(2, NbBundle.getMessage(Handler.class, (String)"EXC_MissingArgOpen"));
        }
        File curDir = env.getCurrentDirectory();
        StringBuffer failures = new StringBuffer();
        String sep = "";
        for (int i = 0; i < argv.length; ++i) {
            String error = this.openFile(curDir, env, argv[i]);
            if (error == null) continue;
            failures.append(sep);
            failures.append(error);
            sep = "\n";
        }
        if (failures.length() > 0) {
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)failures.toString()));
            throw new CommandException(1, failures.toString());
        }
    }

    private File findFile(File curDir, String name) {
        File f = new File(name);
        if (!f.isAbsolute()) {
            f = new File(curDir, name);
        }
        return f;
    }

    private String openFile(File curDir, Env args, String s) {
        int idx;
        int line = -1;
        File f = this.findFile(curDir, s);
        if (!f.exists() && (idx = s.lastIndexOf(58)) != -1) {
            try {
                line = Integer.parseInt(s.substring(idx + 1)) - 1;
                f = this.findFile(curDir, s.substring(0, idx));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return OpenFile.openFile(f, line);
    }
}

