/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import org.netbeans.lib.profiler.heap.HprofByteBuffer;
import org.netbeans.lib.profiler.heap.HprofObject;
import org.netbeans.lib.profiler.heap.LoadClassSegment;
import org.netbeans.lib.profiler.heap.StringSegment;

class LoadClass
extends HprofObject {
    private final LoadClassSegment loadClassSegment;

    LoadClass(LoadClassSegment segment, long offset) {
        super(offset);
        this.loadClassSegment = segment;
        assert (this.getHprofBuffer().get(offset) == 2);
    }

    long getClassObjectID() {
        return this.getHprofBuffer().getID(this.fileOffset + (long)this.loadClassSegment.classIDOffset);
    }

    String getName() {
        return LoadClass.convertToName(this.getVMName());
    }

    long getNameID() {
        return this.getHprofBuffer().getID(this.fileOffset + (long)this.loadClassSegment.nameStringIDOffset);
    }

    String getVMName() {
        StringSegment stringSegment = this.loadClassSegment.hprofHeap.getStringSegment();
        return stringSegment.getStringByID(this.getNameID());
    }

    private HprofByteBuffer getHprofBuffer() {
        return this.loadClassSegment.hprofHeap.dumpBuffer;
    }

    private static String convertToName(String vmName) {
        int i;
        String name = vmName.replace('/', '.');
        for (i = 0; i < name.length() && name.charAt(i) == '['; ++i) {
        }
        if (i != 0) {
            char firstChar = (name = name.substring(i)).charAt(0);
            if (firstChar == 'L') {
                name = name.substring(1, name.length() - 1);
            } else {
                switch (firstChar) {
                    case 'C': {
                        name = "char";
                        break;
                    }
                    case 'B': {
                        name = "byte";
                        break;
                    }
                    case 'I': {
                        name = "int";
                        break;
                    }
                    case 'Z': {
                        name = "boolean";
                        break;
                    }
                    case 'F': {
                        name = "float";
                        break;
                    }
                    case 'D': {
                        name = "double";
                        break;
                    }
                    case 'S': {
                        name = "short";
                        break;
                    }
                    case 'J': {
                        name = "long";
                    }
                }
            }
            while (i > 0) {
                name = name.concat("[]");
                --i;
            }
        }
        return name;
    }
}

