/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.netbeans.lib.profiler.heap.ClassDump;
import org.netbeans.lib.profiler.heap.ClassDumpInstance;
import org.netbeans.lib.profiler.heap.ClassDumpSegment;
import org.netbeans.lib.profiler.heap.ComputedSummary;
import org.netbeans.lib.profiler.heap.DominatorTree;
import org.netbeans.lib.profiler.heap.GCRoot;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.HeapProgress;
import org.netbeans.lib.profiler.heap.HeapSummary;
import org.netbeans.lib.profiler.heap.HprofArrayValue;
import org.netbeans.lib.profiler.heap.HprofByteBuffer;
import org.netbeans.lib.profiler.heap.HprofField;
import org.netbeans.lib.profiler.heap.HprofFieldObjectValue;
import org.netbeans.lib.profiler.heap.HprofGCRoot;
import org.netbeans.lib.profiler.heap.HprofInstanceObjectValue;
import org.netbeans.lib.profiler.heap.HprofProxy;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.InstanceDump;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.JavaFrameHprofGCRoot;
import org.netbeans.lib.profiler.heap.LoadClassSegment;
import org.netbeans.lib.profiler.heap.LongMap;
import org.netbeans.lib.profiler.heap.NearestGCRoot;
import org.netbeans.lib.profiler.heap.ObjectArrayDump;
import org.netbeans.lib.profiler.heap.PrimitiveArrayDump;
import org.netbeans.lib.profiler.heap.StackFrameSegment;
import org.netbeans.lib.profiler.heap.StackTraceSegment;
import org.netbeans.lib.profiler.heap.StringSegment;
import org.netbeans.lib.profiler.heap.Summary;
import org.netbeans.lib.profiler.heap.TagBounds;
import org.netbeans.lib.profiler.heap.ThreadObjectHprofGCRoot;
import org.netbeans.lib.profiler.heap.TreeObject;
import org.netbeans.lib.profiler.heap.Value;

class HprofHeap
implements Heap {
    static final int STRING = 1;
    static final int LOAD_CLASS = 2;
    private static final int UNLOAD_CLASS = 3;
    static final int STACK_FRAME = 4;
    static final int STACK_TRACE = 5;
    private static final int ALLOC_SITES = 6;
    static final int HEAP_SUMMARY = 7;
    private static final int START_THREAD = 10;
    private static final int END_THREAD = 11;
    private static final int HEAP_DUMP = 12;
    private static final int HEAP_DUMP_SEGMENT = 28;
    private static final int HEAP_DUMP_END = 44;
    private static final int CPU_SAMPLES = 13;
    private static final int CONTROL_SETTINGS = 14;
    static final int ROOT_UNKNOWN = 255;
    static final int ROOT_JNI_GLOBAL = 1;
    static final int ROOT_JNI_LOCAL = 2;
    static final int ROOT_JAVA_FRAME = 3;
    static final int ROOT_NATIVE_STACK = 4;
    static final int ROOT_STICKY_CLASS = 5;
    static final int ROOT_THREAD_BLOCK = 6;
    static final int ROOT_MONITOR_USED = 7;
    static final int ROOT_THREAD_OBJECT = 8;
    static final int CLASS_DUMP = 32;
    static final int INSTANCE_DUMP = 33;
    static final int OBJECT_ARRAY_DUMP = 34;
    static final int PRIMITIVE_ARRAY_DUMP = 35;
    static final int OBJECT = 2;
    static final int BOOLEAN = 4;
    static final int CHAR = 5;
    static final int FLOAT = 6;
    static final int DOUBLE = 7;
    static final int BYTE = 8;
    static final int SHORT = 9;
    static final int INT = 10;
    static final int LONG = 11;
    private static final boolean DEBUG = false;
    HprofByteBuffer dumpBuffer;
    LongMap idToOffsetMap;
    NearestGCRoot nearestGCRoot;
    private ComputedSummary computedSummary;
    private Map gcRoots;
    private final Object gcRootLock = new Object();
    private TagBounds allInstanceDumpBounds;
    private TagBounds heapDumpSegment;
    private TagBounds[] heapTagBounds;
    private TagBounds[] tagBounds = new TagBounds[255];
    private boolean instancesCountComputed;
    private boolean referencesComputed;
    private boolean retainedSizeComputed;
    private int idMapSize;
    private int segment;

    HprofHeap(File dumpFile, int seg) throws FileNotFoundException, IOException {
        this.dumpBuffer = HprofByteBuffer.createHprofByteBuffer(dumpFile);
        this.segment = seg;
        this.fillTagBounds(this.dumpBuffer.getHeaderSize());
        this.heapDumpSegment = this.computeHeapDumpStart();
        if (this.heapDumpSegment != null) {
            this.fillHeapTagBounds();
        }
        this.idToOffsetMap = new LongMap(this.idMapSize, this.dumpBuffer.getIDSize(), this.dumpBuffer.getFoffsetSize());
        this.nearestGCRoot = new NearestGCRoot(this);
    }

    @Override
    public List getAllClasses() {
        if (this.heapDumpSegment == null) {
            return Collections.EMPTY_LIST;
        }
        ClassDumpSegment classDumpBounds = this.getClassDumpSegment();
        if (classDumpBounds == null) {
            return Collections.EMPTY_LIST;
        }
        return classDumpBounds.createClassCollection();
    }

    @Override
    public List getBiggestObjectsByRetainedSize(int number) {
        ArrayList<Instance> bigObjects = new ArrayList<Instance>(number);
        this.computeRetainedSize();
        long[] ids = this.idToOffsetMap.getBiggestObjectsByRetainedSize(number);
        for (int i = 0; i < ids.length; ++i) {
            bigObjects.add(this.getInstanceByID(ids[i]));
        }
        return bigObjects;
    }

    @Override
    public GCRoot getGCRoot(Instance instance) {
        Long instanceId = instance.getInstanceId();
        return this.getGCRoot(instanceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection getGCRoots() {
        Object object = this.gcRootLock;
        synchronized (object) {
            if (this.heapDumpSegment == null) {
                return Collections.EMPTY_LIST;
            }
            if (this.gcRoots == null) {
                this.gcRoots = this.computeGCRootsFor(this.heapTagBounds[255]);
                this.gcRoots.putAll(this.computeGCRootsFor(this.heapTagBounds[1]));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heapTagBounds[2]));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heapTagBounds[3]));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heapTagBounds[4]));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heapTagBounds[5]));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heapTagBounds[6]));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heapTagBounds[7]));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heapTagBounds[8]));
            }
            return this.gcRoots.values();
        }
    }

    @Override
    public Instance getInstanceByID(long instanceID) {
        if (instanceID == 0L) {
            return null;
        }
        this.computeInstances();
        ClassDumpSegment classDumpBounds = this.getClassDumpSegment();
        int idSize = this.dumpBuffer.getIDSize();
        int classIdOffset = 0;
        LongMap.Entry entry = this.idToOffsetMap.get(instanceID);
        if (entry == null) {
            return null;
        }
        long start = entry.getOffset();
        assert (start != 0L);
        long[] offset = new long[]{start};
        int tag = this.readDumpTag(offset);
        if (tag == 33) {
            classIdOffset = idSize + 4;
        } else if (tag == 34) {
            classIdOffset = idSize + 4 + 4;
        } else if (tag == 35) {
            classIdOffset = idSize + 4 + 4;
        }
        if (tag == 35) {
            ClassDump classDump = classDumpBounds.getPrimitiveArrayClass(this.dumpBuffer.get(start + 1L + (long)classIdOffset));
            return new PrimitiveArrayDump(classDump, start);
        }
        long classId = this.dumpBuffer.getID(start + 1L + (long)classIdOffset);
        ClassDump classDump = classDumpBounds.getClassDumpByID(classId);
        if (tag == 33) {
            return new InstanceDump(classDump, start);
        }
        if (tag == 34) {
            return new ObjectArrayDump(classDump, start);
        }
        if (tag == 32) {
            return new ClassDumpInstance(classDump);
        }
        throw new IllegalArgumentException("Illegal tag " + tag);
    }

    @Override
    public JavaClass getJavaClassByID(long javaclassId) {
        return this.getClassDumpSegment().getClassDumpByID(javaclassId);
    }

    @Override
    public JavaClass getJavaClassByName(String fqn) {
        if (this.heapDumpSegment == null) {
            return null;
        }
        return this.getClassDumpSegment().getJavaClassByName(fqn);
    }

    @Override
    public Collection getJavaClassesByRegExp(String regexp) {
        if (this.heapDumpSegment == null) {
            return Collections.EMPTY_LIST;
        }
        return this.getClassDumpSegment().getJavaClassesByRegExp(regexp);
    }

    @Override
    public synchronized HeapSummary getSummary() {
        TagBounds summaryBound = this.tagBounds[7];
        if (summaryBound != null) {
            return new Summary(this.dumpBuffer, summaryBound.startOffset);
        }
        if (this.computedSummary == null) {
            this.computedSummary = new ComputedSummary(this);
        }
        return this.computedSummary;
    }

    @Override
    public Properties getSystemProperties() {
        Instance props;
        JavaClass systemClass = this.getJavaClassByName("java.lang.System");
        if (systemClass != null && (props = (Instance)systemClass.getValueOfStaticField("props")) != null) {
            return HprofProxy.getProperties(props);
        }
        return null;
    }

    ClassDumpSegment getClassDumpSegment() {
        return (ClassDumpSegment)this.heapTagBounds[32];
    }

    LoadClassSegment getLoadClassSegment() {
        return (LoadClassSegment)this.tagBounds[2];
    }

    StringSegment getStringSegment() {
        return (StringSegment)this.tagBounds[1];
    }

    StackTraceSegment getStackTraceSegment() {
        return (StackTraceSegment)this.tagBounds[5];
    }

    StackFrameSegment getStackFrameSegment() {
        return (StackFrameSegment)this.tagBounds[4];
    }

    TagBounds getAllInstanceDumpBounds() {
        return this.allInstanceDumpBounds;
    }

    int getRetainedSize(Instance instance) {
        this.computeRetainedSize();
        return this.idToOffsetMap.get(instance.getInstanceId()).getRetainedSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GCRoot getGCRoot(Long instanceId) {
        Object object = this.gcRootLock;
        synchronized (object) {
            if (this.gcRoots == null) {
                this.getGCRoots();
            }
            return (GCRoot)this.gcRoots.get(instanceId);
        }
    }

    int getValueSize(byte type) {
        switch (type) {
            case 2: {
                return this.dumpBuffer.getIDSize();
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 8;
            }
            case 8: {
                return 1;
            }
            case 9: {
                return 2;
            }
            case 10: {
                return 4;
            }
            case 11: {
                return 8;
            }
        }
        throw new IllegalArgumentException("Invalid type " + type);
    }

    synchronized void computeInstances() {
        if (this.instancesCountComputed) {
            return;
        }
        ClassDumpSegment classDumpBounds = this.getClassDumpSegment();
        int idSize = this.dumpBuffer.getIDSize();
        long[] offset = new long[]{this.allInstanceDumpBounds.startOffset};
        Map classIdToClassMap = classDumpBounds.getClassIdToClassMap();
        long counter = 0L;
        while (offset[0] < this.allInstanceDumpBounds.endOffset) {
            int classIdOffset = 0;
            int instanceIdOffset = 0;
            ClassDump classDump = null;
            long start = offset[0];
            int tag = this.readDumpTag(offset);
            long instanceId = 0L;
            LongMap.Entry instanceEntry = null;
            if (tag == 33) {
                instanceIdOffset = 1;
                classIdOffset = idSize + 4;
            } else if (tag == 34) {
                instanceIdOffset = 1;
                classIdOffset = idSize + 4 + 4;
            } else if (tag == 35) {
                byte type = this.dumpBuffer.get(start + 1L + (long)idSize + 4L + 4L);
                instanceIdOffset = 1;
                classDump = classDumpBounds.getPrimitiveArrayClass(type);
            }
            if (instanceIdOffset != 0) {
                instanceId = this.dumpBuffer.getID(start + (long)instanceIdOffset);
                instanceEntry = this.idToOffsetMap.put(instanceId, start);
            }
            if (classIdOffset != 0) {
                long classId = this.dumpBuffer.getID(start + 1L + (long)classIdOffset);
                classDump = (ClassDump)classIdToClassMap.get(new Long(classId));
            }
            if (classDump != null) {
                classDump.incrementInstance();
                instanceEntry.setIndex(classDump.getInstancesCount());
                classDumpBounds.addInstanceSize(classDump, tag, start);
            }
            HeapProgress.progress(counter, this.allInstanceDumpBounds.startOffset, start, this.allInstanceDumpBounds.endOffset);
            ++counter;
        }
        HeapProgress.progressFinish();
        this.instancesCountComputed = true;
    }

    List findReferencesFor(long instanceId) {
        assert (instanceId != 0L) : "InstanceID is null";
        this.computeReferences();
        ArrayList<Value> refs = new ArrayList<Value>();
        List refIds = this.idToOffsetMap.get(instanceId).getReferences();
        Iterator refIdsIt = refIds.iterator();
        int idSize = this.dumpBuffer.getIDSize();
        ClassDumpSegment classDumpBounds = this.getClassDumpSegment();
        long[] offset = new long[1];
        while (refIdsIt.hasNext()) {
            long foundInstanceId = (Long)refIdsIt.next();
            offset[0] = this.idToOffsetMap.get(foundInstanceId).getOffset();
            int classIdOffset = 0;
            boolean instanceIdOffset = false;
            long start = offset[0];
            int tag = this.readDumpTag(offset);
            if (tag == 33) {
                classIdOffset = idSize + 4;
                int size = this.dumpBuffer.getInt(start + 1L + (long)idSize + 4L + (long)idSize);
                byte[] fields = new byte[size];
                this.dumpBuffer.get(start + 1L + (long)idSize + 4L + (long)idSize + 4L, fields);
                long classId = this.dumpBuffer.getID(start + 1L + (long)idSize + 4L);
                ClassDump classDump = classDumpBounds.getClassDumpByID(classId);
                InstanceDump instance = new InstanceDump(classDump, start);
                for (Object field : instance.getFieldValues()) {
                    HprofInstanceObjectValue objectValue;
                    if (!(field instanceof HprofInstanceObjectValue) || (objectValue = (HprofInstanceObjectValue)field).getInstanceId() != instanceId) continue;
                    refs.add(objectValue);
                }
                continue;
            }
            if (tag == 34) {
                int elements = this.dumpBuffer.getInt(start + 1L + (long)idSize + 4L);
                long position = start + 1L + (long)idSize + 4L + 4L + (long)idSize;
                int i = 0;
                while (i < elements) {
                    if (this.dumpBuffer.getID(position) == instanceId) {
                        long classId = this.dumpBuffer.getID(start + 1L + (long)idSize + 4L + 4L);
                        ClassDump classDump = classDumpBounds.getClassDumpByID(classId);
                        refs.add(new HprofArrayValue(classDump, start, i));
                    }
                    ++i;
                    position += (long)idSize;
                }
                continue;
            }
            if (tag != 32) continue;
            ClassDump cls = classDumpBounds.getClassDumpByID(foundInstanceId);
            cls.findStaticReferencesFor(instanceId, refs);
        }
        return refs;
    }

    synchronized void computeReferences() {
        if (this.referencesComputed) {
            return;
        }
        ClassDumpSegment classDumpBounds = this.getClassDumpSegment();
        int idSize = this.dumpBuffer.getIDSize();
        long[] offset = new long[]{this.allInstanceDumpBounds.startOffset};
        Map classIdToClassMap = classDumpBounds.getClassIdToClassMap();
        long counter = 0L;
        while (offset[0] < this.allInstanceDumpBounds.endOffset) {
            long start = offset[0];
            int tag = this.readDumpTag(offset);
            if (tag == 33) {
                long classId = this.dumpBuffer.getID(start + 1L + (long)idSize + 4L);
                ClassDump classDump = (ClassDump)classIdToClassMap.get(new Long(classId));
                long instanceId = this.dumpBuffer.getID(start + 1L);
                long inOff = start + 1L + (long)idSize + 4L + (long)idSize + 4L;
                List fields = classDump.getAllInstanceFields();
                for (HprofField field : fields) {
                    LongMap.Entry entry;
                    long outId;
                    if (field.getVauleType() == 2 && (outId = this.dumpBuffer.getID(inOff)) != 0L && (entry = this.idToOffsetMap.get(outId)) != null) {
                        entry.addReference(instanceId);
                    }
                    inOff += (long)field.getValueSize();
                }
            } else if (tag == 34) {
                long instanceId = this.dumpBuffer.getID(start + 1L);
                int elements = this.dumpBuffer.getInt(start + 1L + (long)idSize + 4L);
                long position = start + 1L + (long)idSize + 4L + 4L + (long)idSize;
                int i = 0;
                while (i < elements) {
                    LongMap.Entry entry;
                    long outId = this.dumpBuffer.getID(position);
                    if (outId != 0L && (entry = this.idToOffsetMap.get(outId)) != null) {
                        entry.addReference(instanceId);
                    }
                    ++i;
                    position += (long)idSize;
                }
            }
            HeapProgress.progress(counter, this.allInstanceDumpBounds.startOffset, start, this.allInstanceDumpBounds.endOffset);
            ++counter;
        }
        for (ClassDump classDump : this.getClassDumpSegment().createClassCollection()) {
            List fields = classDump.getStaticFieldValues();
            for (Object field : fields) {
                LongMap.Entry entry;
                long outId;
                if (!(field instanceof HprofFieldObjectValue) || (outId = ((HprofFieldObjectValue)field).getInstanceID()) == 0L || (entry = this.idToOffsetMap.get(outId)) == null) continue;
                entry.addReference(classDump.getJavaClassId());
            }
        }
        this.idToOffsetMap.flush();
        HeapProgress.progressFinish();
        this.referencesComputed = true;
    }

    synchronized void computeRetainedSize() {
        if (this.retainedSizeComputed) {
            return;
        }
        new TreeObject(this, this.nearestGCRoot.getLeaves()).computeTrees();
        DominatorTree domTree = new DominatorTree(this, this.nearestGCRoot.getMultipleParents());
        domTree.computeDominators();
        int idSize = this.dumpBuffer.getIDSize();
        long[] offset = new long[]{this.allInstanceDumpBounds.startOffset};
        while (offset[0] < this.allInstanceDumpBounds.endOffset) {
            LongMap.Entry entry;
            int size;
            int instanceIdOffset = 0;
            long start = offset[0];
            int tag = this.readDumpTag(offset);
            if (tag == 33) {
                instanceIdOffset = 1;
            } else if (tag == 34) {
                instanceIdOffset = 1;
            } else {
                if (tag != 35) continue;
                instanceIdOffset = 1;
            }
            long instanceId = this.dumpBuffer.getID(start + (long)instanceIdOffset);
            LongMap.Entry instanceEntry = this.idToOffsetMap.get(instanceId);
            long idom = domTree.getIdomId(instanceId, instanceEntry);
            boolean isTreeObj = instanceEntry.isTreeObj();
            int instSize = 0;
            if (!(isTreeObj || instanceEntry.getNearestGCRootPointer() == 0L && this.getGCRoot(new Long(instanceId)) == null)) {
                int origSize = instanceEntry.getRetainedSize();
                instSize = this.getInstanceByID(instanceId).getSize();
                instanceEntry.setRetainedSize(origSize + instSize);
            }
            if (idom == 0L) continue;
            Object domPath = null;
            if (isTreeObj) {
                size = instanceEntry.getRetainedSize();
            } else {
                assert (instSize != 0);
                size = instSize;
            }
            while (idom != 0L && !(entry = this.idToOffsetMap.get(idom)).isTreeObj()) {
                int retainedSize = entry.getRetainedSize();
                if (retainedSize < 0) {
                    retainedSize = 0;
                }
                entry.setRetainedSize(retainedSize + size);
                idom = domTree.getIdomId(idom, entry);
            }
        }
        this.retainedSizeComputed = true;
    }

    int readDumpTag(long[] offset) {
        long position = offset[0];
        int dumpTag = this.dumpBuffer.get(position++);
        int size = 0;
        long tagOffset = position;
        int idSize = this.dumpBuffer.getIDSize();
        switch (dumpTag) {
            case -1: 
            case 255: {
                size = idSize;
                dumpTag = 255;
                break;
            }
            case 1: {
                size = 2 * idSize;
                break;
            }
            case 2: {
                size = idSize + 8;
                break;
            }
            case 3: {
                size = idSize + 8;
                break;
            }
            case 4: {
                size = idSize + 4;
                break;
            }
            case 5: {
                size = idSize;
                break;
            }
            case 6: {
                size = idSize + 4;
                break;
            }
            case 7: {
                size = idSize;
                break;
            }
            case 8: {
                size = idSize + 8;
                break;
            }
            case 32: {
                int constantSize = idSize + 4 + 6 * idSize + 4;
                offset[0] = position + (long)constantSize;
                int cpoolSize = this.readConstantPool(offset);
                int sfSize = this.readStaticFields(offset);
                int ifSize = this.readInstanceFields(offset);
                size = constantSize + cpoolSize + sfSize + ifSize;
                break;
            }
            case 33: {
                int fieldSize = this.dumpBuffer.getInt(position + (long)idSize + 4L + (long)idSize);
                size = idSize + 4 + idSize + 4 + fieldSize;
                break;
            }
            case 34: {
                int elements = this.dumpBuffer.getInt(position + (long)idSize + 4L);
                size = idSize + 4 + 4 + idSize + elements * idSize;
                break;
            }
            case 35: {
                int elements = this.dumpBuffer.getInt(position + (long)idSize + 4L);
                byte type = this.dumpBuffer.get(position + (long)idSize + 4L + 4L);
                size = idSize + 4 + 4 + 1 + elements * this.getValueSize(type);
                break;
            }
            case 28: {
                size = 8;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid dump tag " + dumpTag + " at position " + (position - 1L));
            }
        }
        offset[0] = tagOffset + (long)size;
        return dumpTag;
    }

    int readTag(long[] offset) {
        long start = offset[0];
        byte tag = this.dumpBuffer.get(start);
        long len = (long)this.dumpBuffer.getInt(start + 1L + 4L) & 0xFFFFFFFFL;
        offset[0] = start + 1L + 4L + 4L + len;
        return tag;
    }

    private Map computeGCRootsFor(TagBounds tagBounds) {
        HashMap<Long, ThreadObjectHprofGCRoot> roots = new HashMap<Long, ThreadObjectHprofGCRoot>();
        if (tagBounds != null) {
            int rootTag = tagBounds.tag;
            long[] offset = new long[]{tagBounds.startOffset};
            while (offset[0] < tagBounds.endOffset) {
                long start = offset[0];
                if (this.readDumpTag(offset) != rootTag) continue;
                HprofGCRoot root = rootTag == 8 ? new ThreadObjectHprofGCRoot(this, start) : (rootTag == 3 ? new JavaFrameHprofGCRoot(this, start) : new HprofGCRoot(this, start));
                roots.put(root.getInstanceId(), (ThreadObjectHprofGCRoot)root);
            }
        }
        return roots;
    }

    private TagBounds computeHeapDumpStart() throws IOException {
        TagBounds heapDumpBounds = this.tagBounds[12];
        if (heapDumpBounds != null) {
            long start = heapDumpBounds.startOffset;
            long[] offset = new long[]{start};
            int i = 0;
            while (i <= this.segment && start < heapDumpBounds.endOffset) {
                int tag = this.readTag(offset);
                if (tag == 12) {
                    if (i == this.segment) {
                        return new TagBounds(12, start, offset[0]);
                    }
                    ++i;
                }
                start = offset[0];
            }
            throw new IOException("Invalid segment " + this.segment);
        }
        TagBounds heapDumpSegmentBounds = this.tagBounds[28];
        if (heapDumpSegmentBounds != null) {
            long start = heapDumpSegmentBounds.startOffset;
            long end = heapDumpSegmentBounds.endOffset;
            return new TagBounds(12, start, end);
        }
        return null;
    }

    private void fillHeapTagBounds() {
        if (this.heapTagBounds != null) {
            return;
        }
        this.heapTagBounds = new TagBounds[256];
        long[] offset = new long[]{this.heapDumpSegment.startOffset + 1L + 4L + 4L};
        long counter = 0L;
        while (offset[0] < this.heapDumpSegment.endOffset) {
            long start = offset[0];
            int tag = this.readDumpTag(offset);
            TagBounds bounds = this.heapTagBounds[tag];
            long end = offset[0];
            if (bounds == null) {
                TagBounds newBounds = tag == 32 ? new ClassDumpSegment(this, start, end) : new TagBounds(tag, start, end);
                this.heapTagBounds[tag] = newBounds;
            } else {
                bounds.endOffset = end;
            }
            if (tag == 32 || tag == 33 || tag == 34 || tag == 35) {
                ++this.idMapSize;
            }
            HeapProgress.progress(counter, this.heapDumpSegment.startOffset, start, this.heapDumpSegment.endOffset);
            ++counter;
        }
        TagBounds instanceDumpBounds = this.heapTagBounds[33];
        TagBounds objArrayDumpBounds = this.heapTagBounds[34];
        TagBounds primArrayDumpBounds = this.heapTagBounds[35];
        this.allInstanceDumpBounds = instanceDumpBounds.union(objArrayDumpBounds);
        this.allInstanceDumpBounds = this.allInstanceDumpBounds.union(primArrayDumpBounds);
        HeapProgress.progressFinish();
    }

    private void fillTagBounds(long tagStart) {
        long[] offset = new long[]{tagStart};
        while (offset[0] < this.dumpBuffer.capacity()) {
            long start = offset[0];
            int tag = this.readTag(offset);
            TagBounds bounds = this.tagBounds[tag];
            long end = offset[0];
            if (bounds == null) {
                TagBounds newBounds = tag == 2 ? new LoadClassSegment(this, start, end) : (tag == 1 ? new StringSegment(this, start, end) : (tag == 5 ? new StackTraceSegment(this, start, end) : (tag == 4 ? new StackFrameSegment(this, start, end) : new TagBounds(tag, start, end))));
                this.tagBounds[tag] = newBounds;
                continue;
            }
            bounds.endOffset = end;
        }
    }

    private int readConstantPool(long[] offset) {
        long start = offset[0];
        int size = this.dumpBuffer.getShort(start);
        offset[0] = offset[0] + 2L;
        for (int i = 0; i < size; ++i) {
            offset[0] = offset[0] + 2L;
            this.readValue(offset);
        }
        return (int)(offset[0] - start);
    }

    private int readInstanceFields(long[] offset) {
        long position = offset[0];
        short fields = this.dumpBuffer.getShort(offset[0]);
        offset[0] = offset[0] + 2L;
        offset[0] = offset[0] + (long)(fields * (this.dumpBuffer.getIDSize() + 1));
        return (int)(offset[0] - position);
    }

    private int readStaticFields(long[] offset) {
        long start = offset[0];
        int fields = this.dumpBuffer.getShort(start);
        offset[0] = offset[0] + 2L;
        int idSize = this.dumpBuffer.getIDSize();
        for (int i = 0; i < fields; ++i) {
            offset[0] = offset[0] + (long)idSize;
            byte type = this.readValue(offset);
        }
        return (int)(offset[0] - start);
    }

    private byte readValue(long[] offset) {
        long l = offset[0];
        offset[0] = l + 1L;
        byte type = this.dumpBuffer.get(l);
        offset[0] = offset[0] + (long)this.getValueSize(type);
        return type;
    }
}

