/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.hudson.api.HudsonJobBuild;
import org.netbeans.modules.hudson.spi.HudsonJobChangeItem;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public class ShowChanges
extends AbstractAction
implements Runnable {
    private static final Logger LOG = Logger.getLogger(ShowChanges.class.getName());
    private final HudsonJobBuild build;

    public ShowChanges(HudsonJobBuild build) {
        super(NbBundle.getMessage(ShowChanges.class, (String)"ShowChanges.label"));
        this.build = build;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        new RequestProcessor(this.build + "changes").post((Runnable)this);
    }

    @Override
    public void run() {
        String name = NbBundle.getMessage(ShowChanges.class, (String)"ShowChanges.title", (Object)this.build.getDisplayName());
        InputOutput io = IOProvider.getDefault().getIO(name, new Action[0]);
        io.select();
        OutputWriter out = io.getOut();
        OutputWriter err = io.getErr();
        Collection<? extends HudsonJobChangeItem> changes = this.build.getChanges();
        boolean first = true;
        for (HudsonJobChangeItem hudsonJobChangeItem : changes) {
            if (first) {
                first = false;
            } else {
                out.println();
            }
            out.println(hudsonJobChangeItem.getUser() + ": " + hudsonJobChangeItem.getMessage());
            for (HudsonJobChangeItem.HudsonJobChangeFile hudsonJobChangeFile : hudsonJobChangeItem.getFiles()) {
                switch (hudsonJobChangeFile.getEditType()) {
                    case edit: {
                        out.print('\u00b1');
                        break;
                    }
                    case add: {
                        out.print('+');
                        break;
                    }
                    case delete: {
                        out.print('-');
                    }
                }
                out.print(' ');
                OutputListener hyperlink = hudsonJobChangeFile.hyperlink();
                if (hyperlink != null) {
                    try {
                        out.println(hudsonJobChangeFile.getName(), hyperlink);
                    }
                    catch (IOException x) {
                        LOG.log(Level.INFO, null, x);
                    }
                    continue;
                }
                out.println(hudsonJobChangeFile.getName());
            }
        }
        if (first) {
            out.println(NbBundle.getMessage(ShowChanges.class, (String)"ShowChanges.no_changes"));
        }
        out.close();
        err.close();
    }
}

