/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.LogManager;

class NetworkUtils {
    NetworkUtils() {
    }

    public static String getHostName() {
        try {
            String hostName = InetAddress.getLocalHost().getHostName();
            if (hostName != null) {
                return hostName;
            }
        }
        catch (UnknownHostException e) {
            LogManager.log(3, (Throwable)e);
        }
        return "localhost";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isPortAvailable(int port, int ... forbiddenPorts) {
        for (int forbidden : forbiddenPorts) {
            if (port != forbidden) continue;
            return false;
        }
        if (port < 0 && port > 65535) {
            return false;
        }
        String string = Integer.toString(port).intern();
        synchronized (string) {
            ServerSocket socket = null;
            try {
                socket = new ServerSocket(port);
                int i$ = 1;
                return i$ != 0;
            }
            catch (IOException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException e3) {
                        ErrorManager.notifyError("Could not close server socket on port " + port, e3);
                    }
                }
            }
        }
    }

    public static int getAvailablePort(int basePort, int ... forbiddenPorts) {
        int port;
        for (port = basePort; port < 65535 && !NetworkUtils.isPortAvailable(port, forbiddenPorts); ++port) {
        }
        if (port == 65535) {
            for (port = 0; port < basePort && !NetworkUtils.isPortAvailable(port, forbiddenPorts); ++port) {
            }
            if (port == basePort) {
                return -1;
            }
            return port;
        }
        return port;
    }
}

