/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.io.IOException;
import javax.swing.Action;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.IOEvent;
import org.netbeans.core.output2.NbIO;
import org.netbeans.core.output2.NbWriter;
import org.netbeans.core.output2.PairMap;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.IOContainer;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public final class NbIOProvider
extends IOProvider {
    private static final PairMap namesToIos = new PairMap();
    private static final String STDOUT = NbBundle.getMessage(NbIOProvider.class, (String)"LBL_STDOUT");
    private static final String NAME = "output2";

    public OutputWriter getStdOut() {
        if (Controller.LOG) {
            Controller.log("NbIOProvider.getStdOut");
        }
        NbIO stdout = (NbIO)this.getIO(STDOUT, false);
        NbWriter out = stdout.writer();
        NbIO.post(new IOEvent(stdout, 0, true));
        if (out != null && out.isClosed()) {
            try {
                out.reset();
                out = (NbWriter)stdout.getOut();
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
                stdout = (NbIO)this.getIO(STDOUT, true);
                out = (NbWriter)stdout.getOut();
            }
        } else {
            out = (NbWriter)stdout.getOut();
        }
        return out;
    }

    public InputOutput getIO(String name, boolean newIO) {
        return this.getIO(name, newIO, new Action[0], null);
    }

    public InputOutput getIO(String name, Action[] toolbarActions) {
        return this.getIO(name, true, toolbarActions, null);
    }

    public InputOutput getIO(String name, Action[] additionalActions, IOContainer ioContainer) {
        return this.getIO(name, true, additionalActions, ioContainer);
    }

    public String getName() {
        return NAME;
    }

    private InputOutput getIO(String name, boolean newIO, Action[] toolbarActions, IOContainer ioContainer) {
        NbIO result;
        if (Controller.LOG) {
            Controller.log("GETIO: " + name + " new:" + newIO);
        }
        if ((result = namesToIos.get(name)) == null || newIO) {
            result = new NbIO(name, toolbarActions, ioContainer);
            namesToIos.add(name, result);
            NbIO.post(new IOEvent(result, 0, newIO));
        }
        return result;
    }

    static void dispose(NbIO io) {
        namesToIos.remove(io);
    }

    static void setWeak(boolean value) {
        namesToIos.setWeak(value);
    }
}

