/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.StackFrame;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidStackFrameExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocationWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.StackFrameWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.SourcePathProvider;
import org.openide.util.Exceptions;

public class SourcePath {
    private ContextProvider lookupProvider;
    private SourcePathProvider contextProvider;
    private JPDADebugger debugger;

    public SourcePath(ContextProvider contextProvider) {
        this.lookupProvider = contextProvider;
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
    }

    public SourcePathProvider getContext() {
        if (this.contextProvider == null) {
            List list = this.lookupProvider.lookup(null, SourcePathProvider.class);
            this.contextProvider = (SourcePathProvider)list.get(0);
            int n = list.size();
            for (int i = 1; i < n; ++i) {
                this.contextProvider = new CompoundContextProvider((SourcePathProvider)list.get(i), this.contextProvider);
            }
        }
        return this.contextProvider;
    }

    public String getRelativePath(String string, char c, boolean bl) {
        return this.getContext().getRelativePath(string, c, bl);
    }

    public String getSourceRoot(String string) {
        return this.getContext().getSourceRoot(string);
    }

    public String getURL(String string, boolean bl) {
        String string2 = this.getContext().getURL(string, bl);
        if (string2 != null) {
            try {
                new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                Logger.getLogger(SourcePath.class.getName()).log(Level.WARNING, "Malformed URL '" + string2 + "' produced by " + this.getContext(), malformedURLException);
                return null;
            }
        }
        return string2;
    }

    public String getURL(StackFrame stackFrame, String string) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, InvalidStackFrameExceptionWrapper, ObjectCollectedExceptionWrapper {
        try {
            return this.getURL(SourcePath.convertSlash(LocationWrapper.sourcePath(StackFrameWrapper.location(stackFrame), string)), true);
        }
        catch (AbsentInformationException absentInformationException) {
            return this.getURL(SourcePath.convertClassNameToRelativePath(ReferenceTypeWrapper.name(LocationWrapper.declaringType(StackFrameWrapper.location(stackFrame)))), true);
        }
    }

    public String getURL(Location location, String string) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        try {
            return this.getURL(SourcePath.convertSlash(LocationWrapper.sourcePath(location, string)), true);
        }
        catch (AbsentInformationException absentInformationException) {
            return this.getURL(SourcePath.convertClassNameToRelativePath(ReferenceTypeWrapper.name(LocationWrapper.declaringType(location))), true);
        }
    }

    public String[] getSourceRoots() {
        return this.getContext().getSourceRoots();
    }

    public void setSourceRoots(String[] stringArray) {
        this.getContext().setSourceRoots(stringArray);
    }

    public String[] getOriginalSourceRoots() {
        return this.getContext().getOriginalSourceRoots();
    }

    public String[] getProjectSourceRoots() {
        try {
            Method method = this.getContext().getClass().getMethod("getProjectSourceRoots", new Class[0]);
            String[] stringArray = (String[])method.invoke((Object)this.getContext(), new Object[0]);
            return stringArray;
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
            return new String[0];
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getContext().addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getContext().removePropertyChangeListener(propertyChangeListener);
    }

    private static String convertSlash(String string) {
        return string.replace(File.separatorChar, '/');
    }

    public static String convertClassNameToRelativePath(String string) {
        int n = string.indexOf(36);
        if (n > 0) {
            string = string.substring(0, n);
        }
        String string2 = string.replace('.', '/') + ".java";
        return string2;
    }

    private static class CompoundContextProvider
    extends SourcePathProvider {
        private SourcePathProvider cp1;
        private SourcePathProvider cp2;

        CompoundContextProvider(SourcePathProvider sourcePathProvider, SourcePathProvider sourcePathProvider2) {
            this.cp1 = sourcePathProvider;
            this.cp2 = sourcePathProvider2;
        }

        public String getURL(String string, boolean bl) {
            String string2 = this.cp1.getURL(string, bl);
            if (string2 != null) {
                try {
                    new URL(string2);
                    return string2;
                }
                catch (MalformedURLException malformedURLException) {
                    Logger.getLogger(SourcePath.class.getName()).log(Level.WARNING, "Malformed URL '" + string2 + "' produced by " + this.cp1, malformedURLException);
                }
            }
            if ((string2 = this.cp2.getURL(string, bl)) != null) {
                try {
                    new URL(string2);
                }
                catch (MalformedURLException malformedURLException) {
                    Logger.getLogger(SourcePath.class.getName()).log(Level.WARNING, "Malformed URL '" + string2 + "' produced by " + this.cp2, malformedURLException);
                    string2 = null;
                }
            }
            return string2;
        }

        public String getRelativePath(String string, char c, boolean bl) {
            String string2 = this.cp1.getRelativePath(string, c, bl);
            if (string2 != null) {
                return string2;
            }
            return this.cp2.getRelativePath(string, c, bl);
        }

        public String getSourceRoot(String string) {
            String string2 = this.cp1.getSourceRoot(string);
            if (string2 == null) {
                string2 = this.cp2.getSourceRoot(string);
            }
            return string2;
        }

        public String[] getSourceRoots() {
            String[] stringArray = this.cp1.getSourceRoots();
            String[] stringArray2 = this.cp2.getSourceRoots();
            String[] stringArray3 = new String[stringArray.length + stringArray2.length];
            System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
            System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
            return stringArray3;
        }

        public String[] getOriginalSourceRoots() {
            String[] stringArray = this.cp1.getOriginalSourceRoots();
            String[] stringArray2 = this.cp2.getOriginalSourceRoots();
            String[] stringArray3 = new String[stringArray.length + stringArray2.length];
            System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
            System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
            return stringArray3;
        }

        public String[] getProjectSourceRoots() {
            String[] stringArray;
            String[] stringArray2;
            String[] stringArray3;
            try {
                stringArray3 = this.cp1.getClass().getMethod("getProjectSourceRoots", new Class[0]);
                stringArray2 = (String[])stringArray3.invoke((Object)this.cp1, new Object[0]);
            }
            catch (Exception exception) {
                stringArray2 = new String[]{};
            }
            try {
                stringArray3 = this.cp2.getClass().getMethod("getProjectSourceRoots", new Class[0]);
                stringArray = (String[])stringArray3.invoke((Object)this.cp2, new Object[0]);
            }
            catch (Exception exception) {
                stringArray = new String[]{};
            }
            if (stringArray2.length == 0) {
                return stringArray;
            }
            if (stringArray.length == 0) {
                return stringArray2;
            }
            stringArray3 = new String[stringArray2.length + stringArray.length];
            System.arraycopy(stringArray2, 0, stringArray3, 0, stringArray2.length);
            System.arraycopy(stringArray, 0, stringArray3, stringArray2.length, stringArray.length);
            return stringArray3;
        }

        public void setSourceRoots(String[] stringArray) {
            this.cp1.setSourceRoots(stringArray);
            this.cp2.setSourceRoots(stringArray);
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.cp1.addPropertyChangeListener(propertyChangeListener);
            this.cp2.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.cp1.removePropertyChangeListener(propertyChangeListener);
            this.cp2.removePropertyChangeListener(propertyChangeListener);
        }

        public String toString() {
            return "CompoundContextProvider[" + this.cp1.toString() + ", " + this.cp2.toString() + "]";
        }
    }
}

