/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.dependencies;

import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.embedder.MavenEmbedder;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.maven.dependencies.CheckNode;
import org.netbeans.modules.maven.dependencies.CheckNodeListener;
import org.netbeans.modules.maven.dependencies.CheckRenderer;
import org.netbeans.modules.maven.dependencies.DependencyExcludeNodeVisitor;
import org.netbeans.modules.maven.embedder.DependencyTreeFactory;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.openide.NotificationLineSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ExcludeDependencyPanel
extends JPanel {
    private MavenProject project;
    private DependencyNode rootnode;
    private Map<Artifact, TreeModel> modelCache;
    private Map<ChangeListener, CheckNode> change2Trans;
    private Map<ChangeListener, List<CheckNode>> change2Refs;
    private boolean isSingle = false;
    private NotificationLineSupport lineSupport;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTree trRef;
    private JTree trTrans;

    public ExcludeDependencyPanel(MavenProject prj, final Artifact single, final Set<DependencyNode> directs, final DependencyNode root) {
        this.project = prj;
        this.modelCache = new HashMap<Artifact, TreeModel>();
        this.change2Trans = new HashMap<ChangeListener, CheckNode>();
        this.change2Refs = new HashMap<ChangeListener, List<CheckNode>>();
        this.initComponents();
        boolean bl = this.isSingle = single != null;
        if (this.isSingle) {
            this.trTrans.setVisible(false);
            this.jScrollPane1.setVisible(false);
            this.jLabel1.setVisible(false);
        }
        this.trRef.setCellRenderer(new CheckRenderer(false));
        this.trTrans.setCellRenderer(new CheckRenderer(true));
        CheckNodeListener l = new CheckNodeListener(false);
        this.trRef.addMouseListener(l);
        this.trRef.addKeyListener(l);
        this.trRef.setToggleClickCount(0);
        this.trRef.setRootVisible(false);
        this.trTrans.setModel(new DefaultTreeModel(new DefaultMutableTreeNode()));
        this.trRef.setModel(new DefaultTreeModel(new DefaultMutableTreeNode()));
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                if (!ExcludeDependencyPanel.this.isSingle) {
                    ExcludeDependencyPanel.this.rootnode = DependencyTreeFactory.createDependencyTree((MavenProject)ExcludeDependencyPanel.this.project, (MavenEmbedder)EmbedderFactory.getOnlineEmbedder(), (String)Artifact.SCOPE_TEST);
                    ExcludeDependencyPanel.this.trTrans.setModel(new DefaultTreeModel(ExcludeDependencyPanel.this.createTransitiveDependenciesList()));
                } else {
                    ExcludeDependencyPanel.this.rootnode = root;
                    CheckNode nd = new CheckNode(single, null, null);
                    DefaultTreeModel dtm = new DefaultTreeModel(ExcludeDependencyPanel.this.createReferenceModel(directs, nd));
                    ExcludeDependencyPanel.this.modelCache.put(single, dtm);
                    ExcludeDependencyPanel.this.setReferenceTree(nd);
                }
            }
        });
        this.trTrans.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                ExcludeDependencyPanel.this.printSpaceMessage();
            }

            @Override
            public void focusLost(FocusEvent e) {
                ExcludeDependencyPanel.this.printSpaceMessage();
            }
        });
        this.trTrans.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ExcludeDependencyPanel.this.printSpaceMessage();
            }
        });
        this.trTrans.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (32 == e.getKeyCode()) {
                    TreePath path = ExcludeDependencyPanel.this.trTrans.getSelectionPath();
                    CheckNode nd = (CheckNode)path.getLastPathComponent();
                    TreeModel mdl = ExcludeDependencyPanel.this.trRef.getModel();
                    int childs = mdl.getChildCount(mdl.getRoot());
                    for (int i = 0; i < childs; ++i) {
                        CheckNode refNode = (CheckNode)mdl.getChild(mdl.getRoot(), i);
                        refNode.setSelected(true);
                    }
                    ExcludeDependencyPanel.this.trRef.repaint();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
    }

    public ExcludeDependencyPanel(MavenProject prj) {
        this(prj, null, null, null);
    }

    public Map<Artifact, List<DependencyNode>> getDependencyExcludes() {
        HashMap<Artifact, List<DependencyNode>> toRet = new HashMap<Artifact, List<DependencyNode>>();
        for (ChangeListener list : this.change2Trans.keySet()) {
            CheckNode trans = this.change2Trans.get(list);
            List<CheckNode> refs = this.change2Refs.get(list);
            ArrayList<DependencyNode> nds = new ArrayList<DependencyNode>();
            for (CheckNode ref : refs) {
                if (!ref.isSelected()) continue;
                nds.add((DependencyNode)ref.getUserObject());
            }
            toRet.put((Artifact)trans.getUserObject(), nds);
        }
        return toRet;
    }

    public void setStatusDisplayer(NotificationLineSupport createNotificationLineSupport) {
        this.lineSupport = createNotificationLineSupport;
    }

    private void printSpaceMessage() {
        if (this.lineSupport == null) {
            return;
        }
        if (this.trTrans.isFocusOwner() && this.trTrans.getSelectionPath() != null) {
            this.lineSupport.setInformationMessage(NbBundle.getMessage(ExcludeDependencyPanel.class, (String)"TXT_Exclude_all"));
        } else {
            this.lineSupport.clearMessages();
        }
    }

    private TreeNode createReferenceModel(Set<DependencyNode> nds, CheckNode trans) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(null, true);
        Listener list = new Listener();
        ArrayList<CheckNode> s = new ArrayList<CheckNode>();
        Icon icn = ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"org/netbeans/modules/maven/DependencyIcon.png", (boolean)true));
        this.change2Trans.put(list, trans);
        this.change2Refs.put(list, s);
        for (DependencyNode nd : nds) {
            String label = nd.getArtifact().getGroupId() + ":" + nd.getArtifact().getArtifactId();
            CheckNode child = new CheckNode(nd, label, icn);
            child.setSelected(this.isSingle);
            child.addChangeListener(list);
            s.add(child);
            root.add(child);
        }
        return root;
    }

    private TreeNode createTransitiveDependenciesList() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(null, true);
        Set artifacts = this.project.getArtifacts();
        Icon icn = ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"org/netbeans/modules/maven/TransitiveDependencyIcon.png", (boolean)true));
        for (Artifact a : artifacts) {
            if (a.getDependencyTrail().size() <= 2) continue;
            String label = a.getGroupId() + ":" + a.getArtifactId();
            root.add(new CheckNode(a, label, icn));
        }
        return root;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.trTrans = new JTree();
        this.jScrollPane2 = new JScrollPane();
        this.trRef = new JTree();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.trTrans.setRootVisible(false);
        this.trTrans.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                ExcludeDependencyPanel.this.trTransValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.trTrans);
        DefaultMutableTreeNode treeNode1 = new DefaultMutableTreeNode("root");
        this.trRef.setModel(new DefaultTreeModel(treeNode1));
        this.trRef.setRootVisible(false);
        this.jScrollPane2.setViewportView(this.trRef);
        this.jLabel1.setText(NbBundle.getBundle(ExcludeDependencyPanel.class).getString("ExcludeDependencyPanel.jLabel1.text"));
        this.jLabel2.setText(NbBundle.getBundle(ExcludeDependencyPanel.class).getString("ExcludeDependencyPanel.jLabel2.text"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jScrollPane1, -1, 315, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jLabel2).add((Component)this.jScrollPane2, -1, 320, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane2, -1, 363, Short.MAX_VALUE).add((Component)this.jScrollPane1, -1, 363, Short.MAX_VALUE))));
    }

    private void setReferenceTree(CheckNode mtb) {
        Artifact art = (Artifact)mtb.getUserObject();
        if (this.modelCache.containsKey(art)) {
            this.trRef.setModel(this.modelCache.get(art));
        } else if (this.rootnode == null) {
            this.trRef.setModel(new DefaultTreeModel(new DefaultMutableTreeNode()));
        } else {
            DependencyExcludeNodeVisitor nv = new DependencyExcludeNodeVisitor(art.getGroupId(), art.getArtifactId(), art.getType());
            this.rootnode.accept((DependencyNodeVisitor)nv);
            Set<DependencyNode> nds = nv.getDirectDependencies();
            DefaultTreeModel dtm = new DefaultTreeModel(this.createReferenceModel(nds, mtb));
            this.trRef.setModel(dtm);
            this.modelCache.put(art, dtm);
        }
    }

    private void trTransValueChanged(TreeSelectionEvent evt) {
        TreeNode tn = (TreeNode)evt.getPath().getLastPathComponent();
        if (tn instanceof CheckNode) {
            this.setReferenceTree((CheckNode)tn);
        } else {
            this.trRef.setModel(new DefaultTreeModel(new DefaultMutableTreeNode()));
        }
    }

    private class Listener
    implements ChangeListener {
        private Listener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            CheckNode trans = (CheckNode)ExcludeDependencyPanel.this.change2Trans.get(this);
            List refs = (List)ExcludeDependencyPanel.this.change2Refs.get(this);
            boolean all = true;
            boolean some = false;
            for (CheckNode ref : refs) {
                if (!ref.isSelected()) {
                    all = false;
                }
                if (!ref.isSelected()) continue;
                some = true;
            }
            if (all) {
                trans.strike();
            } else {
                trans.unstrike();
            }
            if (some) {
                trans.italic();
            } else {
                trans.unitalic();
            }
            if (ExcludeDependencyPanel.this.trTrans.isVisible()) {
                ExcludeDependencyPanel.this.trTrans.repaint();
            }
        }
    }
}

