/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.fops;

import java.awt.Color;
import java.beans.FeatureDescriptor;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.dlight.api.collector.DataCollectorConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorDataProviderConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorMetadata;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.storage.DataUtil;
import org.netbeans.modules.dlight.api.storage.types.Time;
import org.netbeans.modules.dlight.api.tool.DLightToolConfiguration;
import org.netbeans.modules.dlight.api.visualizer.VisualizerConfiguration;
import org.netbeans.modules.dlight.core.stack.ui.StackRenderer;
import org.netbeans.modules.dlight.dtrace.collector.DTDCConfiguration;
import org.netbeans.modules.dlight.indicators.Aggregation;
import org.netbeans.modules.dlight.indicators.DataRowToTimeSeries;
import org.netbeans.modules.dlight.indicators.DetailDescriptor;
import org.netbeans.modules.dlight.indicators.TimeSeriesDescriptor;
import org.netbeans.modules.dlight.indicators.TimeSeriesIndicatorConfiguration;
import org.netbeans.modules.dlight.spi.tool.DLightToolConfigurationProvider;
import org.netbeans.modules.dlight.util.BytesFormatter;
import org.netbeans.modules.dlight.util.ValueFormatter;
import org.netbeans.modules.dlight.util.ui.Renderer;
import org.netbeans.modules.dlight.visualizers.api.AdvancedTableViewVisualizerConfiguration;
import org.openide.util.NbBundle;

public class FopsToolConfigurationProvider
implements DLightToolConfigurationProvider {
    private static final String ID = "dlight.tool.fops";
    private static final String FILE_COUNT_ID = "file-count";
    private static final int INDICATOR_POSITION = 400;

    public DLightToolConfiguration create() {
        String toolName = FopsToolConfigurationProvider.getMessage("Tool.Name");
        DLightToolConfiguration toolConfiguration = new DLightToolConfiguration(ID, toolName);
        toolConfiguration.setIcon("org/netbeans/modules/dlight/fops/resources/i_o_usage_16.png");
        toolConfiguration.setDescription(FopsToolConfigurationProvider.getMessage("Tool.Description"));
        FeatureDescriptor descriptor = new FeatureDescriptor();
        descriptor.setValue("dtrace.script", this.getScriptUrl());
        toolConfiguration.setFeatureDescriptor(descriptor);
        DataTableMetadata.Column opColumn = new DataTableMetadata.Column("operation", String.class, FopsToolConfigurationProvider.getMessage("Column.OpType"), null);
        DataTableMetadata.Column fileColumn = new DataTableMetadata.Column("file", String.class, FopsToolConfigurationProvider.getMessage("Column.Filename"), null);
        DataTableMetadata.Column sizeColumn = new DataTableMetadata.Column("size", Long.class, FopsToolConfigurationProvider.getMessage("Column.Size"), null);
        DataTableMetadata.Column fileCountColumn = new DataTableMetadata.Column("file_count", Long.class, FopsToolConfigurationProvider.getMessage("Column.FileCount"), null);
        List<DataTableMetadata.Column> fopsColumns = Arrays.asList(new DataTableMetadata.Column("timestamp", Time.class, FopsToolConfigurationProvider.getMessage("Column.Timestamp"), null), opColumn, new DataTableMetadata.Column("sid", Integer.class, FopsToolConfigurationProvider.getMessage("Column.SID"), null), fileColumn, sizeColumn, fileCountColumn, new DataTableMetadata.Column("stack_id", Long.class, FopsToolConfigurationProvider.getMessage("Column.StackId"), null));
        DataTableMetadata dtraceFopsMetadata = new DataTableMetadata("fops", fopsColumns, null);
        DTDCConfiguration dtraceCollectorConfig = new DTDCConfiguration(this.getScriptUrl(), Arrays.asList(dtraceFopsMetadata));
        dtraceCollectorConfig.setStackSupportEnabled(true);
        dtraceCollectorConfig.setIndicatorFiringFactor(1);
        dtraceCollectorConfig.setOutputPrefix("fops:");
        toolConfiguration.addDataCollectorConfiguration((DataCollectorConfiguration)dtraceCollectorConfig);
        toolConfiguration.addIndicatorDataProviderConfiguration((IndicatorDataProviderConfiguration)dtraceCollectorConfig);
        DataTableMetadata.Column openStackColumn = new DataTableMetadata.Column("open_stack_id", Long.class, FopsToolConfigurationProvider.getMessage("Column.OpenStack"), null);
        DataTableMetadata.Column closeStackColumn = new DataTableMetadata.Column("close_stack_id", Long.class, FopsToolConfigurationProvider.getMessage("Column.CloseStack"), null);
        DataTableMetadata.Column statusColumn = new DataTableMetadata.Column("status", String.class, FopsToolConfigurationProvider.getMessage("Column.Status"), null);
        DataTableMetadata detailsMetadata = new DataTableMetadata("iosummary", Arrays.asList(fileColumn, new DataTableMetadata.Column("bytes_read", Long.class, FopsToolConfigurationProvider.getMessage("Column.BytesRead"), null), new DataTableMetadata.Column("bytes_written", Long.class, FopsToolConfigurationProvider.getMessage("Column.BytesWritten"), null), openStackColumn, closeStackColumn, statusColumn), "SELECT file, bytes_read, bytes_written, open_stack_id, close_stack_id, CASEWHEN(open_failed, 'err', CASEWHEN(open_seen AND NOT close_seen, 'warn', 'ok')) AS status FROM (SELECT file, SUM(CASEWHEN(operation='read', size, 0)) AS bytes_read, SUM(CASEWHEN(operation='write', size, 0)) AS bytes_written, SUM(CASEWHEN(operation='open', stack_id, 0)) AS open_stack_id, SUM(CASEWHEN(operation='close', stack_id, 0)) AS close_stack_id, SUM(CASEWHEN(operation='open', timestamp, 0)) AS open_timestamp, BOOL_OR(operation='open') AS open_seen, BOOL_OR(operation='open' AND sid=0) AS open_failed, BOOL_OR(operation='close') AS close_seen FROM fops GROUP BY sid, file) ORDER BY open_timestamp, file", Arrays.asList(dtraceFopsMetadata));
        IndicatorMetadata indicatorMetadata = new IndicatorMetadata(fopsColumns);
        TimeSeriesIndicatorConfiguration indicatorConfiguration = new TimeSeriesIndicatorConfiguration(indicatorMetadata, 400);
        indicatorConfiguration.setPersistencePrefix("dlight_fops");
        indicatorConfiguration.setTitle(FopsToolConfigurationProvider.getMessage("Indicator.Title"));
        indicatorConfiguration.setGraphScale(1024);
        indicatorConfiguration.addTimeSeriesDescriptors(new TimeSeriesDescriptor[]{new TimeSeriesDescriptor("write", FopsToolConfigurationProvider.getMessage("Indicator.Write"), new Color(231, 111, 0), TimeSeriesDescriptor.Kind.LINE), new TimeSeriesDescriptor("read", FopsToolConfigurationProvider.getMessage("Indicator.Read"), new Color(255, 199, 38), TimeSeriesDescriptor.Kind.LINE)});
        indicatorConfiguration.setDataRowHandler((DataRowToTimeSeries)new DataRowToFops(opColumn, sizeColumn, fileCountColumn));
        indicatorConfiguration.setAggregation(Aggregation.SUM);
        indicatorConfiguration.setLastNonNull(false);
        indicatorConfiguration.addDetailDescriptors(new DetailDescriptor[]{new DetailDescriptor(FILE_COUNT_ID, FopsToolConfigurationProvider.getMessage("Indicator.FileCount"), String.valueOf(0))});
        indicatorConfiguration.setActionDisplayName(FopsToolConfigurationProvider.getMessage("Indicator.Action"));
        indicatorConfiguration.setActionTooltip(FopsToolConfigurationProvider.getMessage("Indicator.Action.Tooltip"));
        indicatorConfiguration.setLabelFormatter((ValueFormatter)new BytesFormatter());
        AdvancedTableViewVisualizerConfiguration tableConfiguration = new AdvancedTableViewVisualizerConfiguration(detailsMetadata, fileColumn.getColumnName(), fileColumn.getColumnName());
        tableConfiguration.setHiddenColumnNames(Arrays.asList(openStackColumn.getColumnName(), closeStackColumn.getColumnName(), statusColumn.getColumnName()));
        tableConfiguration.setNodeColumnIcon(statusColumn.getColumnName(), "org/netbeans/modules/dlight/fops/resources");
        tableConfiguration.setEmptyAnalyzeMessage(FopsToolConfigurationProvider.getMessage("Details.EmptyAnalyze"));
        tableConfiguration.setEmptyRunningMessage(FopsToolConfigurationProvider.getMessage("Details.EmptyRunning"));
        tableConfiguration.setDualPaneMode(true);
        tableConfiguration.setDataRowRenderer((Renderer)new StackRenderer(Arrays.asList(openStackColumn, closeStackColumn)));
        indicatorConfiguration.addVisualizerConfiguration((VisualizerConfiguration)tableConfiguration);
        toolConfiguration.addIndicatorConfiguration((IndicatorConfiguration)indicatorConfiguration);
        return toolConfiguration;
    }

    private static String getMessage(String name) {
        return NbBundle.getMessage(FopsToolConfigurationProvider.class, (String)name);
    }

    private URL getScriptUrl() {
        return this.getClass().getResource("resources/fops.d");
    }

    private static class DataRowToFops
    implements DataRowToTimeSeries {
        private final String opColumn;
        private final String sizeColumn;
        private final String fileCountColumn;
        private long fileCount;

        public DataRowToFops(DataTableMetadata.Column opColumn, DataTableMetadata.Column sizeColumn, DataTableMetadata.Column fileCountColumn) {
            this.opColumn = opColumn.getColumnName();
            this.sizeColumn = sizeColumn.getColumnName();
            this.fileCountColumn = fileCountColumn.getColumnName();
        }

        public float[] getData(DataRow row) {
            int newFileCount;
            String op = row.getStringValue(this.opColumn);
            if (op == null) {
                return null;
            }
            int reads = 0;
            int writes = 0;
            if ("read".equals(op) || "write".equals(op)) {
                int bytes = DataUtil.toInt((Object)row.getData(this.sizeColumn));
                if ("read".equals(op)) {
                    reads += bytes;
                } else {
                    writes += bytes;
                }
            }
            if (0 <= (newFileCount = DataUtil.toInt((Object)row.getData(this.fileCountColumn), (int)-1))) {
                this.fileCount = newFileCount;
            }
            return new float[]{writes, reads};
        }

        public Map<String, String> getDetails() {
            return Collections.singletonMap(FopsToolConfigurationProvider.FILE_COUNT_ID, String.valueOf(this.fileCount));
        }
    }
}

