/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.converter.util.MethodDescriptor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class ProxySI {
    public boolean spare;
    Vector<String> sis = new Vector();
    Set<String> m_sigs = new HashSet<String>();
    Hashtable<String, Vector<String>> si_msigs = new Hashtable();
    Hashtable<String, Vector<String>> allInterfaces = new Hashtable();

    public ProxySI() {
    }

    public ProxySI(ProxySI proxySI) {
        this();
        for (Map.Entry<String, Vector<String>> entry : proxySI.allInterfaces.entrySet()) {
            String string = entry.getKey();
            Vector<String> vector = entry.getValue();
            this.addInto(string, vector);
        }
    }

    public ProxySI(String string, Vector<String> vector) {
        this.sis.addElement(string);
        this.m_sigs.addAll(vector);
        this.si_msigs.put(string, vector);
        this.allInterfaces.put(string, vector);
    }

    public void addSI(String string) {
        this.sis.addElement(string);
    }

    public void addMethodSignature(String string) {
        this.m_sigs.add(string);
    }

    public void addMethodSignatures(Vector<String> vector) {
        this.m_sigs.addAll(vector);
    }

    public boolean addInto(String string, Vector<String> vector) {
        HashSet<String> hashSet = new HashSet<String>(vector);
        hashSet.removeAll(this.m_sigs);
        if (this.conflict(string, vector)) {
            return false;
        }
        this.addSI(string);
        this.m_sigs.addAll(vector);
        this.si_msigs.put(string, new Vector<String>(hashSet));
        this.allInterfaces.put(string, vector);
        return true;
    }

    public boolean conflict(String string, Vector<String> vector) {
        String string2;
        HashSet<String> hashSet = new HashSet<String>(vector);
        hashSet.removeAll(this.m_sigs);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String object : this.m_sigs) {
            String string3 = MethodDescriptor.getMethodNameFromSignature(object);
            string2 = MethodDescriptor.getMethodDescriptorFromSignature(object);
            hashMap.put(string3, string2);
        }
        if (hashSet.size() != 0) {
            for (String string3 : hashSet) {
                String string4;
                string2 = MethodDescriptor.getMethodNameFromSignature(string3);
                String string5 = MethodDescriptor.getMethodDescriptorFromSignature(string3);
                if (!hashMap.containsKey(string2) || string5.equals(string4 = (String)hashMap.get(string2))) continue;
                return true;
            }
        }
        return false;
    }

    public Vector<String> getSIs() {
        return this.sis;
    }

    public Set<String> getMethodSignatures() {
        return this.m_sigs;
    }

    public Hashtable<String, Vector<String>> getSIMethodSignatureMappings() {
        return this.si_msigs;
    }

    public Hashtable<String, Vector<String>> getAllInterfaces() {
        return this.allInterfaces;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        ProxySI proxySI = (ProxySI)object;
        if (this.spare != proxySI.spare) {
            return false;
        }
        return this.allInterfaces.equals(proxySI.allInterfaces);
    }

    public boolean isSubsetOf(ProxySI proxySI) {
        if (this == proxySI) {
            return false;
        }
        for (Map.Entry<String, Vector<String>> entry : this.allInterfaces.entrySet()) {
            if (proxySI.alreadyImplementsInterface(entry.getKey())) continue;
            return false;
        }
        return true;
    }

    public boolean alreadyImplementsInterface(String string) {
        Vector<String> vector = this.allInterfaces.get(string);
        return vector != null;
    }
}

