/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugproxy.classparser.attributes;

import com.sun.javacard.debugproxy.Log;
import com.sun.javacard.debugproxy.classparser.attributes.Attribute;
import com.sun.javacard.debugproxy.classparser.attributes.LineNumberTable;
import com.sun.javacard.debugproxy.classparser.constantpoolclasses.ConstantPoolInfo;
import com.sun.javacard.debugproxy.classparser.constantpoolclasses.ConstantUtf8Info;
import java.io.DataInputStream;
import java.io.IOException;

public class LineNumberTableAttribute
extends Attribute {
    private int attributeNameIndex;
    private int attributeLength;
    private int lineNumberTableLength;
    private LineNumberTable[] lineNumberTable;

    public LineNumberTableAttribute(DataInputStream dataInputStream, int n, int n2) throws IOException {
        this.attributeNameIndex = n;
        this.attributeLength = n2;
        this.lineNumberTableLength = dataInputStream.readUnsignedShort();
        this.lineNumberTable = new LineNumberTable[this.lineNumberTableLength];
        for (int i = 0; i < this.lineNumberTableLength; ++i) {
            this.lineNumberTable[i] = new LineNumberTable();
            this.lineNumberTable[i].startPC = dataInputStream.readUnsignedShort();
            this.lineNumberTable[i].lineNumber = dataInputStream.readUnsignedShort();
        }
    }

    public int[][] getLineNumbersAndIndicesAsArray() {
        int[][] nArray = new int[this.lineNumberTableLength][2];
        for (int i = 0; i < this.lineNumberTableLength; ++i) {
            nArray[i][0] = this.lineNumberTable[i].lineNumber;
            nArray[i][1] = this.lineNumberTable[i].startPC;
        }
        return nArray;
    }

    public int getCodeIndexBySourceLineNumber(int n) {
        boolean bl = false;
        int n2 = 0;
        while (!bl && n2 < this.lineNumberTableLength) {
            if (n == this.lineNumberTable[n2].lineNumber) {
                bl = true;
                continue;
            }
            ++n2;
        }
        if (bl) {
            return this.lineNumberTable[n2].startPC;
        }
        return -1;
    }

    public boolean containsLine(int n) {
        boolean bl = false;
        int n2 = 0;
        while (!bl && n2 < this.lineNumberTableLength) {
            if (n == this.lineNumberTable[n2].lineNumber) {
                bl = true;
                continue;
            }
            ++n2;
        }
        return bl;
    }

    private int getIndexThatContainsOpcode(long l) {
        for (int i = 0; i < this.lineNumberTableLength - 1; ++i) {
            if (l < (long)this.lineNumberTable[i].startPC || l >= (long)this.lineNumberTable[i + 1].startPC) continue;
            return i;
        }
        if (l >= (long)this.lineNumberTable[this.lineNumberTableLength - 1].startPC) {
            return this.lineNumberTableLength - 1;
        }
        return -1;
    }

    public int getDupCurrentExecutableLineCodeIndex(long l) {
        int n = this.getNextExecutableLineCodeIndex(l, false);
        if (n == -1) {
            return -1;
        }
        return this.getOtherLineIndex(--n);
    }

    public long getOffsetofDupNextLine(int n) {
        if (n == -1 || n == this.lineNumberTableLength - 1) {
            return -1L;
        }
        return this.lineNumberTable[n + 1].startPC;
    }

    private int getOtherLineIndex(int n) {
        for (int i = 0; i < this.lineNumberTableLength; ++i) {
            if (i == n || this.lineNumberTable[i].lineNumber != this.lineNumberTable[n].lineNumber) continue;
            return i;
        }
        return -1;
    }

    public int getCurrentLineCodeIndex(long l) {
        int n = this.getIndexThatContainsOpcode(l);
        Log.LOGN(3, "getCurrent: index=" + n);
        return n;
    }

    public int getNextExecutableLineCodeIndex(long l) {
        return this.getNextExecutableLineCodeIndex(l, true);
    }

    private int getNextExecutableLineCodeIndex(long l, boolean bl) {
        int n;
        int n2 = this.getIndexThatContainsOpcode(l);
        if (bl) {
            Log.LOGN(3, "getNext: firstIndex=" + n2);
        }
        if ((n = this.getOtherLineIndex(n2)) != -1) {
            if (bl) {
                Log.LOGN(3, "getNext: otherIndex=" + n);
            }
            if (n < n2) {
                if (bl) {
                    Log.LOGN(3, "getNext: otherIndex < firstIndex");
                }
                return n + 1;
            }
            if (bl) {
                Log.LOGN(3, "getNext: otherIndex > firstIndex");
            }
            return n2 + 1;
        }
        if (n2 + 1 < this.lineNumberTableLength) {
            return n2 + 1;
        }
        return -1;
    }

    public long getStartPCFromIndex(int n) {
        if (n == -1) {
            return -1L;
        }
        return this.lineNumberTable[n].startPC;
    }

    public int getLineNumberFromIndex(int n) {
        if (n == -1 || n == this.lineNumberTableLength - 1) {
            return -1;
        }
        return this.lineNumberTable[n].lineNumber;
    }

    @Override
    public String toString(ConstantPoolInfo[] constantPoolInfoArray) {
        String string = new String("");
        ConstantUtf8Info constantUtf8Info = (ConstantUtf8Info)constantPoolInfoArray[this.attributeNameIndex];
        string = string + "\t" + constantUtf8Info.toString();
        return string;
    }
}

