/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.util.Collections;
import java.util.List;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.modules.autoupdate.services.UpdateElementImpl;
import org.netbeans.modules.autoupdate.services.UpdateUnitFactory;
import org.netbeans.modules.autoupdate.updateprovider.InstallInfo;
import org.netbeans.modules.autoupdate.updateprovider.LocalizationItem;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;

public class LocalizationUpdateElementImpl
extends UpdateElementImpl {
    private String codeName;
    private String displayName;
    private SpecificationVersion specVersion;
    private String description;
    private String source;
    private String author;
    private String homepage;
    private int downloadSize;
    private String category;
    private InstallInfo installInfo;
    private LocalizationItem localizationItem;

    public LocalizationUpdateElementImpl(LocalizationItem item, String providerName) {
        super(item, providerName);
        this.codeName = item.getCodeName();
        this.specVersion = item.getSpecificationVersion() == null ? null : new SpecificationVersion(item.getSpecificationVersion());
        this.source = providerName;
        this.installInfo = new InstallInfo(item);
        this.displayName = item.getLocalizedModuleName();
        this.description = item.getLocalizedModuleDescription();
        this.category = item.getCategory();
        this.localizationItem = item;
    }

    @Override
    public String getCodeName() {
        return this.codeName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public SpecificationVersion getSpecificationVersion() {
        return this.specVersion;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getNotification() {
        return null;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public String getHomepage() {
        return this.homepage;
    }

    @Override
    public int getDownloadSize() {
        return this.downloadSize;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public String getCategory() {
        if (this.category == null) {
            this.category = UpdateUnitFactory.UNSORTED_CATEGORY;
        }
        return this.category;
    }

    @Override
    public String getDate() {
        return null;
    }

    @Override
    public String getLicence() {
        return this.localizationItem.getAgreement();
    }

    @Override
    public InstallInfo getInstallInfo() {
        return this.installInfo;
    }

    @Override
    public List<ModuleInfo> getModuleInfos() {
        return Collections.emptyList();
    }

    @Override
    public UpdateManager.TYPE getType() {
        return UpdateManager.TYPE.LOCALIZATION;
    }

    @Override
    public boolean isEnabled() {
        return false;
    }

    @Override
    public boolean isAutoload() {
        return false;
    }

    @Override
    public boolean isEager() {
        return false;
    }

    @Override
    public boolean isFixed() {
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocalizationUpdateElementImpl other = (LocalizationUpdateElementImpl)obj;
        if (!(this.specVersion == other.specVersion || this.specVersion != null && this.specVersion.equals((Object)other.specVersion))) {
            return false;
        }
        return this.codeName == other.codeName || this.codeName != null && this.codeName.equals(other.codeName);
    }

    public int hashCode() {
        int hash = 5;
        hash = 61 * hash + (this.codeName != null ? this.codeName.hashCode() : 0);
        hash = 61 * hash + (this.specVersion != null ? this.specVersion.hashCode() : 0);
        return hash;
    }
}

