/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.EnumSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ui.ElementJavadoc;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.navigation.CaretListeningFactory;
import org.netbeans.modules.java.navigation.ClassMemberPanel;
import org.netbeans.modules.java.navigation.DeclarationTopComponent;
import org.netbeans.modules.java.navigation.JavadocTopComponent;
import org.netbeans.modules.java.navigation.Utils;
import org.openide.filesystems.FileObject;

public class CaretListeningTask
implements CancellableTask<CompilationInfo> {
    private CaretListeningFactory caretListeningFactory;
    private FileObject fileObject;
    private boolean canceled;
    private static ElementHandle<Element> lastEh;
    private static ElementHandle<Element> lastEhForNavigator;
    private static final Set<JavaTokenId> TOKENS_TO_SKIP;

    CaretListeningTask(CaretListeningFactory caretListeningFactory, FileObject fileObject) {
        this.caretListeningFactory = caretListeningFactory;
        this.fileObject = fileObject;
    }

    static void resetLastEH() {
        lastEh = null;
    }

    public void run(CompilationInfo compilationInfo) {
        Object object;
        Object object2;
        this.resume();
        boolean bl = ClassMemberPanel.getInstance() != null;
        boolean bl2 = JavadocTopComponent.shouldUpdate();
        boolean bl3 = DeclarationTopComponent.shouldUpdate();
        if (this.isCancelled() || !bl && !bl2 && !bl3) {
            return;
        }
        int n = CaretListeningFactory.getLastPosition((FileObject)this.fileObject);
        TokenHierarchy tokenHierarchy = compilationInfo.getTokenHierarchy();
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        boolean bl4 = false;
        int n2 = tokenSequence.move(n);
        if (tokenSequence.moveNext() && tokenSequence.token() != null) {
            object2 = tokenSequence.token();
            object = object2.id();
            if (object == JavaTokenId.JAVADOC_COMMENT) {
                bl4 = true;
            }
            if (this.shouldGoBack(object2.toString(), n2 < 0 ? 0 : n2) && tokenSequence.movePrevious()) {
                object2 = tokenSequence.token();
                object = object2.id();
            }
            if (TOKENS_TO_SKIP.contains(object)) {
                this.skipTokens(tokenSequence, TOKENS_TO_SKIP);
            }
            n = tokenSequence.offset();
        }
        if (tokenSequence.token() != null && tokenSequence.token().length() > 1) {
            ++n;
        }
        object2 = compilationInfo.getTreeUtilities().pathFor(n);
        if (this.isCancelled()) {
            return;
        }
        if (bl) {
            this.updateNavigatorSelection(compilationInfo, (TreePath)object2);
        }
        object = compilationInfo.getTrees().getElement((TreePath)object2);
        if (this.isCancelled()) {
            return;
        }
        if (object == null || bl4) {
            object = CaretListeningTask.outerElement(compilationInfo, (TreePath)object2);
        }
        if (this.isCancelled() || object == null) {
            return;
        }
        if (lastEh != null && lastEh.signatureEquals((Element)object) && !bl4) {
            return;
        }
        switch (object.getKind()) {
            case PACKAGE: 
            case CLASS: 
            case INTERFACE: 
            case ENUM: 
            case ANNOTATION_TYPE: 
            case METHOD: 
            case CONSTRUCTOR: 
            case INSTANCE_INIT: 
            case STATIC_INIT: 
            case FIELD: 
            case ENUM_CONSTANT: {
                lastEh = ElementHandle.create((Element)object);
                this.setDeclaration("");
                this.setJavadoc(null);
                break;
            }
            case PARAMETER: {
                object = object.getEnclosingElement();
                lastEh = ElementHandle.create((Element)object);
                this.setDeclaration("");
                this.setJavadoc(null);
                break;
            }
            case LOCAL_VARIABLE: {
                lastEh = null;
                this.setDeclaration(Utils.format((Element)object));
                this.setJavadoc(null);
                return;
            }
            default: {
                this.setDeclaration("");
                this.setJavadoc(null);
                return;
            }
        }
        if (bl2) {
            this.computeAndSetJavadoc(compilationInfo, (Element)object);
        }
        if (this.isCancelled()) {
            return;
        }
        if (bl3) {
            this.computeAndSetDeclaration(compilationInfo, (Element)object);
        }
    }

    private void setDeclaration(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DeclarationTopComponent declarationTopComponent = DeclarationTopComponent.findInstance();
                if (declarationTopComponent != null && declarationTopComponent.isOpened()) {
                    declarationTopComponent.setDeclaration(string);
                }
            }
        });
    }

    private void setJavadoc(final ElementJavadoc elementJavadoc) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JavadocTopComponent javadocTopComponent = JavadocTopComponent.findInstance();
                if (javadocTopComponent != null && javadocTopComponent.isOpened()) {
                    javadocTopComponent.setJavadoc(elementJavadoc);
                }
            }
        });
    }

    public final synchronized void cancel() {
        this.canceled = true;
    }

    protected final synchronized boolean isCancelled() {
        return this.canceled;
    }

    protected final synchronized void resume() {
        this.canceled = false;
    }

    private void computeAndSetJavadoc(CompilationInfo compilationInfo, Element element) {
        if (this.isCancelled()) {
            return;
        }
        this.setJavadoc(ElementJavadoc.create((CompilationInfo)compilationInfo, (Element)element));
    }

    private void computeAndSetDeclaration(CompilationInfo compilationInfo, Element element) {
        if (element.getKind() == ElementKind.PACKAGE) {
            this.setDeclaration("package " + element.toString() + ";");
            return;
        }
        if (this.isCancelled()) {
            return;
        }
        Tree tree = compilationInfo.getTrees().getTree(element);
        if (this.isCancelled()) {
            return;
        }
        if (tree != null) {
            String string = this.unicodeToUtf(tree.toString());
            if (element.getKind() == ElementKind.CONSTRUCTOR) {
                String string2 = element.getEnclosingElement().getSimpleName().toString();
                string = string.replaceAll(Pattern.quote("<init>"), Matcher.quoteReplacement(string2));
            } else if (element.getKind() == ElementKind.METHOD) {
                ExecutableElement executableElement;
                AnnotationValue annotationValue;
                if (string != null && (annotationValue = (executableElement = (ExecutableElement)element).getDefaultValue()) != null) {
                    int n = string.lastIndexOf(";");
                    string = n == -1 ? string + " default " + String.valueOf(annotationValue) + ";" : string.substring(0, n) + " default " + String.valueOf(annotationValue) + string.substring(n);
                }
            } else if (element.getKind() == ElementKind.FIELD) {
                string = string + ";";
            }
            this.setDeclaration(string);
            return;
        }
    }

    private String unicodeToUtf(String string) {
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '\\') {
                char c;
                if ((c = cArray[++i]) == 'u') {
                    int n2;
                    while ((c = cArray[++i]) == 'u') {
                    }
                    int n3 = i + 3;
                    if (n3 >= cArray.length) continue;
                    int n4 = n2 = this.digit(16, cArray[i]);
                    while (i < n3 && n2 >= 0) {
                        c = cArray[++i];
                        n2 = this.digit(16, c);
                        n4 = (n4 << 4) + n2;
                    }
                    if (n2 < 0) continue;
                    cArray[n] = c = (char)n4;
                    ++n;
                    continue;
                }
                --i;
                ++n;
                continue;
            }
            cArray[n] = cArray[i];
            ++n;
        }
        return new String(cArray, 0, n);
    }

    private int digit(int n, char c) {
        char c2 = c;
        int n2 = Character.digit(c2, n);
        if (n2 >= 0 && c2 > '\u007f') {
            c = "0123456789abcdef".charAt(n2);
        }
        return n2;
    }

    private void updateNavigatorSelection(CompilationInfo compilationInfo, TreePath treePath) {
        Element element = CaretListeningTask.outerElement(compilationInfo, treePath);
        if (element != null) {
            final ElementHandle elementHandle = ElementHandle.create((Element)element);
            if (lastEhForNavigator != null && elementHandle.signatureEquals(lastEhForNavigator)) {
                return;
            }
            lastEhForNavigator = elementHandle;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ClassMemberPanel classMemberPanel = ClassMemberPanel.getInstance();
                    if (classMemberPanel != null) {
                        classMemberPanel.selectElement((ElementHandle<Element>)elementHandle);
                    }
                }
            });
        }
    }

    private static Element outerElement(CompilationInfo compilationInfo, TreePath treePath) {
        Element element = null;
        while (treePath != null) {
            switch (treePath.getLeaf().getKind()) {
                case METHOD: 
                case CLASS: 
                case COMPILATION_UNIT: {
                    element = compilationInfo.getTrees().getElement(treePath);
                    break;
                }
                case VARIABLE: {
                    element = compilationInfo.getTrees().getElement(treePath);
                    if (element == null || element.getKind().isField()) break;
                    element = null;
                }
            }
            if (element != null) break;
            treePath = treePath.getParentPath();
        }
        return element;
    }

    private void skipTokens(TokenSequence tokenSequence, Set<JavaTokenId> set) {
        while (tokenSequence.moveNext()) {
            if (set.contains(tokenSequence.token().id())) continue;
            return;
        }
    }

    private boolean shouldGoBack(String string, int n) {
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '\n') continue;
            if (i < n) {
                ++n2;
            } else {
                ++n3;
            }
            if (n3 <= n2) continue;
            return true;
        }
        if (n2 < n3) {
            return false;
        }
        return n < string.length() - n;
    }

    static {
        TOKENS_TO_SKIP = EnumSet.of(JavaTokenId.WHITESPACE, JavaTokenId.BLOCK_COMMENT, JavaTokenId.LINE_COMMENT, JavaTokenId.JAVADOC_COMMENT);
    }
}

