/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wiki;

import com.sun.star.awt.MessageBoxType;
import com.sun.star.awt.XControl;
import com.sun.star.awt.XDialog;
import com.sun.star.awt.XMessageBox;
import com.sun.star.awt.XMessageBoxFactory;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.beans.NamedValue;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XContainerQuery;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.document.XDocumentProperties;
import com.sun.star.document.XDocumentPropertiesSupplier;
import com.sun.star.frame.XModel;
import com.sun.star.frame.XModuleManager;
import com.sun.star.io.XInputStream;
import com.sun.star.io.XOutputStream;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.system.XSystemShellExecute;
import com.sun.star.task.UrlRecord;
import com.sun.star.task.XInteractionHandler;
import com.sun.star.task.XMasterPasswordHandling;
import com.sun.star.task.XPasswordContainer;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.XChangesBatch;
import com.sun.star.wiki.EditPageParser;
import com.sun.star.wiki.MainThreadDialogExecutor;
import com.sun.star.wiki.WikiCancelException;
import com.sun.star.wiki.WikiProtocolSocketFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.net.ssl.SSLException;
import javax.swing.text.html.HTMLEditorKit;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;

public class Helper {
    public static final int GENERALSEND_ERROR = 0;
    public static final int NOWIKIFILTER_ERROR = 1;
    public static final int NOURLCONNECTION_ERROR = 2;
    public static final int WRONGLOGIN_ERROR = 3;
    public static final int INVALIDURL_ERROR = 4;
    public static final int NOURL_ERROR = 5;
    public static final int DLG_SENDTITLE = 6;
    public static final int DLG_WIKIARTICLE = 7;
    public static final int DLG_OK = 9;
    public static final int DLG_ADDBUTTON = 12;
    public static final int DLG_EDITBUTTON = 13;
    public static final int DLG_SENDBUTTON = 14;
    public static final int DLG_REMOVEBUTTON = 15;
    public static final int DLG_EDITSETTING_URLLABEL = 16;
    public static final int DLG_EDITSETTING_USERNAMELABEL = 17;
    public static final int DLG_EDITSETTING_PASSWORDLABEL = 18;
    public static final int DLG_SENDTOMEDIAWIKI_LABEL1 = 20;
    public static final int DLG_SENDTOMEDIAWIKI_LABEL2 = 21;
    public static final int DLG_SENDTOMEDIAWIKI_LABEL3 = 22;
    public static final int DLG_SENDTOMEDIAWIKI_MINORCHECK = 23;
    public static final int DLG_SENDTOMEDIAWIKI_BROWSERCHECK = 24;
    public static final int UNKNOWNCERT_ERROR = 25;
    public static final int DLG_MEDIAWIKI_TITLE = 26;
    public static final int DLG_EDITSETTING_ACCOUNTLINE = 27;
    public static final int DLG_EDITSETTING_WIKILINE = 28;
    public static final int DLG_EDITSETTING_SAVEBOX = 29;
    public static final int CANCELSENDING_ERROR = 30;
    public static final int DLG_MEDIAWIKIEXTENSION_STRING = 31;
    public static final int DLG_WIKIPAGEEXISTS_LABEL1 = 32;
    private static final int STRINGS_NUM = 33;
    private static final String[] m_pEntryNames = new String[]{"GeneralSendError", "NoWikiFilter", "NoConnectionToURL", "WrongLogin", "InvalidURL", "NoURL", "Dlg_SendTitle", "Dlg_WikiArticle", "Dlg_No", "Dlg_OK", "Dlg_Yes", null, "Dlg_AddButton", "Dlg_EditButton", "Dlg_SendButton", "Dlg_RemoveButton", "Dlg_EditSetting_UrlLabel", "Dlg_EditSetting_UsernameLabel", "Dlg_EditSetting_PasswordLabel", "Dlg_NewWikiPage_Label1", "Dlg_SendToMediaWiki_Label1", "Dlg_SendToMediaWiki_Label2", "Dlg_SendToMediaWiki_Label3", "Dlg_SendToMediaWiki_MinorCheck", "Dlg_SendToMediaWiki_BrowserCheck", "UnknownCert", "Dlg_MediaWiki_Title", "Dlg_EditSetting_AccountLine", "Dlg_EditSetting_WikiLine", "Dlg_EditSetting_SaveBox", "CancelSending", "Dlg_MediaWiki_Extension_String", "Dlg_WikiPageExists_Label1"};
    private static String[] m_pConfigStrings;
    private static MultiThreadedHttpConnectionManager m_aConnectionManager;
    private static HttpClient m_aClient;
    private static boolean m_bAllowConnection;
    private static Boolean m_bShowInBrowser;
    private static XPasswordContainer m_xPasswordContainer;
    private static XInteractionHandler m_xInteractionHandler;

    protected static synchronized String GetLocalizedString(XComponentContext xComponentContext, int n) throws com.sun.star.uno.Exception {
        if (n >= 33) {
            throw new RuntimeException();
        }
        if (m_pConfigStrings == null) {
            XNameAccess xNameAccess = Helper.GetConfigNameAccess(xComponentContext, "org.openoffice.Office.Custom.WikiExtension/Strings");
            String[] stringArray = new String[33];
            for (int i = 0; i < 33; ++i) {
                stringArray[i] = m_pEntryNames[i] != null ? AnyConverter.toString((Object)xNameAccess.getByName(m_pEntryNames[i])) : "";
            }
            m_pConfigStrings = stringArray;
        }
        return m_pConfigStrings[n];
    }

    private static synchronized HttpClient GetHttpClient() throws WikiCancelException {
        if (!m_bAllowConnection) {
            throw new WikiCancelException();
        }
        if (m_aConnectionManager == null) {
            m_aConnectionManager = new MultiThreadedHttpConnectionManager();
        }
        if (m_aClient == null) {
            m_aClient = new HttpClient((HttpConnectionManager)m_aConnectionManager);
            m_aClient.getParams().setParameter("http.protocol.cookie-policy", (Object)"compatibility");
            m_aClient.getParams().setParameter("http.protocol.single-cookie-header", (Object)Boolean.TRUE);
            m_aClient.getParams().setParameter("http.protocol.content-charset", (Object)"UTF-8");
        }
        return m_aClient;
    }

    protected static synchronized void AllowConnection(boolean bl) {
        m_bAllowConnection = bl;
        if (!bl && m_aConnectionManager != null) {
            m_aClient = null;
            m_aConnectionManager.shutdown();
            m_aConnectionManager = null;
        }
    }

    protected static synchronized boolean IsConnectionAllowed() {
        return m_bAllowConnection;
    }

    protected static synchronized boolean GetShowInBrowserByDefault(XComponentContext xComponentContext) {
        if (m_bShowInBrowser == null) {
            try {
                XNameAccess xNameAccess = Helper.GetConfigNameAccess(xComponentContext, "org.openoffice.Office.Custom.WikiExtension/Settings");
                m_bShowInBrowser = AnyConverter.toBoolean((Object)xNameAccess.getByName("PreselectShowBrowser"));
            }
            catch (com.sun.star.uno.Exception exception) {
                exception.printStackTrace();
            }
        }
        return m_bShowInBrowser;
    }

    protected static synchronized void SetShowInBrowserByDefault(XComponentContext xComponentContext, boolean bl) {
        try {
            m_bShowInBrowser = bl;
            XPropertySet xPropertySet = Helper.GetConfigProps(xComponentContext, "org.openoffice.Office.Custom.WikiExtension/Settings");
            xPropertySet.setPropertyValue("PreselectShowBrowser", (Object)bl);
            XChangesBatch xChangesBatch = (XChangesBatch)UnoRuntime.queryInterface(XChangesBatch.class, (Object)xPropertySet);
            if (xChangesBatch != null) {
                xChangesBatch.commitChanges();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected static synchronized XPasswordContainer GetPasswordContainer(XComponentContext xComponentContext) throws com.sun.star.uno.Exception {
        XMultiComponentFactory xMultiComponentFactory;
        if (m_xPasswordContainer == null && xComponentContext != null && (xMultiComponentFactory = xComponentContext.getServiceManager()) != null) {
            m_xPasswordContainer = (XPasswordContainer)UnoRuntime.queryInterface(XPasswordContainer.class, (Object)xMultiComponentFactory.createInstanceWithContext("com.sun.star.task.PasswordContainer", xComponentContext));
        }
        if (m_xPasswordContainer == null) {
            throw new RuntimeException();
        }
        return m_xPasswordContainer;
    }

    protected static synchronized XInteractionHandler GetInteractionHandler(XComponentContext xComponentContext) throws com.sun.star.uno.Exception {
        XMultiComponentFactory xMultiComponentFactory;
        if (m_xInteractionHandler == null && xComponentContext != null && (xMultiComponentFactory = xComponentContext.getServiceManager()) != null) {
            m_xInteractionHandler = (XInteractionHandler)UnoRuntime.queryInterface(XInteractionHandler.class, (Object)xMultiComponentFactory.createInstanceWithContext("com.sun.star.task.InteractionHandler", xComponentContext));
        }
        if (m_xInteractionHandler == null) {
            throw new RuntimeException();
        }
        return m_xInteractionHandler;
    }

    private static Protocol GetOwnHttps(int n) {
        return new Protocol("https", (SecureProtocolSocketFactory)new WikiProtocolSocketFactory(), n < 0 ? 443 : n);
    }

    protected static String GetMainURL(String string, String string2) {
        int n;
        String string3 = "";
        try {
            StringReader stringReader = new StringReader(string);
            HTMLEditorKit.Parser parser = Helper.GetHTMLParser();
            EditPageParser editPageParser = new EditPageParser();
            parser.parse(stringReader, editPageParser, true);
            string3 = editPageParser.m_sMainURL;
            if (!string3.startsWith("http")) {
                URL uRL = new URL(string2);
                string3 = uRL.getProtocol() + "://" + uRL.getHost() + string3;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (string3.length() == 0 && (n = string2.indexOf("index.php")) >= 0) {
            string3 = string2.substring(0, n);
        }
        return string3;
    }

    protected static String GetRedirectURL(String string, String string2) {
        int n;
        int n2;
        int n3 = string.indexOf("http-equiv=\"refresh\"");
        if (n3 == -1) {
            return "";
        }
        String string3 = "";
        int n4 = string.indexOf("content=", n3);
        if (n4 > 0 && (n2 = string.indexOf("URL=", n4)) > 0 && (n = string.indexOf(34, n2)) > 0) {
            string3 = string.substring(n2 + 4, n);
        }
        try {
            URL uRL = new URL(string2);
            if (!string3.startsWith(uRL.getProtocol())) {
                string3 = string3.startsWith("/") ? uRL.getProtocol() + "://" + uRL.getHost() + string3 : uRL.getProtocol() + "://" + uRL.getHost() + uRL.getPath() + string3;
            }
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        return string3;
    }

    protected static String CreateTempFile(XComponentContext xComponentContext) {
        String string = "";
        try {
            Object object = xComponentContext.getServiceManager().createInstanceWithContext("com.sun.star.io.TempFile", xComponentContext);
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)object);
            xPropertySet.setPropertyValue("RemoveFile", (Object)Boolean.FALSE);
            string = (String)xPropertySet.getPropertyValue("Uri");
            XInputStream xInputStream = (XInputStream)UnoRuntime.queryInterface(XInputStream.class, (Object)object);
            xInputStream.closeInput();
            XOutputStream xOutputStream = (XOutputStream)UnoRuntime.queryInterface(XOutputStream.class, (Object)object);
            xOutputStream.closeOutput();
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    protected static String EachLine(String string) {
        String string2 = "";
        try {
            URL uRL = new URL(string);
            File file = new File(uRL.getFile());
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            StringBuffer stringBuffer = new StringBuffer();
            String string3 = bufferedReader.readLine();
            while (string3 != null) {
                stringBuffer.append(string3);
                stringBuffer.append("\n");
                string3 = bufferedReader.readLine();
            }
            string2 = stringBuffer.toString();
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    protected static String GetDocTitle(XModel xModel) {
        XDocumentPropertiesSupplier xDocumentPropertiesSupplier = (XDocumentPropertiesSupplier)UnoRuntime.queryInterface(XDocumentPropertiesSupplier.class, (Object)xModel);
        XDocumentProperties xDocumentProperties = xDocumentPropertiesSupplier.getDocumentProperties();
        return xDocumentProperties.getTitle();
    }

    protected static void SetDocTitle(XModel xModel, String string) {
        XDocumentPropertiesSupplier xDocumentPropertiesSupplier = (XDocumentPropertiesSupplier)UnoRuntime.queryInterface(XDocumentPropertiesSupplier.class, (Object)xModel);
        XDocumentProperties xDocumentProperties = xDocumentPropertiesSupplier.getDocumentProperties();
        xDocumentProperties.setTitle(string);
    }

    protected static String GetDocServiceName(XComponentContext xComponentContext, XModel xModel) {
        String string = "";
        if (xModel != null && xComponentContext != null) {
            try {
                XMultiComponentFactory xMultiComponentFactory = xComponentContext.getServiceManager();
                if (xMultiComponentFactory == null) {
                    throw new RuntimeException();
                }
                Object object = xMultiComponentFactory.createInstanceWithContext("com.sun.star.frame.ModuleManager", xComponentContext);
                XModuleManager xModuleManager = (XModuleManager)UnoRuntime.queryInterface(XModuleManager.class, (Object)object);
                if (xModuleManager != null) {
                    string = xModuleManager.identify((Object)xModel);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return string;
    }

    protected static String GetFilterName(XComponentContext xComponentContext, String string, String string2) {
        if (xComponentContext == null || string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            return "";
        }
        String string3 = "";
        try {
            NamedValue[] namedValueArray;
            XEnumeration xEnumeration;
            Object object = xComponentContext.getServiceManager().createInstanceWithContext("com.sun.star.document.FilterFactory", xComponentContext);
            XContainerQuery xContainerQuery = (XContainerQuery)UnoRuntime.queryInterface(XContainerQuery.class, (Object)object);
            if (xContainerQuery != null && (xEnumeration = xContainerQuery.createSubSetEnumerationByProperties(namedValueArray = new NamedValue[]{new NamedValue("Type", (Object)string), new NamedValue("DocumentService", (Object)string2)})) != null) {
                boolean bl = false;
                while (xEnumeration.hasMoreElements() && !bl) {
                    PropertyValue[] propertyValueArray = (PropertyValue[])AnyConverter.toArray((Object)xEnumeration.nextElement());
                    if (propertyValueArray == null) continue;
                    int n = propertyValueArray.length;
                    String string4 = null;
                    for (int i = 0; i < n; ++i) {
                        if (propertyValueArray[i].Name.equals("Name")) {
                            string4 = AnyConverter.toString((Object)propertyValueArray[i].Value);
                            continue;
                        }
                        if (!propertyValueArray[i].Name.equals("Flags")) continue;
                        bl = (AnyConverter.toInt((Object)propertyValueArray[i].Value) & 2) == 2;
                    }
                    if (!bl) continue;
                    string3 = string4;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string3;
    }

    private static XMultiServiceFactory GetConfigurationProvider(XComponentContext xComponentContext) throws com.sun.star.uno.Exception {
        XMultiServiceFactory xMultiServiceFactory = null;
        if (xComponentContext != null) {
            XMultiComponentFactory xMultiComponentFactory = xComponentContext.getServiceManager();
            Object object = xMultiComponentFactory.createInstanceWithContext("com.sun.star.configuration.ConfigurationProvider", xComponentContext);
            xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)object);
        }
        if (xMultiServiceFactory == null) {
            throw new RuntimeException();
        }
        return xMultiServiceFactory;
    }

    private static Object GetConfig(XComponentContext xComponentContext, String string, boolean bl) throws com.sun.star.uno.Exception {
        if (xComponentContext == null || string == null) {
            throw new RuntimeException();
        }
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.Name = "nodepath";
        propertyValue.Value = string;
        Object[] objectArray = new Object[]{propertyValue};
        return Helper.GetConfigurationProvider(xComponentContext).createInstanceWithArguments(bl ? "com.sun.star.configuration.ConfigurationUpdateAccess" : "com.sun.star.configuration.ConfigurationAccess", objectArray);
    }

    private static XPropertySet GetConfigProps(XComponentContext xComponentContext, String string) throws com.sun.star.uno.Exception {
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)Helper.GetConfig(xComponentContext, string, true));
        if (xPropertySet == null) {
            throw new RuntimeException();
        }
        return xPropertySet;
    }

    protected static XNameContainer GetConfigNameContainer(XComponentContext xComponentContext, String string) throws com.sun.star.uno.Exception {
        XNameContainer xNameContainer = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, (Object)Helper.GetConfig(xComponentContext, string, true));
        if (xNameContainer == null) {
            throw new RuntimeException();
        }
        return xNameContainer;
    }

    protected static XNameAccess GetConfigNameAccess(XComponentContext xComponentContext, String string) throws com.sun.star.uno.Exception {
        XNameAccess xNameAccess = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)Helper.GetConfig(xComponentContext, string, false));
        if (xNameAccess == null) {
            throw new RuntimeException();
        }
        return xNameAccess;
    }

    private static void SetConfigurationProxy(HostConfiguration hostConfiguration, XComponentContext xComponentContext) {
        if (hostConfiguration == null || xComponentContext == null) {
            return;
        }
        try {
            XNameAccess xNameAccess = Helper.GetConfigNameAccess(xComponentContext, "org.openoffice.Inet/Settings");
            int n = AnyConverter.toInt((Object)xNameAccess.getByName("ooInetProxyType"));
            if (n == 0) {
                hostConfiguration.setProxyHost(null);
            } else if (n != 1 && n == 2) {
                String string = "ooInetHTTPProxyName";
                String string2 = "ooInetHTTPProxyPort";
                if (hostConfiguration.getProtocol().getScheme().equals("https")) {
                    string = "ooInetHTTPSProxyName";
                    string2 = "ooInetHTTPSProxyPort";
                }
                String string3 = AnyConverter.toString((Object)xNameAccess.getByName(string));
                int n2 = 80;
                Object object = xNameAccess.getByName(string2);
                if (!AnyConverter.isVoid((Object)object)) {
                    n2 = AnyConverter.toInt((Object)object);
                }
                if (n2 == -1) {
                    n2 = 80;
                }
                hostConfiguration.setProxy(string3, n2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected static void ShowURLInBrowser(XComponentContext xComponentContext, String string) {
        if (xComponentContext != null && string != null && string.length() > 0) {
            try {
                Object object = xComponentContext.getServiceManager().createInstanceWithContext("com.sun.star.system.SystemShellExecute", xComponentContext);
                XSystemShellExecute xSystemShellExecute = (XSystemShellExecute)UnoRuntime.queryInterface(XSystemShellExecute.class, (Object)object);
                if (xSystemShellExecute != null) {
                    xSystemShellExecute.execute(string, "", 2);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected static void ExecuteMethod(HttpMethodBase httpMethodBase, HostConfiguration hostConfiguration, URI uRI, XComponentContext xComponentContext, boolean bl) throws WikiCancelException, IOException, SSLException {
        if (httpMethodBase != null && hostConfiguration != null && uRI != null && xComponentContext != null) {
            if (bl) {
                hostConfiguration.setHost(uRI);
                Helper.SetConfigurationProxy(hostConfiguration, xComponentContext);
            }
            if (hostConfiguration.getProtocol().getScheme().equals("https") && Helper.AllowUnknownCert(xComponentContext, uRI.getHost())) {
                hostConfiguration.setHost(hostConfiguration.getHost(), uRI.getPort() < 0 ? 443 : uRI.getPort(), Helper.GetOwnHttps(uRI.getPort()));
                Helper.GetHttpClient().executeMethod(hostConfiguration, (HttpMethod)httpMethodBase);
            } else {
                Helper.GetHttpClient().executeMethod(hostConfiguration, (HttpMethod)httpMethodBase);
            }
        }
    }

    protected static HTMLEditorKit.Parser GetHTMLParser() {
        return new HTMLParse().getParser();
    }

    private static boolean LoginReportsError(String string) {
        boolean bl = true;
        if (string != null) {
            try {
                StringReader stringReader = new StringReader(string);
                HTMLEditorKit.Parser parser = Helper.GetHTMLParser();
                EditPageParser editPageParser = new EditPageParser();
                parser.parse(stringReader, editPageParser, true);
                bl = editPageParser.m_nErrorInd >= 0;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return bl;
    }

    private static String GetLoginToken(String string) {
        String string2 = "";
        if (string != null && string.length() > 0) {
            try {
                StringReader stringReader = new StringReader(string);
                HTMLEditorKit.Parser parser = Helper.GetHTMLParser();
                EditPageParser editPageParser = new EditPageParser();
                parser.parse(stringReader, editPageParser, true);
                string2 = editPageParser.m_sLoginToken;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return string2;
    }

    protected static HostConfiguration Login(URI uRI, String string, String string2, XComponentContext xComponentContext) throws IOException, WikiCancelException {
        HostConfiguration hostConfiguration = null;
        if (string != null && string2 != null && xComponentContext != null) {
            HostConfiguration hostConfiguration2 = new HostConfiguration();
            URI uRI2 = new URI(uRI.toString() + "index.php?title=Special:Userlogin", false);
            GetMethod getMethod = new GetMethod(uRI2.getEscapedPathQuery());
            Helper.ExecuteMethod((HttpMethodBase)getMethod, hostConfiguration2, uRI2, xComponentContext, true);
            int n = getMethod.getStatusCode();
            String string3 = null;
            if (n == 200) {
                string3 = getMethod.getResponseBodyAsString();
            }
            getMethod.releaseConnection();
            if (string3 != null) {
                String string4;
                String[][] stringArray;
                String string5 = Helper.GetLoginToken(string3);
                PostMethod postMethod = new PostMethod();
                URI uRI3 = new URI(uRI.getPath() + "index.php?title=Special:Userlogin&action=submitlogin", false);
                postMethod.setPath(uRI3.getEscapedPathQuery());
                postMethod.addParameter("wpName", string);
                postMethod.addParameter("wpRemember", "1");
                postMethod.addParameter("wpPassword", string2);
                if (string5.length() > 0) {
                    postMethod.addParameter("wpLoginToken", string5);
                }
                if ((stringArray = Helper.GetSpecialArgs(xComponentContext, uRI.getHost())) != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (stringArray[i].length != 2 || stringArray[i][0] == null || stringArray[i][1] == null) continue;
                        postMethod.addParameter(stringArray[i][0], stringArray[i][1]);
                    }
                }
                Helper.ExecuteMethod((HttpMethodBase)postMethod, hostConfiguration2, uRI3, xComponentContext, false);
                n = postMethod.getStatusCode();
                while (n >= 301 && n <= 303 || n == 307) {
                    String string6 = postMethod.getResponseHeader("Location").getValue();
                    postMethod.releaseConnection();
                    uRI2 = new URI(string6);
                    postMethod = new PostMethod();
                    postMethod.setPath(uRI2.getEscapedPathQuery());
                    Helper.ExecuteMethod((HttpMethodBase)postMethod, hostConfiguration2, uRI2, xComponentContext, false);
                    n = postMethod.getStatusCode();
                }
                if (n == 200 && !Helper.LoginReportsError(string4 = postMethod.getResponseBodyAsString())) {
                    hostConfiguration = hostConfiguration2;
                }
                postMethod.releaseConnection();
            }
        }
        return hostConfiguration;
    }

    protected static String[] GetPasswordsForURLAndUser(XComponentContext xComponentContext, String string, String string2) {
        String[] stringArray = null;
        try {
            UrlRecord urlRecord;
            if (xComponentContext != null && string != null && string.length() > 0 && string2 != null && string2.length() > 0 && (urlRecord = Helper.GetPasswordContainer(xComponentContext).findForName(string, string2, Helper.GetInteractionHandler(xComponentContext))) != null && urlRecord.UserList != null && urlRecord.UserList.length > 0 && urlRecord.UserList[0].UserName.equals(string2)) {
                stringArray = urlRecord.UserList[0].Passwords;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringArray;
    }

    protected static boolean PasswordStoringIsAllowed(XComponentContext xComponentContext) {
        boolean bl = false;
        try {
            XMasterPasswordHandling xMasterPasswordHandling = (XMasterPasswordHandling)UnoRuntime.queryInterface(XMasterPasswordHandling.class, (Object)Helper.GetPasswordContainer(xComponentContext));
            if (xMasterPasswordHandling != null) {
                bl = xMasterPasswordHandling.isPersistentStoringAllowed();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    protected static void ShowError(XComponentContext xComponentContext, XDialog xDialog, int n, int n2, String string, boolean bl) {
        XWindowPeer xWindowPeer = null;
        XControl xControl = (XControl)UnoRuntime.queryInterface(XControl.class, (Object)xDialog);
        if (xControl != null) {
            xWindowPeer = xControl.getPeer();
        }
        Helper.ShowError(xComponentContext, xWindowPeer, n, n2, string, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean ShowError(XComponentContext xComponentContext, XWindowPeer xWindowPeer, int n, int n2, String string, boolean bl) {
        boolean bl2 = false;
        if (xComponentContext != null && n2 >= 0 && n2 < 33) {
            String string2 = null;
            String string3 = "";
            try {
                string2 = Helper.GetLocalizedString(xComponentContext, n2);
                if (string2 != null && string != null) {
                    string2 = string2.replaceAll("\\$ARG1", string);
                }
                string3 = Helper.GetLocalizedString(xComponentContext, n);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (string2 == null) {
                string2 = "Error: " + n2;
            }
            if (xWindowPeer != null) {
                XMessageBoxFactory xMessageBoxFactory = null;
                XMessageBox xMessageBox = null;
                try {
                    XMultiComponentFactory xMultiComponentFactory = xComponentContext.getServiceManager();
                    if (xMultiComponentFactory != null) {
                        xMessageBoxFactory = (XMessageBoxFactory)UnoRuntime.queryInterface(XMessageBoxFactory.class, (Object)xMultiComponentFactory.createInstanceWithContext("com.sun.star.awt.Toolkit", xComponentContext));
                    }
                    if (xMessageBoxFactory != null && (xMessageBox = bl ? xMessageBoxFactory.createMessageBox(xWindowPeer, MessageBoxType.QUERYBOX, 327683, string3, string2) : xMessageBoxFactory.createMessageBox(xWindowPeer, MessageBoxType.ERRORBOX, 1, string3, string2)) != null) {
                        bl2 = MainThreadDialogExecutor.Execute(xComponentContext, xMessageBox);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                finally {
                    if (xMessageBox != null) {
                        Helper.Dispose(xMessageBox);
                    }
                }
            }
        }
        return bl2;
    }

    private static boolean AllowUnknownCert(XComponentContext xComponentContext, String string) {
        try {
            XNameAccess xNameAccess;
            XNameAccess xNameAccess2 = Helper.GetConfigNameAccess(xComponentContext, "org.openoffice.Office.Custom.WikiExtension/SpecialData");
            if (xNameAccess2.hasByName(string) && (xNameAccess = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)xNameAccess2.getByName(string))) != null && xNameAccess.hasByName("AllowUnknownCertificate")) {
                return AnyConverter.toBoolean((Object)xNameAccess.getByName("AllowUnknownCertificate"));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    private static String[][] GetSpecialArgs(XComponentContext xComponentContext, String string) {
        try {
            String[] stringArray;
            XNameAccess xNameAccess;
            XNameAccess xNameAccess2;
            XNameAccess xNameAccess3 = Helper.GetConfigNameAccess(xComponentContext, "org.openoffice.Office.Custom.WikiExtension/SpecialData");
            if (xNameAccess3.hasByName(string) && (xNameAccess2 = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)xNameAccess3.getByName(string))) != null && (xNameAccess = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)xNameAccess2.getByName("AdditionalLoginArguments"))) != null && (stringArray = xNameAccess.getElementNames()) != null && stringArray.length > 0) {
                String[][] stringArray2 = new String[stringArray.length][2];
                for (int i = 0; i < stringArray.length; ++i) {
                    XNameAccess xNameAccess4 = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)xNameAccess.getByName(stringArray[i]));
                    if (xNameAccess4 == null) {
                        throw new RuntimeException();
                    }
                    stringArray2[i][0] = stringArray[i];
                    stringArray2[i][1] = AnyConverter.toString((Object)xNameAccess4.getByName("Value"));
                }
                return stringArray2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    protected static boolean AllowThreadUsage(XComponentContext xComponentContext) {
        if (xComponentContext != null) {
            try {
                XMultiComponentFactory xMultiComponentFactory = xComponentContext.getServiceManager();
                if (xMultiComponentFactory == null) {
                    throw new RuntimeException();
                }
                Object object = xMultiComponentFactory.createInstanceWithContext("com.sun.star.awt.AsyncCallback", xComponentContext);
                return object != null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return false;
    }

    public static void Dispose(Object object) {
        if (object != null) {
            try {
                XComponent xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)object);
                if (xComponent != null) {
                    xComponent.dispose();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    static {
        m_bAllowConnection = true;
        m_bShowInBrowser = null;
    }

    private static class HTMLParse
    extends HTMLEditorKit {
        private HTMLParse() {
        }

        public HTMLEditorKit.Parser getParser() {
            return super.getParser();
        }
    }
}

