/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.toolchain.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.toolchain.io.ToolchainsParseException;
import org.apache.maven.toolchain.io.ToolchainsReader;
import org.apache.maven.toolchain.model.PersistedToolchains;
import org.apache.maven.toolchain.model.io.xpp3.MavenToolchainsXpp3Reader;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Named
@Singleton
public class DefaultToolchainsReader
implements ToolchainsReader {
    @Override
    public PersistedToolchains read(File input, Map<String, ?> options) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("input file missing");
        }
        return this.read((Reader)ReaderFactory.newXmlReader((File)input), options);
    }

    @Override
    public PersistedToolchains read(Reader input, Map<String, ?> options) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("input reader missing");
        }
        try {
            MavenToolchainsXpp3Reader r = new MavenToolchainsXpp3Reader();
            PersistedToolchains persistedToolchains = r.read(input, this.isStrict(options));
            return persistedToolchains;
        }
        catch (XmlPullParserException e) {
            throw new ToolchainsParseException(e.getMessage(), e.getLineNumber(), e.getColumnNumber(), e);
        }
        finally {
            IOUtil.close((Reader)input);
        }
    }

    @Override
    public PersistedToolchains read(InputStream input, Map<String, ?> options) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("input stream missing");
        }
        try {
            MavenToolchainsXpp3Reader r = new MavenToolchainsXpp3Reader();
            PersistedToolchains persistedToolchains = r.read(input, this.isStrict(options));
            return persistedToolchains;
        }
        catch (XmlPullParserException e) {
            throw new ToolchainsParseException(e.getMessage(), e.getLineNumber(), e.getColumnNumber(), e);
        }
        finally {
            IOUtil.close((InputStream)input);
        }
    }

    private boolean isStrict(Map<String, ?> options) {
        Object value = options != null ? (Object)options.get("org.apache.maven.toolchains.io.isStrict") : null;
        return value == null || Boolean.parseBoolean(value.toString());
    }
}

