/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.layouts.rubinius;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.lang.ref.WeakReference;
import java.util.EnumSet;
import org.jruby.truffle.om.dsl.api.UnexpectedLayoutRefusalException;
import org.jruby.truffle.runtime.layouts.BasicObjectLayoutImpl;
import org.jruby.truffle.runtime.layouts.rubinius.WeakRefLayout;

public class WeakRefLayoutImpl
extends BasicObjectLayoutImpl
implements WeakRefLayout {
    public static final WeakRefLayout INSTANCE = new WeakRefLayoutImpl();
    protected static final Shape.Allocator WEAK_REF_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey REFERENCE_IDENTIFIER = new HiddenKey("reference");
    protected static final Property REFERENCE_PROPERTY = Property.create(REFERENCE_IDENTIFIER, WEAK_REF_ALLOCATOR.locationForType(WeakReference.class, EnumSet.of(LocationModifier.NonNull)), 0);

    protected WeakRefLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createWeakRefShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape(new WeakRefType(logicalClass, metaClass)).addProperty(REFERENCE_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createWeakRef(DynamicObjectFactory factory, WeakReference<Object> reference) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant(factory);
        assert (this.createsWeakRef(factory));
        assert (factory.getShape().hasProperty(REFERENCE_IDENTIFIER));
        assert (reference != null);
        return factory.newInstance(reference);
    }

    private boolean isWeakRef(DynamicObject object) {
        return this.isWeakRef(object.getShape().getObjectType());
    }

    private boolean isWeakRef(ObjectType objectType) {
        return objectType instanceof WeakRefType;
    }

    private boolean createsWeakRef(DynamicObjectFactory factory) {
        return this.isWeakRef(factory.getShape().getObjectType());
    }

    @Override
    public WeakReference<Object> getReference(DynamicObject object) {
        assert (this.isWeakRef(object));
        assert (object.getShape().hasProperty(REFERENCE_IDENTIFIER));
        return (WeakReference)REFERENCE_PROPERTY.get(object, true);
    }

    @Override
    public void setReference(DynamicObject object, WeakReference<Object> value) {
        assert (this.isWeakRef(object));
        assert (object.getShape().hasProperty(REFERENCE_IDENTIFIER));
        assert (value != null);
        try {
            REFERENCE_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    protected static class WeakRefType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public WeakRefType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public WeakRefType setLogicalClass(DynamicObject logicalClass) {
            return new WeakRefType(logicalClass, this.metaClass);
        }

        @Override
        public WeakRefType setMetaClass(DynamicObject metaClass) {
            return new WeakRefType(this.logicalClass, metaClass);
        }
    }
}

