/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.layouts;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import org.jruby.truffle.runtime.layouts.BasicObjectLayoutImpl;
import org.jruby.truffle.runtime.layouts.LongFixnumRangeLayout;

public class LongFixnumRangeLayoutImpl
extends BasicObjectLayoutImpl
implements LongFixnumRangeLayout {
    public static final LongFixnumRangeLayout INSTANCE = new LongFixnumRangeLayoutImpl();
    protected static final Shape.Allocator LONG_FIXNUM_RANGE_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey EXCLUDED_END_IDENTIFIER = new HiddenKey("excludedEnd");
    protected static final Property EXCLUDED_END_PROPERTY = Property.create(EXCLUDED_END_IDENTIFIER, LONG_FIXNUM_RANGE_ALLOCATOR.locationForType(Boolean.TYPE, EnumSet.of(LocationModifier.NonNull)), 0);
    protected static final HiddenKey BEGIN_IDENTIFIER = new HiddenKey("begin");
    protected static final Property BEGIN_PROPERTY = Property.create(BEGIN_IDENTIFIER, LONG_FIXNUM_RANGE_ALLOCATOR.locationForType(Long.TYPE, EnumSet.of(LocationModifier.NonNull)), 0);
    protected static final HiddenKey END_IDENTIFIER = new HiddenKey("end");
    protected static final Property END_PROPERTY = Property.create(END_IDENTIFIER, LONG_FIXNUM_RANGE_ALLOCATOR.locationForType(Long.TYPE, EnumSet.of(LocationModifier.NonNull)), 0);

    protected LongFixnumRangeLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createLongFixnumRangeShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape(new LongFixnumRangeType(logicalClass, metaClass)).addProperty(EXCLUDED_END_PROPERTY).addProperty(BEGIN_PROPERTY).addProperty(END_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createLongFixnumRange(DynamicObjectFactory factory, boolean excludedEnd, long begin, long end) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant(factory);
        assert (this.createsLongFixnumRange(factory));
        assert (factory.getShape().hasProperty(EXCLUDED_END_IDENTIFIER));
        assert (factory.getShape().hasProperty(BEGIN_IDENTIFIER));
        assert (factory.getShape().hasProperty(END_IDENTIFIER));
        return factory.newInstance(excludedEnd, begin, end);
    }

    @Override
    public boolean isLongFixnumRange(Object object) {
        return object instanceof DynamicObject && this.isLongFixnumRange((DynamicObject)object);
    }

    @Override
    public boolean isLongFixnumRange(DynamicObject object) {
        return this.isLongFixnumRange(object.getShape().getObjectType());
    }

    private boolean isLongFixnumRange(ObjectType objectType) {
        return objectType instanceof LongFixnumRangeType;
    }

    private boolean createsLongFixnumRange(DynamicObjectFactory factory) {
        return this.isLongFixnumRange(factory.getShape().getObjectType());
    }

    @Override
    public boolean getExcludedEnd(DynamicObject object) {
        assert (this.isLongFixnumRange(object));
        assert (object.getShape().hasProperty(EXCLUDED_END_IDENTIFIER));
        return (Boolean)EXCLUDED_END_PROPERTY.get(object, true);
    }

    @Override
    public long getBegin(DynamicObject object) {
        assert (this.isLongFixnumRange(object));
        assert (object.getShape().hasProperty(BEGIN_IDENTIFIER));
        return (Long)BEGIN_PROPERTY.get(object, true);
    }

    @Override
    public long getEnd(DynamicObject object) {
        assert (this.isLongFixnumRange(object));
        assert (object.getShape().hasProperty(END_IDENTIFIER));
        return (Long)END_PROPERTY.get(object, true);
    }

    protected static class LongFixnumRangeType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public LongFixnumRangeType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public LongFixnumRangeType setLogicalClass(DynamicObject logicalClass) {
            return new LongFixnumRangeType(logicalClass, this.metaClass);
        }

        @Override
        public LongFixnumRangeType setMetaClass(DynamicObject metaClass) {
            return new LongFixnumRangeType(this.logicalClass, metaClass);
        }
    }
}

