/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.methods;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.ReturnID;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.ReturnException;

public class CatchReturnNode
extends RubyNode {
    @Node.Child
    private RubyNode body;
    private final ReturnID returnID;
    private final BranchProfile returnProfile = BranchProfile.create();
    private final BranchProfile returnToOtherMethodProfile = BranchProfile.create();

    public CatchReturnNode(RubyContext context, SourceSection sourceSection, RubyNode body, ReturnID returnID) {
        super(context, sourceSection);
        this.body = body;
        this.returnID = returnID;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        try {
            return this.body.execute(frame);
        }
        catch (ReturnException e) {
            this.returnProfile.enter();
            if (e.getReturnID() == this.returnID) {
                return e.getValue();
            }
            this.returnToOtherMethodProfile.enter();
            throw e;
        }
    }
}

