/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object.basic;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.BooleanLocation;
import com.oracle.truffle.api.object.DoubleLocation;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.IntLocation;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LongLocation;
import com.oracle.truffle.api.object.ObjectLocation;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.object.LocationImpl;
import java.lang.invoke.MethodHandle;

public abstract class BasicLocations {
    static final int LONG_SIZE = 1;
    static final int OBJECT_SIZE = 1;

    public static abstract class ArrayLocation
    extends LocationImpl {
        protected final int index;
        protected final Location arrayLocation;

        public ArrayLocation(int index, Location arrayLocation) {
            this.index = index;
            this.arrayLocation = arrayLocation;
        }

        protected final Object getArray(DynamicObject store, boolean condition) {
            return this.arrayLocation.get(store, condition);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.index;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            ArrayLocation other = (ArrayLocation)obj;
            return this.index == other.index;
        }

        public final int getIndex() {
            return this.index;
        }

        @Override
        protected String getWhereString() {
            return "[" + this.index + "]";
        }
    }

    public static class BooleanLocationDecorator
    extends PrimitiveLocationDecorator
    implements BooleanLocation {
        public BooleanLocationDecorator(LocationImpl.InternalLongLocation longLocation) {
            super(longLocation);
        }

        @Override
        public final Object get(DynamicObject store, boolean condition) {
            return this.getBoolean(store, condition);
        }

        @Override
        public boolean getBoolean(DynamicObject store, boolean condition) {
            return this.getLong(store, condition) != 0L;
        }

        @Override
        public void setBoolean(DynamicObject store, boolean value, Shape shape) {
            this.setLongInternal(store, value ? 1 : 0);
        }

        @Override
        public void setBoolean(DynamicObject store, boolean value) {
            this.setBoolean(store, value, null);
        }

        @Override
        public final void setInternal(DynamicObject store, Object value) throws IncompatibleLocationException {
            if (!this.canStore(value)) {
                throw BooleanLocationDecorator.incompatibleLocation();
            }
            this.setBoolean(store, (Boolean)value, null);
        }

        @Override
        public final boolean getBoolean(DynamicObject store, Shape shape) {
            return this.getBoolean(store, BooleanLocationDecorator.checkShape(store, shape));
        }

        @Override
        public final boolean canStore(Object value) {
            return value instanceof Boolean;
        }

        @Override
        public final void setBoolean(DynamicObject store, boolean value, Shape oldShape, Shape newShape) {
            store.setShapeAndGrow(oldShape, newShape);
            this.setBoolean(store, value, newShape);
        }

        @Override
        public Class<Boolean> getType() {
            return Boolean.TYPE;
        }
    }

    public static class DoubleLocationDecorator
    extends PrimitiveLocationDecorator
    implements DoubleLocation {
        private final boolean allowInt;

        public DoubleLocationDecorator(LocationImpl.InternalLongLocation longLocation, boolean allowInt) {
            super(longLocation);
            this.allowInt = allowInt;
        }

        @Override
        public final Object get(DynamicObject store, boolean condition) {
            return this.getDouble(store, condition);
        }

        @Override
        public double getDouble(DynamicObject store, boolean condition) {
            return Double.longBitsToDouble(this.getLong(store, condition));
        }

        @Override
        public void setDouble(DynamicObject store, double value, Shape shape) {
            this.setLongInternal(store, Double.doubleToRawLongBits(value));
        }

        @Override
        public void setDouble(DynamicObject store, double value) {
            this.setDouble(store, value, null);
        }

        @Override
        public final void setInternal(DynamicObject store, Object value) throws IncompatibleLocationException {
            if (!this.canStore(value)) {
                throw DoubleLocationDecorator.incompatibleLocation();
            }
            this.setDouble(store, ((Number)value).doubleValue(), null);
        }

        @Override
        public final double getDouble(DynamicObject store, Shape shape) {
            return this.getDouble(store, DoubleLocationDecorator.checkShape(store, shape));
        }

        @Override
        public final boolean canStore(Object value) {
            return value instanceof Double || this.allowInt && value instanceof Integer;
        }

        @Override
        public final void setDouble(DynamicObject store, double value, Shape oldShape, Shape newShape) {
            store.setShapeAndGrow(oldShape, newShape);
            this.setDouble(store, value, newShape);
        }

        @Override
        public Class<Double> getType() {
            return Double.TYPE;
        }
    }

    public static abstract class FieldLocation
    extends LocationImpl {
        private final int index;

        public FieldLocation(int index) {
            this.index = index;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.index;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            FieldLocation other = (FieldLocation)obj;
            return this.index == other.index;
        }

        public final int getIndex() {
            return this.index;
        }

        @Override
        protected String getWhereString() {
            return "@" + this.index;
        }
    }

    public static class IntLocationDecorator
    extends PrimitiveLocationDecorator
    implements IntLocation {
        public IntLocationDecorator(LocationImpl.InternalLongLocation longLocation) {
            super(longLocation);
        }

        @Override
        public final Object get(DynamicObject store, boolean condition) {
            return this.getInt(store, condition);
        }

        @Override
        public int getInt(DynamicObject store, boolean condition) {
            return (int)this.getLong(store, condition);
        }

        @Override
        public void setInt(DynamicObject store, int value, Shape shape) throws FinalLocationException {
            this.setLong(store, value, shape);
        }

        @Override
        public final void setInt(DynamicObject store, int value) throws FinalLocationException {
            this.setInt(store, value, null);
        }

        @Override
        public final void setInternal(DynamicObject store, Object value) throws IncompatibleLocationException {
            if (!this.canStore(value)) {
                throw IntLocationDecorator.incompatibleLocation();
            }
            this.setLongInternal(store, ((Integer)value).intValue());
        }

        @Override
        public final int getInt(DynamicObject store, Shape shape) {
            return this.getInt(store, IntLocationDecorator.checkShape(store, shape));
        }

        @Override
        public final boolean canStore(Object value) {
            return value instanceof Integer;
        }

        @Override
        public final void setInt(DynamicObject store, int value, Shape oldShape, Shape newShape) {
            store.setShapeAndGrow(oldShape, newShape);
            this.setLongInternal(store, value);
        }

        @Override
        public Class<Integer> getType() {
            return Integer.TYPE;
        }
    }

    public static class LongArrayLocation
    extends ArrayLocation
    implements LocationImpl.InternalLongLocation {
        protected final boolean allowInt;

        public LongArrayLocation(int index, Location arrayLocation, boolean allowInt) {
            super(index, arrayLocation);
            this.allowInt = allowInt;
        }

        public LongArrayLocation(int index, Location arrayLocation) {
            this(index, arrayLocation, false);
        }

        @Override
        public final Object get(DynamicObject store, boolean condition) {
            return this.getLong(store, condition);
        }

        @Override
        public final void setInternal(DynamicObject store, Object value) throws IncompatibleLocationException {
            if (!this.canStore(value)) {
                throw LongArrayLocation.incompatibleLocation();
            }
            this.setLongInternal(store, ((Number)value).longValue());
        }

        @Override
        public long getLong(DynamicObject store, boolean condition) {
            return ((long[])this.getArray(store, condition))[this.index];
        }

        @Override
        public final void setLongInternal(DynamicObject store, long value) {
            ((long[])this.getArray((DynamicObject)store, (boolean)false))[this.index] = value;
        }

        @Override
        public void setLong(DynamicObject store, long value, Shape shape) throws FinalLocationException {
            this.setLongInternal(store, value);
        }

        @Override
        public final void setLong(DynamicObject store, long value, Shape oldShape, Shape newShape) {
            store.setShapeAndGrow(oldShape, newShape);
            this.setLongInternal(store, value);
        }

        @Override
        public final void setLong(DynamicObject store, long value) throws FinalLocationException {
            this.setLong(store, value, null);
        }

        @Override
        public final long getLong(DynamicObject store, Shape shape) {
            return this.getLong(store, LongArrayLocation.checkShape(store, shape));
        }

        @Override
        public final boolean canStore(Object value) {
            return value instanceof Long || this.allowInt && value instanceof Integer;
        }

        @Override
        public final Class<Long> getType() {
            return Long.TYPE;
        }

        @Override
        public int primitiveArrayCount() {
            return 1;
        }

        @Override
        public final void accept(LocationImpl.LocationVisitor locationVisitor) {
            locationVisitor.visitPrimitiveArray(this.getIndex(), 1);
        }
    }

    public static class LongFieldLocation
    extends MethodHandleFieldLocation
    implements LocationImpl.InternalLongLocation {
        public LongFieldLocation(int index, MethodHandle getter, MethodHandle setter) {
            super(index, getter, setter);
        }

        public static LongLocation create(LocationImpl.InternalLongLocation longLocation, boolean allowInt) {
            if (!allowInt && longLocation instanceof LongLocationDecorator || longLocation instanceof LongLocationDecorator && ((LongLocationDecorator)longLocation).allowInt == allowInt) {
                return longLocation;
            }
            return new LongLocationDecorator(longLocation, allowInt);
        }

        @Override
        public final Object get(DynamicObject store, boolean condition) {
            return this.getLong(store, condition);
        }

        @Override
        public final void setInternal(DynamicObject store, Object value) throws IncompatibleLocationException {
            if (!this.canStore(value)) {
                throw LongFieldLocation.incompatibleLocation();
            }
            this.setLongInternal(store, (Long)value);
        }

        @Override
        public final boolean canStore(Object value) {
            return value instanceof Long;
        }

        @Override
        public final void setLong(DynamicObject store, long value, Shape oldShape, Shape newShape) {
            store.setShapeAndGrow(oldShape, newShape);
            this.setLongInternal(store, value);
        }

        @Override
        public long getLong(DynamicObject store, boolean condition) {
            try {
                return this.getter.invokeExact(store);
            }
            catch (Throwable e) {
                CompilerDirectives.transferToInterpreter();
                throw new IllegalStateException(e);
            }
        }

        @Override
        public void setLong(DynamicObject store, long value, Shape shape) {
            this.setLongInternal(store, value);
        }

        @Override
        public final void setLong(DynamicObject store, long value) throws FinalLocationException {
            this.setLong(store, value, null);
        }

        @Override
        public final void setLongInternal(DynamicObject store, long value) {
            try {
                this.setter.invokeExact(store, value);
            }
            catch (Throwable e) {
                CompilerDirectives.transferToInterpreter();
                throw new IllegalStateException(e);
            }
        }

        @Override
        public final long getLong(DynamicObject store, Shape shape) {
            return this.getLong(store, LongFieldLocation.checkShape(store, shape));
        }

        @Override
        public final int primitiveFieldCount() {
            return 1;
        }

        @Override
        public final Class<Long> getType() {
            return Long.TYPE;
        }

        @Override
        public final void accept(LocationImpl.LocationVisitor locationVisitor) {
            locationVisitor.visitPrimitiveField(this.getIndex(), 1);
        }
    }

    public static class LongLocationDecorator
    extends PrimitiveLocationDecorator
    implements LocationImpl.InternalLongLocation {
        protected final boolean allowInt;

        public LongLocationDecorator(LocationImpl.InternalLongLocation longLocation, boolean allowInt) {
            super(longLocation);
            this.allowInt = allowInt;
        }

        @Override
        public final Object get(DynamicObject store, boolean condition) {
            return this.getLong(store, condition);
        }

        @Override
        public final void setInternal(DynamicObject store, Object value) throws IncompatibleLocationException {
            if (!this.canStore(value)) {
                throw LongLocationDecorator.incompatibleLocation();
            }
            this.setLongInternal(store, ((Number)value).longValue());
        }

        @Override
        public final boolean canStore(Object value) {
            return value instanceof Long || this.allowInt && value instanceof Integer;
        }

        @Override
        public final void setLong(DynamicObject store, long value, Shape oldShape, Shape newShape) {
            store.setShapeAndGrow(oldShape, newShape);
            this.setLongInternal(store, value);
        }

        @Override
        public Class<Long> getType() {
            return Long.TYPE;
        }
    }

    public static abstract class MethodHandleFieldLocation
    extends FieldLocation {
        protected final MethodHandle getter;
        protected final MethodHandle setter;

        public MethodHandleFieldLocation(int index, MethodHandle getter, MethodHandle setter) {
            super(index);
            this.getter = getter;
            this.setter = setter;
        }
    }

    public static class ObjectArrayLocation
    extends ArrayLocation
    implements ObjectLocation {
        public ObjectArrayLocation(int index, Location arrayLocation) {
            super(index, arrayLocation);
        }

        @Override
        public Object get(DynamicObject store, boolean condition) {
            return ((Object[])this.getArray(store, condition))[this.index];
        }

        @Override
        public final void setInternal(DynamicObject store, Object value) throws IncompatibleLocationException {
            ((Object[])this.getArray((DynamicObject)store, (boolean)false))[this.index] = value;
        }

        @Override
        public boolean canStore(Object value) {
            return true;
        }

        @Override
        public Class<? extends Object> getType() {
            return Object.class;
        }

        @Override
        public final boolean isNonNull() {
            return false;
        }

        @Override
        public int objectArrayCount() {
            return 1;
        }

        @Override
        public final void accept(LocationImpl.LocationVisitor locationVisitor) {
            locationVisitor.visitObjectArray(this.index, 1);
        }
    }

    public static class ObjectFieldLocation
    extends MethodHandleFieldLocation
    implements ObjectLocation {
        public ObjectFieldLocation(int index, MethodHandle getter, MethodHandle setter) {
            super(index, getter, setter);
        }

        @Override
        public Object get(DynamicObject store, boolean condition) {
            try {
                return this.getter.invokeExact(store);
            }
            catch (Throwable e) {
                CompilerDirectives.transferToInterpreter();
                throw new IllegalStateException(e);
            }
        }

        @Override
        public final void setInternal(DynamicObject store, Object value) throws IncompatibleLocationException {
            try {
                this.setter.invokeExact(store, value);
            }
            catch (Throwable e) {
                CompilerDirectives.transferToInterpreter();
                throw new IllegalStateException(e);
            }
        }

        @Override
        public boolean canStore(Object value) {
            return true;
        }

        @Override
        public Class<? extends Object> getType() {
            return Object.class;
        }

        @Override
        public boolean isNonNull() {
            return false;
        }

        @Override
        public int objectFieldCount() {
            return 1;
        }

        @Override
        public final void accept(LocationImpl.LocationVisitor locationVisitor) {
            locationVisitor.visitObjectField(this.getIndex(), 1);
        }
    }

    public static abstract class PrimitiveLocationDecorator
    extends LocationImpl {
        private final LocationImpl.InternalLongLocation longLocation;

        public PrimitiveLocationDecorator(LocationImpl.InternalLongLocation longLocation) {
            this.longLocation = longLocation;
        }

        public final long getLong(DynamicObject store, Shape shape) {
            return this.longLocation.getLong(store, shape);
        }

        public final long getLong(DynamicObject store, boolean condition) {
            return this.longLocation.getLong(store, condition);
        }

        public final void setLong(DynamicObject store, long value, Shape shape) throws FinalLocationException {
            this.longLocation.setLong(store, value, shape);
        }

        public final void setLong(DynamicObject store, long value) throws FinalLocationException {
            this.longLocation.setLong(store, value);
        }

        public final void setLongInternal(DynamicObject store, long value) {
            this.longLocation.setLongInternal(store, value);
        }

        @Override
        public final int primitiveFieldCount() {
            return ((LocationImpl)((Object)this.longLocation)).primitiveFieldCount();
        }

        @Override
        public final int primitiveArrayCount() {
            return ((LocationImpl)((Object)this.longLocation)).primitiveArrayCount();
        }

        @Override
        public final void accept(LocationImpl.LocationVisitor locationVisitor) {
            ((LocationImpl)((Object)this.longLocation)).accept(locationVisitor);
        }
    }

    public static abstract class SimpleLongFieldLocation
    extends FieldLocation
    implements LocationImpl.InternalLongLocation {
        public SimpleLongFieldLocation(int index) {
            super(index);
        }

        @Override
        public final Object get(DynamicObject store, boolean condition) {
            return this.getLong(store, condition);
        }

        @Override
        public final void setInternal(DynamicObject store, Object value) throws IncompatibleLocationException {
            if (!this.canStore(value)) {
                throw SimpleLongFieldLocation.incompatibleLocation();
            }
            this.setLongInternal(store, ((Number)value).longValue());
        }

        @Override
        public final boolean canStore(Object value) {
            return value instanceof Long;
        }

        @Override
        public final void setLong(DynamicObject store, long value, Shape oldShape, Shape newShape) {
            store.setShapeAndGrow(oldShape, newShape);
            this.setLongInternal(store, value);
        }

        @Override
        public abstract long getLong(DynamicObject var1, boolean var2);

        @Override
        public final long getLong(DynamicObject store, Shape shape) {
            return this.getLong(store, SimpleLongFieldLocation.checkShape(store, shape));
        }

        @Override
        public final void setLong(DynamicObject store, long value) {
            this.setLong(store, value, null);
        }

        @Override
        public void setLong(DynamicObject store, long value, Shape shape) {
            this.setLongInternal(store, value);
        }

        @Override
        public abstract void setLongInternal(DynamicObject var1, long var2);

        @Override
        public final int primitiveFieldCount() {
            return 1;
        }

        @Override
        public final Class<Long> getType() {
            return Long.TYPE;
        }

        @Override
        public final void accept(LocationImpl.LocationVisitor locationVisitor) {
            locationVisitor.visitPrimitiveField(this.getIndex(), 1);
        }
    }

    public static abstract class SimpleObjectFieldLocation
    extends FieldLocation
    implements ObjectLocation {
        public SimpleObjectFieldLocation(int index) {
            super(index);
        }

        @Override
        public abstract Object get(DynamicObject var1, boolean var2);

        @Override
        public abstract void setInternal(DynamicObject var1, Object var2);

        @Override
        public boolean canStore(Object value) {
            return true;
        }

        @Override
        public Class<? extends Object> getType() {
            return Object.class;
        }

        @Override
        public boolean isNonNull() {
            return false;
        }

        @Override
        public int objectFieldCount() {
            return 1;
        }

        @Override
        public final void accept(LocationImpl.LocationVisitor locationVisitor) {
            locationVisitor.visitObjectField(this.getIndex(), 1);
        }
    }
}

