/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.advanced;

import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class PrefEntry
implements Comparable<PrefEntry> {
    private final String key;
    private Preferences.Setting<?> value;
    private final Preferences.Setting<?> defaultValue;
    private boolean isDefault;
    private boolean changed;

    public PrefEntry(String string, Preferences.Setting<?> setting, Preferences.Setting<?> setting2, boolean bl) {
        CheckParameterUtil.ensureParameterNotNull(string);
        CheckParameterUtil.ensureParameterNotNull(setting);
        CheckParameterUtil.ensureParameterNotNull(setting2);
        this.key = string;
        this.value = setting;
        this.defaultValue = setting2;
        this.isDefault = bl;
    }

    public String getKey() {
        return this.key;
    }

    public Preferences.Setting<?> getValue() {
        return this.value;
    }

    public Preferences.Setting<?> getDefaultValue() {
        return this.defaultValue;
    }

    public void setValue(Preferences.Setting<?> setting) {
        this.value = setting;
        this.changed = true;
        this.isDefault = false;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void markAsChanged() {
        this.changed = true;
    }

    public void reset() {
        this.value = this.defaultValue;
        this.changed = true;
        this.isDefault = true;
    }

    @Override
    public int compareTo(PrefEntry prefEntry) {
        return this.key.compareTo(prefEntry.key);
    }

    public String toString() {
        return this.value.toString();
    }
}

