/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.TwoColumnDiff;
import org.openstreetmap.josm.gui.util.GuiHelper;

public class TagTableCellRenderer
extends JLabel
implements TableCellRenderer {
    public static final Color BGCOLOR_SELECTED = new Color(143, 170, 255);

    public TagTableCellRenderer() {
        this.setOpaque(true);
    }

    protected void setBackgroundReadable(String string, HistoryBrowserModel.TagTableModel tagTableModel, boolean bl) {
        Color color = UIManager.getColor("Table.background");
        if (!tagTableModel.hasTag(string) && tagTableModel.isCurrentPointInTime() || !tagTableModel.oppositeHasTag(string) && tagTableModel.isReferencePointInTime()) {
            color = TwoColumnDiff.Item.DiffItemType.DELETED.getColor();
        } else if (!tagTableModel.oppositeHasTag(string) && tagTableModel.isCurrentPointInTime() || !tagTableModel.hasTag(string) && tagTableModel.isReferencePointInTime()) {
            color = TwoColumnDiff.Item.DiffItemType.INSERTED.getColor();
        } else if (tagTableModel.hasTag(string) && tagTableModel.oppositeHasTag(string) && !tagTableModel.hasSameValueAsOpposite(string)) {
            color = TwoColumnDiff.Item.DiffItemType.CHANGED.getColor();
        }
        if (bl) {
            color = BGCOLOR_SELECTED;
        }
        GuiHelper.setBackgroundReadable(this, color);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (object == null) {
            return this;
        }
        String string = (String)object;
        HistoryBrowserModel.TagTableModel tagTableModel = this.getTagTableModel(jTable);
        switch (n2) {
            case 0: {
                this.setText(tagTableModel.hasTag(string) ? string : "");
                this.setToolTipText(this.getText());
                this.setBackgroundReadable(string, tagTableModel, bl);
                break;
            }
            case 1: {
                this.setText(tagTableModel.hasTag(string) ? tagTableModel.getValue(string) : "");
                this.setToolTipText(this.getText());
                this.setBackgroundReadable(string, tagTableModel, bl);
            }
        }
        return this;
    }

    protected HistoryBrowserModel.TagTableModel getTagTableModel(JTable jTable) {
        return (HistoryBrowserModel.TagTableModel)jTable.getModel();
    }
}

