/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.bbox;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JOptionPane;
import javax.swing.SpringLayout;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.MapMarkerDot;
import org.openstreetmap.gui.jmapviewer.MemoryTileCache;
import org.openstreetmap.gui.jmapviewer.OsmTileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.gui.jmapviewer.interfaces.MapMarker;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractTMSTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.MapQuestOpenAerialTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.MapQuestOsmTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.OsmTileSource;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.ImageryLayerInfo;
import org.openstreetmap.josm.data.imagery.TMSCachedTileLoader;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.gui.bbox.BBoxChooser;
import org.openstreetmap.josm.gui.bbox.SizeButton;
import org.openstreetmap.josm.gui.bbox.SlippyMapControler;
import org.openstreetmap.josm.gui.bbox.SourceButton;
import org.openstreetmap.josm.gui.layer.AbstractCachedTileSourceLayer;
import org.openstreetmap.josm.gui.layer.TMSLayer;
import org.openstreetmap.josm.tools.I18n;

public class SlippyMapBBoxChooser
extends JMapViewer
implements BBoxChooser {
    private static CopyOnWriteArrayList<TileSourceProvider> providers = new CopyOnWriteArrayList();
    private static final StringProperty PROP_MAPSTYLE;
    public static final String RESIZE_PROP;
    private final transient TileLoader cachedLoader;
    private final transient OsmTileLoader uncachedLoader;
    private final SizeButton iSizeButton;
    private final SourceButton iSourceButton;
    private transient Bounds bbox;
    private ICoordinate iSelectionRectStart;
    private ICoordinate iSelectionRectEnd;

    public static void addTileSourceProvider(TileSourceProvider tileSourceProvider) {
        providers.addIfAbsent(tileSourceProvider);
    }

    public SlippyMapBBoxChooser() {
        debug = Main.isDebugEnabled();
        SpringLayout springLayout = new SpringLayout();
        this.setLayout(springLayout);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("User-Agent", Version.getInstance().getFullAgentString());
        this.cachedLoader = AbstractCachedTileSourceLayer.getTileLoaderFactory("TMS", TMSCachedTileLoader.class).makeTileLoader(this, hashMap);
        this.uncachedLoader = new OsmTileLoader(this);
        this.uncachedLoader.headers.putAll(hashMap);
        this.setZoomContolsVisible(Main.pref.getBoolean("slippy_map_chooser.zoomcontrols", false));
        this.setMapMarkerVisible(false);
        this.setMinimumSize(new Dimension(350, 175));
        this.setBounds(new Rectangle(this.getMinimumSize()));
        if (this.cachedLoader == null) {
            this.setFileCacheEnabled(false);
        } else {
            this.setFileCacheEnabled(Main.pref.getBoolean("slippy_map_chooser.file_cache", true));
        }
        this.setMaxTilesInMemory(Main.pref.getInteger("slippy_map_chooser.max_tiles", 1000));
        List<TileSource> list = this.getAllTileSources();
        this.iSourceButton = new SourceButton(this, list);
        this.add(this.iSourceButton);
        springLayout.putConstraint("East", (Component)this.iSourceButton, 0, "East", (Component)this);
        springLayout.putConstraint("North", (Component)this.iSourceButton, 30, "North", (Component)this);
        this.iSizeButton = new SizeButton(this);
        this.add(this.iSizeButton);
        String string = PROP_MAPSTYLE.get();
        boolean bl = false;
        for (TileSource tileSource : list) {
            if (!tileSource.getName().equals(string)) continue;
            this.setTileSource(tileSource);
            this.iSourceButton.setCurrentMap(tileSource);
            bl = true;
            break;
        }
        if (!bl) {
            this.setTileSource(list.get(0));
            this.iSourceButton.setCurrentMap(list.get(0));
        }
        new SlippyMapControler(this, this);
    }

    private List<TileSource> getAllTileSources() {
        ArrayList<TileSource> arrayList = new ArrayList<TileSource>();
        for (TileSourceProvider tileSourceProvider : providers) {
            arrayList.addAll(tileSourceProvider.getTileSources());
        }
        return arrayList;
    }

    public boolean handleAttribution(Point point, boolean bl) {
        return this.attribution.handleAttribution(point, bl);
    }

    @Override
    public void paint(Graphics graphics) {
        try {
            super.paint(graphics);
            if (this.iSelectionRectStart != null && this.iSelectionRectEnd != null) {
                Rectangle rectangle = new Rectangle(this.getMapPosition(this.iSelectionRectStart, false));
                rectangle.add(this.getMapPosition(this.iSelectionRectEnd, false));
                graphics.setColor(new Color(0.9f, 0.7f, 0.7f, 0.6f));
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                graphics.setColor(Color.BLACK);
                graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
        catch (Exception exception) {
            Main.error(exception);
        }
    }

    public final void setFileCacheEnabled(boolean bl) {
        if (bl) {
            this.setTileLoader(this.cachedLoader);
        } else {
            this.setTileLoader(this.uncachedLoader);
        }
    }

    public final void setMaxTilesInMemory(int n) {
        ((MemoryTileCache)this.getTileCache()).setCacheSize(n);
    }

    public void setSelection(Point point, Point point2) {
        if (point == null || point2 == null || point.x == point2.x || point.y == point2.y) {
            return;
        }
        Point point3 = new Point(Math.max(point2.x, point.x), Math.max(point2.y, point.y));
        Point point4 = new Point(Math.min(point2.x, point.x), Math.min(point2.y, point.y));
        this.iSelectionRectStart = this.getPosition(point4);
        this.iSelectionRectEnd = this.getPosition(point3);
        Bounds bounds = new Bounds(new LatLon(Math.min(this.iSelectionRectStart.getLat(), this.iSelectionRectEnd.getLat()), LatLon.toIntervalLon(Math.min(this.iSelectionRectStart.getLon(), this.iSelectionRectEnd.getLon()))), new LatLon(Math.max(this.iSelectionRectStart.getLat(), this.iSelectionRectEnd.getLat()), LatLon.toIntervalLon(Math.max(this.iSelectionRectStart.getLon(), this.iSelectionRectEnd.getLon()))));
        Bounds bounds2 = this.bbox;
        this.bbox = bounds;
        this.repaint();
        this.firePropertyChange(BBOX_PROP, bounds2, this.bbox);
    }

    public void resizeSlippyMap() {
        boolean bl = this.iSizeButton.isEnlarged();
        this.firePropertyChange(RESIZE_PROP, !bl, bl);
    }

    public void toggleMapSource(TileSource tileSource) {
        this.tileController.setTileCache(new MemoryTileCache());
        this.setTileSource(tileSource);
        PROP_MAPSTYLE.put(tileSource.getName());
    }

    @Override
    public Bounds getBoundingBox() {
        return this.bbox;
    }

    @Override
    public void setBoundingBox(Bounds bounds) {
        if (bounds == null || bounds.getMinLat() == 0.0 && bounds.getMinLon() == 0.0 && bounds.getMaxLat() == 0.0 && bounds.getMaxLon() == 0.0) {
            this.bbox = null;
            this.iSelectionRectStart = null;
            this.iSelectionRectEnd = null;
            this.repaint();
            return;
        }
        this.bbox = bounds;
        this.iSelectionRectStart = new Coordinate(bounds.getMinLat(), bounds.getMinLon());
        this.iSelectionRectEnd = new Coordinate(bounds.getMaxLat(), bounds.getMaxLon());
        MapMarkerDot mapMarkerDot = new MapMarkerDot(bounds.getMinLat(), bounds.getMinLon());
        MapMarkerDot mapMarkerDot2 = new MapMarkerDot(bounds.getMaxLat(), bounds.getMaxLon());
        ArrayList<MapMarker> arrayList = new ArrayList<MapMarker>(2);
        arrayList.add(mapMarkerDot);
        arrayList.add(mapMarkerDot2);
        this.setMapMarkerList(arrayList);
        this.setDisplayToFitMapMarkers();
        this.zoomOut();
        this.repaint();
    }

    public void setSizeButtonVisible(boolean bl) {
        this.iSizeButton.setVisible(bl);
    }

    public final void refreshTileSources() {
        this.iSourceButton.setSources(this.getAllTileSources());
    }

    static {
        SlippyMapBBoxChooser.addTileSourceProvider(new TileSourceProvider(){

            @Override
            public List<TileSource> getTileSources() {
                return Arrays.asList(new OsmTileSource.Mapnik(), new OsmTileSource.CycleMap(), new MapQuestOsmTileSource(), new MapQuestOpenAerialTileSource());
            }
        });
        SlippyMapBBoxChooser.addTileSourceProvider(new TMSTileSourceProvider());
        PROP_MAPSTYLE = new StringProperty("slippy_map_chooser.mapstyle", "Mapnik");
        RESIZE_PROP = SlippyMapBBoxChooser.class.getName() + ".resize";
    }

    public static class TMSTileSourceProvider
    implements TileSourceProvider {
        private static final Set<String> existingSlippyMapUrls = new HashSet<String>();

        @Override
        public List<TileSource> getTileSources() {
            if (!TMSLayer.PROP_ADD_TO_SLIPPYMAP_CHOOSER.get().booleanValue()) {
                return Collections.emptyList();
            }
            ArrayList<TileSource> arrayList = new ArrayList<TileSource>();
            for (ImageryInfo imageryInfo : ImageryLayerInfo.instance.getLayers()) {
                if (existingSlippyMapUrls.contains(imageryInfo.getUrl())) continue;
                try {
                    AbstractTMSTileSource abstractTMSTileSource = TMSLayer.getTileSourceStatic(imageryInfo);
                    if (abstractTMSTileSource == null) continue;
                    arrayList.add(abstractTMSTileSource);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (illegalArgumentException.getMessage() == null || illegalArgumentException.getMessage().isEmpty()) continue;
                    JOptionPane.showMessageDialog(Main.parent, illegalArgumentException.getMessage(), I18n.tr("Warning", new Object[0]), 2);
                }
            }
            return arrayList;
        }

        public static void addExistingSlippyMapUrl(String string) {
            existingSlippyMapUrls.add(string);
        }

        static {
            existingSlippyMapUrls.add("https://{switch:a,b,c}.tile.openstreetmap.org/{zoom}/{x}/{y}.png");
            existingSlippyMapUrls.add("http://tile.opencyclemap.org/cycle/{zoom}/{x}/{y}.png");
            existingSlippyMapUrls.add("http://otile{switch:1,2,3,4}.mqcdn.com/tiles/1.0.0/osm/{zoom}/{x}/{y}.png");
            existingSlippyMapUrls.add("http://oatile{switch:1,2,3,4}.mqcdn.com/tiles/1.0.0/sat/{zoom}/{x}/{y}.png");
        }
    }

    public static interface TileSourceProvider {
        public List<TileSource> getTileSources();
    }
}

