/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import javax.swing.Icon;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ChangeRelationMemberRoleCommand
extends Command {
    private final Relation relation;
    private final int position;
    private final String newRole;
    private String oldRole;
    private Boolean oldModified;

    public ChangeRelationMemberRoleCommand(Relation relation, int n, String string) {
        this.relation = relation;
        this.position = n;
        this.newRole = string;
    }

    @Override
    public boolean executeCommand() {
        if (this.position < 0 || this.position >= this.relation.getMembersCount()) {
            return false;
        }
        this.oldRole = this.relation.getMember(this.position).getRole();
        if (this.newRole.equals(this.oldRole)) {
            return true;
        }
        this.relation.setMember(this.position, new RelationMember(this.newRole, this.relation.getMember(this.position).getMember()));
        this.oldModified = this.relation.isModified();
        this.relation.setModified(true);
        return true;
    }

    @Override
    public void undoCommand() {
        this.relation.setMember(this.position, new RelationMember(this.oldRole, this.relation.getMember(this.position).getMember()));
        this.relation.setModified(this.oldModified);
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        collection.add(this.relation);
    }

    @Override
    public String getDescriptionText() {
        return I18n.tr("Change relation member role for {0} {1}", new Object[]{OsmPrimitiveType.from(this.relation), this.relation.getDisplayName(DefaultNameFormatter.getInstance())});
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get(this.relation.getDisplayType());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.newRole == null ? 0 : this.newRole.hashCode());
        n = 31 * n + (this.oldModified == null ? 0 : this.oldModified.hashCode());
        n = 31 * n + (this.oldRole == null ? 0 : this.oldRole.hashCode());
        n = 31 * n + this.position;
        n = 31 * n + (this.relation == null ? 0 : this.relation.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ChangeRelationMemberRoleCommand changeRelationMemberRoleCommand = (ChangeRelationMemberRoleCommand)object;
        if (this.newRole == null ? changeRelationMemberRoleCommand.newRole != null : !this.newRole.equals(changeRelationMemberRoleCommand.newRole)) {
            return false;
        }
        if (this.oldModified == null ? changeRelationMemberRoleCommand.oldModified != null : !this.oldModified.equals(changeRelationMemberRoleCommand.oldModified)) {
            return false;
        }
        if (this.oldRole == null ? changeRelationMemberRoleCommand.oldRole != null : !this.oldRole.equals(changeRelationMemberRoleCommand.oldRole)) {
            return false;
        }
        if (this.position != changeRelationMemberRoleCommand.position) {
            return false;
        }
        return !(this.relation == null ? changeRelationMemberRoleCommand.relation != null : !this.relation.equals(changeRelationMemberRoleCommand.relation));
    }
}

