/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine;

import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.jcs.engine.AbstractCacheEventQueue;
import org.apache.commons.jcs.engine.behavior.ICacheEventQueue;
import org.apache.commons.jcs.engine.behavior.ICacheListener;
import org.apache.commons.jcs.engine.stats.StatElement;
import org.apache.commons.jcs.engine.stats.Stats;
import org.apache.commons.jcs.engine.stats.behavior.IStats;
import org.apache.commons.jcs.utils.threadpool.ThreadPoolManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PooledCacheEventQueue<K, V>
extends AbstractCacheEventQueue<K, V> {
    private static final Log log = LogFactory.getLog(PooledCacheEventQueue.class);
    private static final ICacheEventQueue.QueueType queueType = ICacheEventQueue.QueueType.POOLED;
    private ThreadPoolExecutor pool = null;

    public PooledCacheEventQueue(ICacheListener<K, V> iCacheListener, long l, String string, int n, int n2, String string2) {
        this.initialize(iCacheListener, l, string, n, n2, string2);
    }

    @Override
    public void initialize(ICacheListener<K, V> iCacheListener, long l, String string, int n, int n2, String string2) {
        if (iCacheListener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.listener = iCacheListener;
        this.listenerId = l;
        this.cacheName = string;
        this.maxFailure = n <= 0 ? 3 : n;
        this.waitBeforeRetry = n2 <= 0 ? 500 : n2;
        this.pool = ThreadPoolManager.getInstance().getPool(string2 == null ? "cache_event_queue" : string2);
        if (log.isDebugEnabled()) {
            log.debug("Initialized: " + this);
        }
    }

    @Override
    public ICacheEventQueue.QueueType getQueueType() {
        return queueType;
    }

    public synchronized void stopProcessing() {
        this.destroyed = true;
    }

    @Override
    public synchronized void destroy() {
        if (!this.destroyed) {
            this.destroyed = true;
            this.pool.shutdownNow();
            if (log.isInfoEnabled()) {
                log.info("Cache event queue destroyed: " + this);
            }
        }
    }

    @Override
    protected void put(AbstractCacheEventQueue.AbstractCacheEvent abstractCacheEvent) {
        this.pool.execute(abstractCacheEvent);
    }

    public String getStats() {
        return this.getStatistics().toString();
    }

    @Override
    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Pooled Cache Event Queue");
        ArrayList arrayList = new ArrayList();
        arrayList.add(new StatElement<Boolean>("Working", super.isWorking()));
        arrayList.add(new StatElement<Boolean>("Alive", this.isAlive()));
        arrayList.add(new StatElement<Boolean>("Empty", this.isEmpty()));
        if (this.pool.getQueue() != null) {
            BlockingQueue<Runnable> blockingQueue = this.pool.getQueue();
            arrayList.add(new StatElement<Integer>("Queue Size", blockingQueue.size()));
            arrayList.add(new StatElement<Integer>("Queue Capacity", blockingQueue.remainingCapacity()));
        }
        arrayList.add(new StatElement<Integer>("Pool Size", this.pool.getPoolSize()));
        arrayList.add(new StatElement<Integer>("Maximum Pool Size", this.pool.getMaximumPoolSize()));
        stats.setStatElements(arrayList);
        return stats;
    }

    @Override
    public boolean isEmpty() {
        if (this.pool.getQueue() == null) {
            return true;
        }
        return this.pool.getQueue().size() == 0;
    }

    @Override
    public int size() {
        if (this.pool.getQueue() == null) {
            return 0;
        }
        return this.pool.getQueue().size();
    }
}

