/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg.pattern;

import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PatternPaintContext
implements PaintContext {
    BufferedImage source;
    Rectangle deviceBounds;
    AffineTransform xform;
    int sourceWidth;
    int sourceHeight;
    BufferedImage buf;

    public PatternPaintContext(BufferedImage bufferedImage, Rectangle rectangle, AffineTransform affineTransform, AffineTransform affineTransform2) {
        this.source = bufferedImage;
        this.deviceBounds = rectangle;
        try {
            this.xform = affineTransform2.createInverse();
            this.xform.concatenate(affineTransform.createInverse());
        }
        catch (Exception exception) {
            Logger.getLogger("svgSalamandeLogger").log(Level.WARNING, null, exception);
        }
        this.sourceWidth = bufferedImage.getWidth();
        this.sourceHeight = bufferedImage.getHeight();
    }

    @Override
    public void dispose() {
    }

    @Override
    public ColorModel getColorModel() {
        return this.source.getColorModel();
    }

    @Override
    public Raster getRaster(int n, int n2, int n3, int n4) {
        if (this.buf == null || this.buf.getWidth() != n3 || this.buf.getHeight() != n4) {
            this.buf = new BufferedImage(n3, n4, this.source.getType());
        }
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n5;
                float_2.setLocation(j + n, i + n2);
                this.xform.transform(float_2, float_);
                int n6 = (int)float_.x % this.sourceWidth;
                if (n6 < 0) {
                    n6 += this.sourceWidth;
                }
                if ((n5 = (int)float_.y % this.sourceHeight) < 0) {
                    n5 += this.sourceHeight;
                }
                this.buf.setRGB(j, i, this.source.getRGB(n6, n5));
            }
        }
        return this.buf.getData();
    }

    public static void main(String[] stringArray) {
        int n = -4;
        System.err.println("Hello " + n % 4);
    }
}

