/***************************************************************************************************
 * Copyright (c) 2005 IBM Corporation and others. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 **************************************************************************************************/
package org.eclipse.wst.internet.internal.proxy;

import java.net.Authenticator;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.util.Hashtable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ProxyAuthenticator extends Authenticator
{
  private Hashtable              table   = new Hashtable();
  private String                 address = null;
  private PasswordAuthentication auth    = null;
  
  protected PasswordAuthentication getPasswordAuthentication()
  {
    address = null;
    auth    = null;
    
    try
    {
      address = InetAddress.getByName( getRequestingHost() ).getHostAddress();
      auth    = (PasswordAuthentication)table.get( address );
    }
    catch( Exception exc )
    {
      // Intentionally left empty.
    }
    
    // We didn't find a host address in our table so we will
    // prompt the user for one.
    if( auth == null )
    {
      // Prompt the user for a username and password in the UI thread.
      Display display = Display.getDefault();
      display.syncExec( new PromptUserJob() );
    }
    
    return auth;
  }
  
  public void addProxyEntry( String hostname, String userid, String password )
  {
    try
    {
      String                 address  = InetAddress.getByName( hostname ).getHostAddress();
      PasswordAuthentication auth     = new PasswordAuthentication( userid, password.toCharArray() ); 
      
      table.put( address, auth );  
    }
    catch( Exception exc )
    {
      // If the host is not known we will just not add this information to the table.
    }
  }
  
  private class PromptUserJob implements Runnable
  {
    public void run()
    {
      Display display = Display.getDefault();
      Shell   shell   = null;
      
      if( display != null ) shell = display.getActiveShell();
      
      PasswordDialog dialog = new PasswordDialog( shell, getRequestingPrompt() );          
      int            code   = dialog.open();
      
      if( code == Dialog.OK )
      {
        String username = dialog.getUsername();
        String password = dialog.getPassword();
        
        if( username != null && password != null && username.length() > 0 && password.length() > 0 )
        {
          auth = new PasswordAuthentication( username, password.toCharArray() );
          
          if( address != null )
          {
            table.put( address, auth );
          }
        }
      }
    }
  }
}
