/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.javascript.ui.internal.common.contentassist;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.sse.ui.internal.contentassist.IRelevanceCompletionProposal;

public class CustomCompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension,
ICompletionProposalExtension2,
IRelevanceCompletionProposal {
    protected String fAdditionalProposalInfo;
    protected IContextInformation fContextInformation;
    protected int fCursorPosition = 0;
    protected String fDisplayString;
    protected Image fImage;
    protected int fOriginalReplacementLength;
    protected CompletionProposal fProposal = null;
    protected int fRelevance = 0;
    protected int fReplacementLength = 0;
    protected int fReplacementOffset = 0;
    protected String fReplacementString = null;
    private boolean fUpdateLengthOnValidate;

    public CustomCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition) {
        this.fProposal = new CompletionProposal(replacementString, replacementOffset, replacementLength, cursorPosition);
        this.fReplacementString = replacementString;
        this.fReplacementOffset = replacementOffset;
        this.fReplacementLength = replacementLength;
        this.fCursorPosition = cursorPosition;
    }

    public CustomCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo) {
        this.fProposal = new CompletionProposal(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo);
        this.fReplacementString = replacementString;
        this.fReplacementOffset = replacementOffset;
        this.fReplacementLength = replacementLength;
        this.fCursorPosition = cursorPosition;
        this.fImage = image;
        this.fDisplayString = displayString;
        this.fContextInformation = contextInformation;
        this.fAdditionalProposalInfo = additionalProposalInfo;
    }

    public CustomCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, int relevance) {
        this.fProposal = new CompletionProposal(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo);
        this.fReplacementString = replacementString;
        this.fReplacementOffset = replacementOffset;
        this.fReplacementLength = replacementLength;
        this.fCursorPosition = cursorPosition;
        this.fImage = image;
        this.fDisplayString = displayString;
        this.fContextInformation = contextInformation;
        this.fAdditionalProposalInfo = additionalProposalInfo;
        this.fRelevance = relevance;
    }

    public CustomCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, int relevance, boolean updateReplacementLengthOnValidate) {
        this.fProposal = new CompletionProposal(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo);
        this.fReplacementString = replacementString;
        this.fReplacementOffset = replacementOffset;
        this.fReplacementLength = replacementLength;
        this.fCursorPosition = cursorPosition;
        this.fImage = image;
        this.fDisplayString = displayString;
        this.fContextInformation = contextInformation;
        this.fAdditionalProposalInfo = additionalProposalInfo;
        this.fRelevance = relevance;
        this.fUpdateLengthOnValidate = updateReplacementLengthOnValidate;
        this.fOriginalReplacementLength = this.fReplacementLength;
    }

    public CustomCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, int relevance) {
        this.fProposal = new CompletionProposal(replacementString, replacementOffset, replacementLength, cursorPosition);
        this.fReplacementString = replacementString;
        this.fReplacementOffset = replacementOffset;
        this.fReplacementLength = replacementLength;
        this.fCursorPosition = cursorPosition;
        this.fRelevance = relevance;
    }

    public void apply(IDocument document) {
        this.fProposal.apply(document);
    }

    public void apply(IDocument document, char trigger, int offset) {
        this.fProposal.apply(document);
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        IDocument document = viewer.getDocument();
        int caretOffset = viewer.getTextWidget().getCaretOffset();
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
            caretOffset = extension.widgetOffset2ModelOffset(caretOffset);
        } else {
            caretOffset = viewer.getTextWidget().getCaretOffset() + viewer.getVisibleRegion().getOffset();
        }
        if (caretOffset == this.getReplacementOffset()) {
            this.apply(document);
        } else {
            try {
                int endOffsetOfChanges = this.getReplacementString().length() + this.getReplacementOffset();
                if (endOffsetOfChanges >= caretOffset) {
                    int postCaretReplacementLength = this.getReplacementOffset() + this.getReplacementLength() - caretOffset;
                    int preCaretReplacementLength = this.getReplacementString().length() - (endOffsetOfChanges - caretOffset);
                    if (postCaretReplacementLength < 0) {
                        postCaretReplacementLength = 0;
                    }
                    document.replace(caretOffset, postCaretReplacementLength, this.getReplacementString().substring(preCaretReplacementLength));
                }
                if (caretOffset > this.getReplacementOffset()) {
                    int preCaretTextLength = caretOffset - this.getReplacementOffset();
                    document.replace(this.getReplacementOffset(), preCaretTextLength, this.getReplacementString().substring(0, preCaretTextLength));
                }
            }
            catch (BadLocationException badLocationException) {
                this.apply(document);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                this.apply(document);
            }
        }
    }

    public String getAdditionalProposalInfo() {
        return this.fProposal.getAdditionalProposalInfo();
    }

    public IContextInformation getContextInformation() {
        return this.fProposal.getContextInformation();
    }

    public int getContextInformationPosition() {
        return this.getCursorPosition();
    }

    public int getCursorPosition() {
        return this.fCursorPosition;
    }

    public String getDisplayString() {
        return this.fProposal.getDisplayString();
    }

    public Image getImage() {
        return this.fProposal.getImage();
    }

    public int getRelevance() {
        return this.fRelevance;
    }

    public int getReplacementLength() {
        return this.fReplacementLength;
    }

    public int getReplacementOffset() {
        return this.fReplacementOffset;
    }

    public String getReplacementString() {
        return this.fReplacementString;
    }

    public Point getSelection(IDocument document) {
        return this.fProposal.getSelection(document);
    }

    public char[] getTriggerCharacters() {
        return null;
    }

    public boolean isValidFor(IDocument document, int offset) {
        return this.validate(document, offset, null);
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
    }

    protected boolean startsWith(IDocument document, int offset, String word) {
        int wordLength;
        int n = wordLength = word == null ? 0 : word.length();
        if (offset > this.fReplacementOffset + wordLength) {
            return false;
        }
        try {
            int length = offset - this.fReplacementOffset;
            String start = document.get(this.fReplacementOffset, length);
            return word.substring(0, length).equalsIgnoreCase(start);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    public void unselected(ITextViewer viewer) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        int delta;
        if (offset < this.fReplacementOffset) {
            return false;
        }
        boolean validated = this.startsWith(document, offset, this.fDisplayString);
        if (this.fUpdateLengthOnValidate && (delta = offset - this.fReplacementOffset) > 0) {
            this.fReplacementLength = delta + this.fOriginalReplacementLength;
        }
        return validated;
    }
}

