/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.impl;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.IXSDAttributeFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.IXSDComplexFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.IXSDFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.XSDToFragmentConfiguration;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.XSDToFragmentController;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.impl.XSDMapFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.util.XSDTypeDefinitionUtil;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDTypeDefinition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XSDComplexFragment
extends XSDMapFragment
implements IXSDComplexFragment {
    public XSDComplexFragment(String id, String name, XSDToFragmentConfiguration config, XSDToFragmentController controller) {
        super(id, name, config, controller);
    }

    public boolean setParameterValuesFromInstanceDocuments(Element[] instanceDocuments) {
        Element[] instanceDocumentsCopy = this.getInstanceDocumentsByTagName(instanceDocuments, this.getName());
        boolean paramsValid = this.internalEquals(instanceDocumentsCopy, instanceDocuments);
        XSDComplexTypeDefinition complexType = (XSDComplexTypeDefinition)this.getXSDTypeDefinition();
        XSDComplexTypeContent complexTypeContent = XSDTypeDefinitionUtil.getXSDComplexTypeContent(complexType);
        if (complexTypeContent instanceof XSDTypeDefinition) {
            this.setParamsForXSDTypeDef(instanceDocumentsCopy);
        } else {
            this.setParamsForXSDParticle(instanceDocumentsCopy);
        }
        return this.setParamsForAttributes(instanceDocumentsCopy) && paramsValid;
    }

    private boolean setParamsForAttributes(Element[] instanceDocuments) {
        boolean paramsValid = true;
        IXSDAttributeFragment[] attributeFragments = this.getAllAttributeFragments();
        int i = 0;
        while (i < instanceDocuments.length) {
            NamedNodeMap nodeMap = instanceDocuments[i].getAttributes();
            int k = 0;
            while (k < attributeFragments.length) {
                String name = ((XSDAttributeUse)attributeFragments[k].getXSDToFragmentConfiguration().getXSDComponent()).getAttributeDeclaration().getName();
                paramsValid = attributeFragments[k].getXSDDelegationFragment().setAttributeParamsFromInstanceDocuments(nodeMap.getNamedItem(name));
                ++k;
            }
            ++i;
        }
        return paramsValid;
    }

    private boolean setParamsForXSDTypeDef(Element[] instanceDocuments) {
        boolean paramsValid = true;
        this.removeAllFragments();
        this.removeAllAttributeFragments();
        int i = 0;
        while (i < instanceDocuments.length) {
            IXSDFragment childFrag = this.getFragment(this.createInstance());
            Element[] childInstanceDocuments = new Element[]{instanceDocuments[i]};
            if (!childFrag.setParameterValuesFromInstanceDocuments(this.setElementsTagName(childInstanceDocuments, childFrag.getName()))) {
                paramsValid = false;
            }
            ++i;
        }
        return paramsValid;
    }

    private boolean setParamsForXSDParticle(Element[] instanceDocuments) {
        boolean paramsValid = true;
        this.removeAllFragments();
        this.removeAllAttributeFragments();
        int i = 0;
        while (i < instanceDocuments.length) {
            IXSDFragment childFrag = this.getFragment(this.createInstance());
            Vector<Node> instancesVector = new Vector<Node>();
            NodeList nl = instanceDocuments[i].getChildNodes();
            int j = 0;
            while (j < nl.getLength()) {
                Node node = nl.item(j);
                if (node instanceof Element) {
                    instancesVector.add(node);
                } else {
                    paramsValid = false;
                }
                ++j;
            }
            Object[] childInstanceDocuments = new Element[instancesVector.size()];
            instancesVector.copyInto(childInstanceDocuments);
            if (!childFrag.setParameterValuesFromInstanceDocuments((Element[])childInstanceDocuments)) {
                paramsValid = false;
            }
            ++i;
        }
        return paramsValid;
    }

    public Element[] genInstanceDocumentsFromParameterValues(boolean genXSIType, Hashtable namespaceTable, Document doc) {
        XSDComplexTypeDefinition complexType = (XSDComplexTypeDefinition)this.getXSDTypeDefinition();
        XSDComplexTypeContent complexTypeContent = XSDTypeDefinitionUtil.getXSDComplexTypeContent(complexType);
        String tagName = this.getInstanceDocumentTagName(namespaceTable);
        Element[] instanceDocuments = complexTypeContent instanceof XSDTypeDefinition ? this.genInstancesForXSDTypeDef(genXSIType, namespaceTable, tagName, doc) : this.genInstancesForXSDParticle(genXSIType, namespaceTable, tagName, doc);
        if (genXSIType) {
            this.addXSIType(instanceDocuments, namespaceTable);
        }
        instanceDocuments = this.addAttributes(instanceDocuments);
        return instanceDocuments;
    }

    private Element[] addAttributes(Element[] instanceDocuments) {
        int i = 0;
        while (i < instanceDocuments.length) {
            IXSDAttributeFragment[] attributeFragments = this.getAllAttributeFragments();
            int k = 0;
            while (k < attributeFragments.length) {
                String name = ((XSDAttributeUse)attributeFragments[k].getXSDToFragmentConfiguration().getXSDComponent()).getAttributeDeclaration().getName();
                attributeFragments[k].getXSDDelegationFragment().setAttributesOnInstanceDocuments(instanceDocuments[i], name);
                ++k;
            }
            ++i;
        }
        return instanceDocuments;
    }

    private Element[] genInstancesForXSDTypeDef(boolean genXSIType, Hashtable namespaceTable, String tagName, Document doc) {
        IXSDFragment[] fragments = this.getAllFragments();
        Vector<Element> instanceDocumentsCopy = new Vector<Element>();
        int i = 0;
        while (i < fragments.length) {
            Element[] fragmentInstances = fragments[i].genInstanceDocumentsFromParameterValues(genXSIType, namespaceTable, doc);
            if (fragmentInstances.length > 0) {
                instanceDocumentsCopy.add(fragmentInstances[0]);
            }
            ++i;
        }
        Element[] instanceDocuments = new Element[instanceDocumentsCopy.size()];
        int i2 = 0;
        while (i2 < instanceDocuments.length) {
            instanceDocuments[i2] = (Element)instanceDocumentsCopy.get(i2);
            ++i2;
        }
        return this.setElementsTagName(instanceDocuments, tagName);
    }

    private Element[] genInstancesForXSDParticle(boolean genXSIType, Hashtable namespaceTable, String tagName, Document doc) {
        IXSDFragment[] childFrags = this.getAllFragments();
        Element[] instanceDocuments = new Element[childFrags.length];
        int i = 0;
        while (i < instanceDocuments.length) {
            Element[] childInstances = childFrags[i].genInstanceDocumentsFromParameterValues(genXSIType, namespaceTable, doc);
            Element instanceDocument = doc.createElement(tagName);
            int j = 0;
            while (j < childInstances.length) {
                if (childInstances[j] != null) {
                    instanceDocument.appendChild(childInstances[j]);
                }
                ++j;
            }
            instanceDocuments[i] = instanceDocument;
            ++i;
        }
        return instanceDocuments;
    }

    private XSDModelGroup getXSDModelGroup(XSDParticle xsdParticle) {
        XSDParticleContent xsdParticleContent;
        if (xsdParticle != null && (xsdParticleContent = xsdParticle.getContent()) != null) {
            if (xsdParticleContent instanceof XSDModelGroupDefinition) {
                XSDModelGroupDefinition xsdModelGroupDef = (XSDModelGroupDefinition)xsdParticleContent;
                if (xsdModelGroupDef.isModelGroupDefinitionReference()) {
                    xsdModelGroupDef = xsdModelGroupDef.getResolvedModelGroupDefinition();
                }
                return xsdModelGroupDef.getModelGroup();
            }
            if (xsdParticleContent instanceof XSDModelGroup) {
                return (XSDModelGroup)xsdParticleContent;
            }
        }
        return null;
    }

    private List getInheritedParticles(XSDComplexTypeDefinition complexType) {
        Vector v = new Vector();
        if (complexType.getDerivationMethod().getValue() == 0) {
            XSDModelGroup xsdModelGroup;
            XSDComplexTypeContent extTypeContent;
            XSDTypeDefinition extType = complexType.getBaseType();
            if (extType != null && !(extType instanceof XSDComplexTypeDefinition)) {
                XSDNamedComponent xsdNamedComp;
                String namespace = extType.getTargetNamespace();
                String localname = extType.getName();
                if (namespace != null && localname != null && (xsdNamedComp = this.getXSDToFragmentController().getWSDLPartsToXSDTypeMapper().getXSDTypeFromSchema(namespace, localname, false)) instanceof XSDComplexTypeDefinition) {
                    extType = (XSDComplexTypeDefinition)xsdNamedComp;
                }
            }
            if (extType != null && extType != complexType && extType instanceof XSDComplexTypeDefinition && (extTypeContent = XSDTypeDefinitionUtil.getXSDComplexTypeContent((XSDComplexTypeDefinition)extType)) instanceof XSDParticle && (xsdModelGroup = this.getXSDModelGroup((XSDParticle)extTypeContent)) != null) {
                v.addAll(this.getInheritedParticles((XSDComplexTypeDefinition)extType));
                v.addAll(xsdModelGroup.getParticles());
            }
        }
        return v;
    }

    private void gatherInheritedParticles(XSDComplexTypeDefinition complexType) {
        XSDModelGroup xsdModelGroup;
        XSDComplexTypeContent complexTypeContent;
        if (complexType.getDerivationMethod().getValue() == 0 && (complexTypeContent = XSDTypeDefinitionUtil.getXSDComplexTypeContent(complexType)) instanceof XSDParticle && (xsdModelGroup = this.getXSDModelGroup((XSDParticle)complexTypeContent)) != null) {
            List inheritedParticles = this.getInheritedParticles(complexType);
            EList particles = xsdModelGroup.getParticles();
            particles.addAll(0, inheritedParticles);
        }
    }

    public IXSDAttributeFragment[] getAllAttributeFragments() {
        return super.getAllAttributeFragments();
    }

    public void createAttributeFragments(String complexChildID) {
        XSDComplexTypeDefinition complexType = (XSDComplexTypeDefinition)this.getXSDTypeDefinition();
        EList atContentList = complexType.getAttributeContents();
        Iterator iterator = atContentList.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object instanceof XSDAttributeGroupDefinition) {
                XSDAttributeGroupDefinition xsdAGD = (XSDAttributeGroupDefinition)object;
                XSDAttributeGroupDefinition resolved = xsdAGD.getResolvedAttributeGroupDefinition();
                EList aList = resolved.getContents();
                Iterator iterator2 = aList.iterator();
                while (iterator2.hasNext()) {
                    this.createAttributeHelper((XSDAttributeUse)iterator2.next(), complexChildID);
                }
                continue;
            }
            XSDAttributeUse attUse = (XSDAttributeUse)object;
            this.createAttributeHelper(attUse, complexChildID);
        }
    }

    private void createAttributeHelper(XSDAttributeUse attUse, String complexChildID) {
        XSDToFragmentConfiguration thisConfig = this.getXSDToFragmentConfiguration();
        XSDToFragmentConfiguration xsdConfig = new XSDToFragmentConfiguration();
        xsdConfig.setXSDComponent((XSDComponent)attUse);
        xsdConfig.setStyle(thisConfig.getStyle());
        xsdConfig.setPartEncoding(thisConfig.getPartEncoding());
        xsdConfig.setWSDLPartName(thisConfig.getWSDLPartName());
        String newID = this.genID();
        this.addAttributeFragment(String.valueOf(complexChildID) + newID, this.getXSDToFragmentController().getFragment(xsdConfig, String.valueOf(complexChildID) + newID, String.valueOf(complexChildID) + newID));
    }

    public String createComplexInstance() {
        XSDComplexTypeDefinition complexType = (XSDComplexTypeDefinition)this.getXSDTypeDefinition();
        this.gatherInheritedParticles(complexType);
        XSDComplexTypeContent complexTypeContent = XSDTypeDefinitionUtil.getXSDComplexTypeContent(complexType);
        XSDToFragmentConfiguration thisConfig = this.getXSDToFragmentConfiguration();
        XSDToFragmentConfiguration xsdConfig = new XSDToFragmentConfiguration();
        xsdConfig.setXSDComponent((XSDComponent)complexTypeContent);
        xsdConfig.setStyle(thisConfig.getStyle());
        xsdConfig.setPartEncoding(thisConfig.getPartEncoding());
        xsdConfig.setWSDLPartName(thisConfig.getWSDLPartName());
        String newID = this.genID();
        this.addFragment(newID, this.getXSDToFragmentController().getFragment(xsdConfig, newID, newID));
        this.createAttributeFragments(newID);
        return newID;
    }

    public String createInstance() {
        return this.createComplexInstance();
    }
}

