/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.wizards.ConfigurationWizardMainPage;

public class NewLocationWizard
extends Wizard {
    private ConfigurationWizardMainPage mainPage;
    private Properties properties = null;

    public NewLocationWizard() {
        IDialogSettings workbenchSettings = SVNUIPlugin.getPlugin().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("NewLocationWizard");
        if (section == null) {
            section = workbenchSettings.addNewSection("NewLocationWizard");
        }
        this.setDialogSettings(section);
        this.setWindowTitle(Policy.bind("NewLocationWizard.title"));
    }

    public NewLocationWizard(Properties initialProperties) {
        this();
        this.properties = initialProperties;
    }

    public void addPages() {
        this.mainPage = new ConfigurationWizardMainPage("repositoryPage1", Policy.bind("NewLocationWizard.heading"), SVNUIPlugin.getPlugin().getImageDescriptor("wizban/newlocation_wizban.gif"));
        if (this.properties != null) {
            this.mainPage.setProperties(this.properties);
        }
        this.mainPage.setDescription(Policy.bind("NewLocationWizard.description"));
        this.mainPage.setDialogSettings(this.getDialogSettings());
        this.addPage((IWizardPage)this.mainPage);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean performFinish() {
        this.mainPage.finish((IProgressMonitor)new NullProgressMonitor());
        Properties properties = this.mainPage.getProperties();
        final ISVNRepositoryLocation[] root = new ISVNRepositoryLocation[1];
        SVNProviderPlugin provider = SVNProviderPlugin.getPlugin();
        try {
            block12: {
                root[0] = provider.getRepositories().createRepository(properties);
                try {
                    new ProgressMonitorDialog(this.getShell()).run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException {
                            try {
                                root[0].validateConnection(monitor);
                            }
                            catch (TeamException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    return false;
                }
                catch (InvocationTargetException e) {
                    Throwable t = e.getTargetException();
                    if (!(t instanceof TeamException)) break block12;
                    throw (TeamException)t;
                }
            }
            provider.getRepositories().addOrUpdateRepository(root[0]);
            return true;
        }
        catch (TeamException e) {
            if (root[0] == null) {
                SVNUIPlugin.openError(this.getContainer().getShell(), Policy.bind("NewLocationWizard.exception"), null, e);
                return false;
            }
            IStatus error = e.getStatus();
            if (error.isMultiStatus() && error.getChildren().length == 1) {
                error = error.getChildren()[0];
            }
            boolean keep = false;
            if (error.isMultiStatus()) {
                SVNUIPlugin.openError(this.getContainer().getShell(), Policy.bind("NewLocationWizard.validationFailedTitle"), null, e);
            } else {
                keep = MessageDialog.openQuestion((Shell)this.getContainer().getShell(), (String)Policy.bind("NewLocationWizard.validationFailedTitle"), (String)Policy.bind("NewLocationWizard.validationFailedText", new Object[]{error.getMessage()}));
            }
            try {
                if (keep) {
                    provider.getRepositories().addOrUpdateRepository(root[0]);
                    return keep;
                }
                provider.getRepositories().disposeRepository(root[0]);
                return keep;
            }
            catch (TeamException e1) {
                SVNUIPlugin.openError(this.getContainer().getShell(), Policy.bind("exception"), null, e1);
                return false;
            }
        }
    }
}

