/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui;

import java.text.Collator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.preferences.MembersOrderPreferenceCache;

public class RubyElementSorter
extends ViewerSorter {
    private static final int PROJECTS = 1;
    private static final int RUBYSCRIPTS = 4;
    private static final int RESOURCEFOLDERS = 7;
    private static final int RESOURCES = 8;
    private static final int STORAGE = 9;
    private static final int IMPORT_CONTAINER = 11;
    private static final int IMPORT_DECLARATION = 12;
    private static final int MEMBERSOFFSET = 15;
    private static final int RUBYELEMENTS = 50;
    private static final int OTHERS = 51;
    private MembersOrderPreferenceCache fMemberOrderCache = RubyPlugin.getDefault().getMemberOrderPreferenceCache();
    static /* synthetic */ Class class$0;

    public RubyElementSorter() {
        super(null);
    }

    public final Collator getCollator() {
        if (this.collator == null) {
            this.collator = Collator.getInstance();
        }
        return this.collator;
    }

    public int category(Object object) {
        if (object instanceof IRubyElement) {
            IRubyElement iRubyElement = (IRubyElement)object;
            switch (iRubyElement.getElementType()) {
                case 4: {
                    IMethod iMethod = (IMethod)iRubyElement;
                    if (iMethod.isConstructor()) {
                        return this.getMemberCategory(1);
                    }
                    if (iMethod.isSingleton()) {
                        return this.getMemberCategory(5);
                    }
                    return this.getMemberCategory(2);
                }
                case 7: 
                case 8: 
                case 9: 
                case 13: {
                    return this.getMemberCategory(3);
                }
                case 3: {
                    return this.getMemberCategory(0);
                }
                case 14: {
                    return 11;
                }
                case 6: {
                    return 12;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 4;
                }
            }
            return 50;
        }
        if (object instanceof IFile) {
            return 8;
        }
        if (object instanceof IProject) {
            return 1;
        }
        if (object instanceof IContainer) {
            return 7;
        }
        if (object instanceof IStorage) {
            return 9;
        }
        return 51;
    }

    private int getMemberCategory(int n) {
        int n2 = this.fMemberOrderCache.getCategoryIndex(n);
        return n2 + 15;
    }

    public int compare(Viewer viewer, Object object, Object object2) {
        int n;
        int n2;
        int n3 = this.category(object);
        if (n3 != (n2 = this.category(object2))) {
            return n3 - n2;
        }
        if (n3 == 1 || n3 == 8 || n3 == 7 || n3 == 9 || n3 == 51) {
            String string = this.getNonRubyElementLabel(viewer, object);
            String string2 = this.getNonRubyElementLabel(viewer, object2);
            if (string != null && string2 != null) {
                return this.getCollator().compare(string, string2);
            }
            return 0;
        }
        if (object instanceof IMethod && this.fMemberOrderCache.isSortByVisibility()) {
            try {
                int n4 = ((IMethod)object).getVisibility();
                int n5 = ((IMethod)object2).getVisibility();
                n = this.fMemberOrderCache.getVisibilityIndex(n4) - this.fMemberOrderCache.getVisibilityIndex(n5);
                if (n != 0) {
                    return n;
                }
            }
            catch (RubyModelException rubyModelException) {}
        }
        boolean cfr_ignored_0 = object instanceof IMember;
        String string = this.getElementName(object);
        String string3 = this.getElementName(object2);
        if (object instanceof IType) {
            if (string.length() == 0) {
                if (string3.length() == 0) {
                    try {
                        return this.getCollator().compare(((IType)object).getSuperclassName(), ((IType)object2).getSuperclassName());
                    }
                    catch (RubyModelException rubyModelException) {
                        return 0;
                    }
                }
                return 1;
            }
            if (string3.length() == 0) {
                return -1;
            }
        }
        if ((n = this.getCollator().compare(string, string3)) != 0) {
            return n;
        }
        try {
            if (object instanceof IMethod) {
                String[] stringArray = ((IMethod)object).getParameterNames();
                String[] stringArray2 = ((IMethod)object2).getParameterNames();
                int n6 = Math.min(stringArray.length, stringArray2.length);
                int n7 = 0;
                while (n7 < n6) {
                    n = this.getCollator().compare(stringArray[n7], stringArray2[n7]);
                    if (n != 0) {
                        return n;
                    }
                    ++n7;
                }
                return stringArray.length - stringArray2.length;
            }
            return 0;
        }
        catch (RubyModelException rubyModelException) {
            return 0;
        }
    }

    private String getElementName(Object object) {
        if (object instanceof IRubyElement) {
            return ((IRubyElement)object).getElementName();
        }
        return object.toString();
    }

    private String getNonRubyElementLabel(Viewer viewer, Object object) {
        IBaseLabelProvider iBaseLabelProvider;
        if (object instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iBaseLabelProvider = (IWorkbenchAdapter)iAdaptable.getAdapter((Class)clazz)) != null) {
                return iBaseLabelProvider.getLabel(object);
            }
        }
        if (viewer instanceof ContentViewer && (iBaseLabelProvider = ((ContentViewer)viewer).getLabelProvider()) instanceof ILabelProvider) {
            return ((ILabelProvider)iBaseLabelProvider).getText(object);
        }
        return null;
    }
}

