/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.util.property;

import java.util.Properties;
import org.eigenbase.util.property.Property;

public class DoubleProperty
extends Property {
    private final double minValue;
    private final double maxValue;

    public DoubleProperty(Properties properties, String string, double d) {
        this(properties, string, d, -1.7976931348623157E308, Double.MAX_VALUE);
    }

    public DoubleProperty(Properties properties, String string) {
        this(properties, string, -1.7976931348623157E308, Double.MAX_VALUE);
    }

    public DoubleProperty(Properties properties, String string, double d, double d2, double d3) {
        super(properties, string, Double.toString(d));
        if (d2 > d3) {
            double d4 = d2;
            d2 = d3;
            d3 = d4;
        }
        if (d < d2 || d > d3) {
            throw new IllegalArgumentException("invalid default value " + d);
        }
        this.minValue = d2;
        this.maxValue = d3;
    }

    public DoubleProperty(Properties properties, String string, double d, double d2) {
        super(properties, string, null);
        if (d > d2) {
            double d3 = d;
            d = d2;
            d2 = d3;
        }
        this.minValue = d;
        this.maxValue = d2;
    }

    public double get() {
        String string = this.getInternal(null, false);
        if (string == null) {
            return this.noValue();
        }
        double d = Double.parseDouble(string);
        return this.limit(d);
    }

    public double get(double d) {
        String string = this.getInternal(Double.toString(d), false);
        if (string == null) {
            return this.limit(d);
        }
        double d2 = Double.parseDouble(string);
        return this.limit(d2);
    }

    public double set(double d) {
        String string = this.setString(Double.toString(this.limit(d)));
        if (string == null && (string = this.getDefaultValue()) == null) {
            return this.noValue();
        }
        double d2 = Double.parseDouble(string);
        return this.limit(d2);
    }

    private double limit(double d) {
        return Math.min(Math.max(d, this.minValue), this.maxValue);
    }

    private double noValue() {
        if (this.minValue <= 0.0 && this.maxValue >= 0.0) {
            return 0.0;
        }
        return this.minValue;
    }
}

