/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui;

import ca.sqlpower.sql.DataSourceCollection;
import ca.sqlpower.sql.JDBCDataSource;
import ca.sqlpower.sql.JDBCDataSourceType;
import ca.sqlpower.sql.SPDataSource;
import ca.sqlpower.swingui.DataEntryPanel;
import ca.sqlpower.swingui.Messages;
import ca.sqlpower.swingui.PlatformSpecificConnectionOptionPanel;
import ca.sqlpower.swingui.SPDataSourceTypeListCellRenderer;
import ca.sqlpower.swingui.SPSUtils;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class JDBCDataSourcePanel
implements DataEntryPanel {
    private static final Logger logger = Logger.getLogger(JDBCDataSourcePanel.class);
    protected static final String EXTRA_FIELD_LABEL_PROP = "ca.sqlpower.swingui.LABEL";
    private JPanel panel;
    private final JDBCDataSource dbcs;
    private JTextField dbNameField;
    private JComboBox dataSourceTypeBox;
    private PlatformSpecificConnectionOptionPanel platformSpecificOptions;
    private JTextField dbUrlField;
    private JTextField dbUserField;
    private JPasswordField dbPassField;
    private JButton dbTestConnection;
    private JLabel dbTestResult;
    private JTextArea sysprops;
    private List<JComponent> extraFields = new ArrayList<JComponent>();
    private boolean enforcingUniqueName = true;

    public JDBCDataSourcePanel(JDBCDataSource ds) {
        this.dbcs = ds;
    }

    private JPanel buildGeneralPanel(JDBCDataSource dbcs) {
        DataSourceCollection<SPDataSource> dsCollection = dbcs.getParentCollection();
        List<JDBCDataSourceType> dataSourceTypes = dsCollection.getDataSourceTypes();
        dataSourceTypes.add(0, new JDBCDataSourceType());
        this.dataSourceTypeBox = new JComboBox<Object>(dataSourceTypes.toArray());
        this.dataSourceTypeBox.setRenderer(new SPDataSourceTypeListCellRenderer());
        this.dataSourceTypeBox.setSelectedIndex(0);
        if (dbcs.isParentSet()) {
            logger.debug((Object)("A PARENT! setting selected item to: \"" + dbcs.getParentType() + "\""));
            this.dataSourceTypeBox.setSelectedItem(dbcs.getParentType());
        } else {
            logger.debug((Object)("NO PARENT! setting selected item to: \"" + dbcs + "\""));
            this.dataSourceTypeBox.setSelectedItem(dbcs);
        }
        this.dbNameField = new JTextField(dbcs.getName());
        this.dbNameField.setName("dbNameField");
        logger.debug((Object)("dbcs.getUrl() returns " + dbcs.getUrl()));
        this.dbUrlField = new JTextField(dbcs.getUrl());
        this.platformSpecificOptions = new PlatformSpecificConnectionOptionPanel(this.dbUrlField);
        if (dbcs.isParentSet()) {
            this.platformSpecificOptions.setTemplate(dbcs.getParentType());
        }
        this.dbTestResult = new JLabel();
        this.sysprops = new JTextArea();
        this.sysprops.setBorder(null);
        this.sysprops.setOpaque(false);
        this.sysprops.setEditable(false);
        this.sysprops.setFont(this.dbTestResult.getFont());
        this.dbTestConnection = new JButton(new AbstractAction(Messages.getString("SPDataSourcePanel.testConnectionActionName")){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                JDBCDataSourcePanel.this.sysprops.setText("");
                Connection con = null;
                try {
                    JDBCDataSource dbcs = new JDBCDataSource((DataSourceCollection)JDBCDataSourcePanel.this.dbcs.getParentCollection());
                    String name = JDBCDataSourcePanel.this.dbNameField.getText();
                    dbcs.setName(name);
                    dbcs.setDisplayName(name);
                    dbcs.setParentType((JDBCDataSourceType)JDBCDataSourcePanel.this.dataSourceTypeBox.getSelectedItem());
                    dbcs.setUrl(JDBCDataSourcePanel.this.dbUrlField.getText());
                    dbcs.setUser(JDBCDataSourcePanel.this.dbUserField.getText());
                    dbcs.setPass(new String(JDBCDataSourcePanel.this.dbPassField.getPassword()));
                    con = dbcs.createConnection();
                    JDBCDataSourcePanel.this.dbTestResult.setText(Messages.getString("SPDataSourcePanel.connectionTestSuccessful"));
                    JDBCDataSourcePanel.this.sysprops.append(JDBCDataSource.getConnectionInfoString(dbcs, true));
                }
                catch (SQLException ex) {
                    JDBCDataSourcePanel.this.dbTestResult.setText(Messages.getString("SPDataSourcePanel.connectionTestFailed"));
                    SPSUtils.showExceptionDialogNoReport(JDBCDataSourcePanel.this.panel, Messages.getString("SPDataSourcePanel.connectionTestException"), ex);
                }
                finally {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (SQLException ex) {
                            logger.error((Object)"Failed to close connection!", (Throwable)ex);
                        }
                    }
                }
            }
        });
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("pref, 4dlu, 0:grow"));
        builder.append(Messages.getString("SPDataSourcePanel.connectionNameLabel"), (Component)this.dbNameField);
        builder.append(Messages.getString("SPDataSourcePanel.databaseTypeLabel"), (Component)this.dataSourceTypeBox);
        builder.append(Messages.getString("SPDataSourcePanel.connectionOptionsLabel"), (Component)this.platformSpecificOptions.getPanel());
        builder.append(Messages.getString("SPDataSourcePanel.jdbcUrlLabel"), (Component)this.dbUrlField);
        this.dbUserField = new JTextField(dbcs.getUser());
        builder.append(Messages.getString("SPDataSourcePanel.usernameLabel"), (Component)this.dbUserField);
        this.dbPassField = new JPasswordField(dbcs.getPass());
        builder.append(Messages.getString("SPDataSourcePanel.passwordLabel"), (Component)this.dbPassField);
        for (JComponent extraField : this.extraFields) {
            builder.append((String)extraField.getClientProperty(EXTRA_FIELD_LABEL_PROP), (Component)extraField);
        }
        builder.append((Component)this.dbTestConnection, (Component)this.dbTestResult);
        builder.append("\t\t", (Component)this.sysprops);
        this.dataSourceTypeBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JDBCDataSourceType parentType = (JDBCDataSourceType)JDBCDataSourcePanel.this.dataSourceTypeBox.getSelectedItem();
                JDBCDataSourcePanel.this.platformSpecificOptions.setTemplate(parentType);
            }
        });
        JPanel p = builder.getPanel();
        p.setPreferredSize(new Dimension(600, 300));
        return p;
    }

    public JComboBox getDataSourceTypeBox() {
        return this.dataSourceTypeBox;
    }

    public JDBCDataSource getDbcs() {
        return this.dbcs;
    }

    protected void addExtraField(JComponent component) {
        if (this.panel != null) {
            throw new IllegalStateException("You can't do this after calling getPanel()");
        }
        this.extraFields.add(component);
    }

    @Override
    public boolean applyChanges() {
        this.dbNameField.setText(this.dbNameField.getText().trim());
        if ("".equals(this.dbNameField.getText())) {
            JOptionPane.showMessageDialog(this.panel, Messages.getString("SPDataSourcePanel.blankNameNotAllowed"));
            return false;
        }
        SPDataSource existingDSWithThisName = this.dbcs.getParentCollection().getDataSource(this.dbNameField.getText());
        if (this.enforcingUniqueName && existingDSWithThisName != null && existingDSWithThisName != this.dbcs) {
            JOptionPane.showMessageDialog(this.panel, Messages.getString("SPDataSourcePanel.connectionAlreadyExists", this.dbNameField.getText()));
            return false;
        }
        logger.debug((Object)"Applying changes...");
        String name = this.dbNameField.getText();
        this.dbcs.setName(name);
        this.dbcs.setDisplayName(name);
        this.dbcs.setParentType((JDBCDataSourceType)this.dataSourceTypeBox.getSelectedItem());
        this.dbcs.setUrl(this.dbUrlField.getText());
        this.dbcs.setUser(this.dbUserField.getText());
        this.dbcs.setPass(new String(this.dbPassField.getPassword()));
        return true;
    }

    @Override
    public void discardChanges() {
    }

    @Override
    public JPanel getPanel() {
        if (this.panel == null) {
            this.panel = this.buildGeneralPanel(this.dbcs);
        }
        return this.panel;
    }

    @Override
    public boolean hasUnsavedChanges() {
        return true;
    }

    public void setEnforcingUniqueName(boolean enforceUniqueName) {
        this.enforcingUniqueName = enforceUniqueName;
    }

    public boolean isEnforcingUniqueName() {
        return this.enforcingUniqueName;
    }
}

