/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.plugin;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import javax.management.ObjectName;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerFilter;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ConnectionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractRuntimeConfigurationBroker
extends BrokerFilter {
    public static final Logger LOG = LoggerFactory.getLogger(AbstractRuntimeConfigurationBroker.class);
    protected final ReentrantReadWriteLock addDestinationBarrier = new ReentrantReadWriteLock();
    protected final ReentrantReadWriteLock addConnectionBarrier = new ReentrantReadWriteLock();
    protected Runnable monitorTask;
    protected ConcurrentLinkedQueue<Runnable> addDestinationWork = new ConcurrentLinkedQueue();
    protected ConcurrentLinkedQueue<Runnable> addConnectionWork = new ConcurrentLinkedQueue();
    protected ObjectName objectName;
    protected String infoString;
    Pattern matchPassword = Pattern.compile("password=.*,");

    public AbstractRuntimeConfigurationBroker(Broker next) {
        super(next);
    }

    public void start() throws Exception {
        super.start();
    }

    public void stop() throws Exception {
        if (this.monitorTask != null) {
            try {
                this.getBrokerService().getScheduler().cancel(this.monitorTask);
            }
            catch (Exception letsNotStopStop) {
                LOG.warn("Failed to cancel config monitor task", (Throwable)letsNotStopStop);
            }
        }
        this.unregisterMbean();
        super.stop();
    }

    protected void registerMbean() {
    }

    protected void unregisterMbean() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Destination addDestination(ConnectionContext context, ActiveMQDestination destination, boolean createIfTemporary) throws Exception {
        Runnable work = this.addDestinationWork.poll();
        if (work != null) {
            try {
                this.addDestinationBarrier.writeLock().lockInterruptibly();
                do {
                    work.run();
                } while ((work = this.addDestinationWork.poll()) != null);
                Destination destination2 = super.addDestination(context, destination, createIfTemporary);
                return destination2;
            }
            finally {
                this.addDestinationBarrier.writeLock().unlock();
            }
        }
        try {
            this.addDestinationBarrier.readLock().lockInterruptibly();
            Destination destination3 = super.addDestination(context, destination, createIfTemporary);
            return destination3;
        }
        finally {
            this.addDestinationBarrier.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(ConnectionContext context, ConnectionInfo info) throws Exception {
        Runnable work = this.addConnectionWork.poll();
        if (work != null) {
            try {
                this.addConnectionBarrier.writeLock().lockInterruptibly();
                do {
                    work.run();
                } while ((work = this.addConnectionWork.poll()) != null);
                super.addConnection(context, info);
            }
            finally {
                this.addConnectionBarrier.writeLock().unlock();
            }
        }
        try {
            this.addConnectionBarrier.readLock().lockInterruptibly();
            super.addConnection(context, info);
        }
        finally {
            this.addConnectionBarrier.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyDestinationWork() throws Exception {
        Runnable work = this.addDestinationWork.poll();
        if (work != null) {
            try {
                this.addDestinationBarrier.writeLock().lockInterruptibly();
                do {
                    work.run();
                } while ((work = this.addDestinationWork.poll()) != null);
            }
            finally {
                this.addDestinationBarrier.writeLock().unlock();
            }
        }
    }

    protected void debug(String s) {
        LOG.debug(s);
    }

    protected void info(String s) {
        LOG.info(this.filterPasswords(s));
        if (this.infoString != null) {
            this.infoString = this.infoString + s;
            this.infoString = this.infoString + ";";
        }
    }

    protected void info(String s, Throwable t) {
        LOG.info(this.filterPasswords(s), t);
        if (this.infoString != null) {
            this.infoString = this.infoString + s;
            this.infoString = this.infoString + ", " + t;
            this.infoString = this.infoString + ";";
        }
    }

    protected String filterPasswords(Object toEscape) {
        return this.matchPassword.matcher(toEscape.toString()).replaceAll("password=???,");
    }
}

