/*	$OpenBSD: octhcireg.h,v 1.2 2014/08/11 18:29:56 miod Exp $	*/

/*
 * Copyright (c) 2007 Internet Initiative Japan, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * Cavium Networks OCTEON CN30XX Hardware Reference Manual
 * CN30XX-HM-1.0
 * 21.9.1 USBN Registers
 *
 * Cavium Networks OCTEON CN30XX Hardware Reference Manual
 * CN50XX-HM-0.99
 * 21.8.1 USBN Registers
 */

#ifndef _OCTHCIREGREG_H_
#define _OCTHCIREGREG_H_

#include <sys/stdint.h>

typedef u_int32_t octhci_physaddr_t;

/*
 * USBN Registers - interface with the USB core
 */
#define	USBN_INT_SUM				0x0001180068000000ULL
#define	USBN_INT_ENB				0x0001180068000008ULL
#define	USBN_CLK_CTL				0x0001180068000010ULL
#define	USBN_USBP_CTL_STATUS			0x0001180068000018ULL
#define	USBN_BIST_STATUS			0x00011800680007f8ULL
#define	USBN_CTL_STATUS				0x00016F0000000800ULL
#define	USBN_DMA_TEST				0x00016F0000000808ULL

#define	USBN_DMA0_INB_CHN0			0x00016F0000000818ULL
#define	USBN_DMA0_INB_CHN1			0x00016F0000000820ULL
#define	USBN_DMA0_INB_CHN2			0x00016F0000000828ULL
#define	USBN_DMA0_INB_CHN3			0x00016F0000000830ULL
#define	USBN_DMA0_INB_CHN4			0x00016F0000000838ULL
#define	USBN_DMA0_INB_CHN5			0x00016F0000000840ULL
#define	USBN_DMA0_INB_CHN6			0x00016F0000000848ULL
#define	USBN_DMA0_INB_CHN7			0x00016F0000000850ULL

#define	USBN_DMA0_OUTB_CHN0			0x00016F0000000858ULL
#define	USBN_DMA0_OUTB_CHN1			0x00016F0000000860ULL
#define	USBN_DMA0_OUTB_CHN2			0x00016F0000000868ULL
#define	USBN_DMA0_OUTB_CHN3			0x00016F0000000870ULL
#define	USBN_DMA0_OUTB_CHN4			0x00016F0000000878ULL
#define	USBN_DMA0_OUTB_CHN5			0x00016F0000000880ULL
#define	USBN_DMA0_OUTB_CHN6			0x00016F0000000888ULL
#define	USBN_DMA0_OUTB_CHN7			0x00016F0000000890ULL

/* ---- register bits */

/* for USBN_INT_SUM and USBN_INT_ENB */
#define USBN_INT_XXX_63_38			0xffffffc000000000ULL
#define	USBN_INT_ND4O_DPF			0x0000002000000000ULL
#define	USBN_INT_ND4O_DPE			0x0000001000000000ULL
#define	USBN_INT_ND4O_RPF			0x0000000800000000ULL
#define	USBN_INT_ND4O_RPE			0x0000000400000000ULL
#define USBN_INT_LTL_F_PF			0x0000000200000000ULL
#define USBN_INT_LTL_F_PE			0x0000000100000000ULL
#define USBN_INT_U2N_C_PE			0x0000000080000000ULL
#define USBN_INT_U2N_C_PF			0x0000000040000000ULL
#define USBN_INT_U2N_D_PF			0x0000000020000000ULL
#define USBN_INT_U2N_D_PE			0x0000000010000000ULL
#define USBN_INT_N2U_PE				0x0000000008000000ULL
#define USBN_INT_N2U_PF				0x0000000004000000ULL
#define USBN_INT_UOD_PF				0x0000000002000000ULL
#define USBN_INT_UOD_PE				0x0000000001000000ULL
#define USBN_INT_RQ_Q3_E			0x0000000000800000ULL
#define USBN_INT_RQ_Q3_F			0x0000000000400000ULL
#define USBN_INT_RQ_Q2_E			0x0000000000200000ULL
#define USBN_INT_RQ_Q2_F			0x0000000000100000ULL
#define USBN_INT_RG_FI_F			0x0000000000080000ULL
#define USBN_INT_RG_FI_E			0x0000000000040000ULL
#define USBN_INT_LT_FI_F			0x0000000000020000ULL
#define USBN_INT_LT_FI_E			0x0000000000010000ULL
#define USBN_INT_L2C_A_F			0x0000000000008000ULL
#define USBN_INT_L2C_S_E			0x0000000000004000ULL
#define USBN_INT_DCRED_F			0x0000000000002000ULL
#define USBN_INT_DCRED_E			0x0000000000001000ULL
#define USBN_INT_LT_PU_F			0x0000000000000800ULL
#define USBN_INT_LT_PO_E			0x0000000000000400ULL
#define USBN_INT_NT_PU_F			0x0000000000000200ULL
#define USBN_INT_NT_PO_E			0x0000000000000100ULL
#define USBN_INT_PT_PU_F			0x0000000000000080ULL
#define USBN_INT_PT_PO_E			0x0000000000000040ULL
#define USBN_INT_LR_PU_F			0x0000000000000020ULL
#define USBN_INT_LR_PO_E			0x0000000000000010ULL
#define USBN_INT_NR_PU_F			0x0000000000000008ULL
#define USBN_INT_NR_PO_E			0x0000000000000004ULL
#define USBN_INT_PR_PU_F			0x0000000000000002ULL
#define USBN_INT_PR_PO_E			0x0000000000000001ULL

#define USBN_CLK_CTL_XXX_63_18			0xfffffffffffc0000ULL
#define USBN_CLK_CTL_HCLK_RST			0x0000000000020000ULL
#define USBN_CLK_CTL_P_X_ON			0x0000000000010000ULL
#define USBN_CLK_CTL_P_RCLK			0x0000000000008000ULL
#define USBN_CLK_CTL_P_XENBN			0x0000000000004000ULL
#define USBN_CLK_CTL_P_COM_ON			0x0000000000002000ULL
#define USBN_CLK_CTL_P_C_SEL			0x0000000000001800ULL
#define  SET_USBN_CLK_CTL_P_C_SEL(v) (((v)<<11) & USBN_CLK_CTL_P_C_SEL)
#define  GET_USBN_CLK_CTL_P_C_SEL(v) (((v) & USBN_CLK_CTL_P_C_SEL) >> 11)
#define USBN_CLK_CTL_CDIV_BYP			0x0000000000000400ULL
#define USBN_CLK_CTL_SD_MODE			0x0000000000000300ULL
#define USBN_CLK_CTL_S_BIST			0x0000000000000080ULL
#define USBN_CLK_CTL_POR			0x0000000000000040ULL
#define USBN_CLK_CTL_ENABLE			0x0000000000000020ULL
#define USBN_CLK_CTL_PRST			0x0000000000000010ULL
#define USBN_CLK_CTL_HRST			0x0000000000000008ULL
#define USBN_CLK_CTL_DIVIDE			0x0000000000000007ULL
#define  SET_USBN_CLK_CTL_DIVIDE(v) (((v)<<0) & USBN_CLK_CTL_DIVIDE)
#define  GET_USBN_CLK_CTL_DIVIDE(v) (((v) & USBN_CLK_CTL_DIVIDE) >> 0)
/* CN50xx extension */
#define USBN_CLK_CTL_DIVIDE2			0x00000000000c0000ULL
#define  SET_USBN_CLK_CTL_DIVIDE2(v) (((v)<<18) & USBN_CLK_CTL_DIVIDE2)
#define  GET_USBN_CLK_CTL_DIVIDE2(v) (((v) & USBN_CLK_CTL_DIVIDE2) >> 18)
#define USBN_CLK_CTL_P_RTYPE			0x000000000000c000ULL
#define  SET_USBN_CLK_CTL_P_RTYPE(v) (((v)<<14) & USBN_CLK_CTL_P_RTYPE)
#define  GET_USBN_CLK_CTL_P_RTYPE(v) (((v) & USBN_CLK_CTL_P_RTYPE) >> 14)

#define USBN_USBP_CTL_STATUS_XXX_63_38		0xffffffc000000000ULL
#define USBN_USBP_CTL_STATUS_BIST_DONE		0x0000002000000000ULL
#define USBN_USBP_CTL_STATUS_BIST_ERR		0x0000001000000000ULL
#define USBN_USBP_CTL_STATUS_TDATA_OUT		0x0000000f00000000ULL
#define USBN_USBP_CTL_STATUS_SPARES		0x00000000e0000000ULL
#define USBN_USBP_CTL_STATUS_USBC_END		0x0000000010000000ULL
#define USBN_USBP_CTL_STATUS_USBP_BIST		0x0000000008000000ULL
#define USBN_USBP_CTL_STATUS_TCLK		0x0000000004000000ULL
#define USBN_USBP_CTL_STATUS_DP_PULLD		0x0000000002000000ULL
#define USBN_USBP_CTL_STATUS_DM_PULLD		0x0000000001000000ULL
#define USBN_USBP_CTL_STATUS_HST_MODE		0x0000000000800000ULL
#define USBN_USBP_CTL_STATUS_TUNING		0x0000000000780000ULL
#define USBN_USBP_CTL_STATUS_TX_BS_ENH		0x0000000000040000ULL
#define USBN_USBP_CTL_STATUS_TX_BS_EN		0x0000000000020000ULL
#define USBN_USBP_CTL_STATUS_LOOP_ENB		0x0000000000010000ULL
#define USBN_USBP_CTL_STATUS_VTEST_ENB		0x0000000000008000ULL
#define USBN_USBP_CTL_STATUS_BIST_ENB		0x0000000000004000ULL
#define USBN_USBP_CTL_STATUS_TDATA_SEL		0x0000000000002000ULL
#define USBN_USBP_CTL_STATUS_TADDR_IN		0x0000000000001e00ULL
#define USBN_USBP_CTL_STATUS_TDATA_IN		0x00000000000001feULL
#define USBN_USBP_CTL_STATUS_ATE_RESET		0x0000000000000001ULL
/* CN50xx extension */
#define USBN_USBP_CTL_STATUS_TXRISETUNE		0x8000000000000000ULL
#define USBN_USBP_CTL_STATUS_TXVREFTUNE		0x7800000000000000ULL
#define USBN_USBP_CTL_STATUS_TXFSLSTUNE		0x0780000000000000ULL
#define USBN_USBP_CTL_STATUS_TXHSXVTUNE		0x0060000000000000ULL
#define USBN_USBP_CTL_STATUS_SQRXTUNE		0x001c000000000000ULL
#define USBN_USBP_CTL_STATUS_COMPDISTUNE	0x0003800000000000ULL
#define USBN_USBP_CTL_STATUS_OTGTUNE		0x0000700000000000ULL
#define USBN_USBP_CTL_STATUS_OTGDISABLE		0x0000080000000000ULL
#define USBN_USBP_CTL_STATUS_PORTRESET		0x0000040000000000ULL
#define USBN_USBP_CTL_STATUS_DRVVBUS		0x0000020000000000ULL
#define USBN_USBP_CTL_STATUS_LSBIST		0x0000010000000000ULL
#define USBN_USBP_CTL_STATUS_FSBIST		0x0000008000000000ULL
#define USBN_USBP_CTL_STATUS_HSBIST		0x0000004000000000ULL

#define USBN_BIST_STATUS_XXX_63_3		0xfffffffffffffff8ULL
#define USBN_BIST_STATUS_USBC_BIS		0x0000000000000004ULL
#define USBN_BIST_STATUS_NIF_BIS		0x0000000000000002ULL
#define USBN_BIST_STATUS_NOF_BIS		0x0000000000000001ULL
/* CN50xx extension */
#define USBN_BIST_STATUS_U2NC_BIS		0x0000000000000040ULL
#define USBN_BIST_STATUS_U2NF_BIS		0x0000000000000020ULL
#define USBN_BIST_STATUS_E2HC_BIS		0x0000000000000010ULL
#define USBN_BIST_STATUS_N2UF_BIS		0x0000000000000008ULL

#define USBN_CTL_STATUS_XXX_63_6		0xffffffffffffffc0ULL
#define USBN_CTL_STATUS_DMA_0PAG		0x0000000000000020ULL
#define USBN_CTL_STATUS_DMA_STT			0x0000000000000010ULL
#define USBN_CTL_STATUS_DMA_TEST		0x0000000000000008ULL
#define USBN_CTL_STATUS_INV_A2			0x0000000000000004ULL
#define USBN_CTL_STATUS_L2C_EMOD		0x0000000000000003ULL

#define USBN_DMA_TEST_XXX_63_40			0xffffff0000000000ULL
#define USBN_DMA_TEST_DONE			0x0000008000000000ULL
#define USBN_DMA_TEST_REQ			0x0000004000000000ULL
#define USBN_DMA_TEST_F_ADDR			0x0000003ffff00000ULL
#define USBN_DMA_TEST_COUNT			0x00000000000ffe00ULL
#define USBN_DMA_TEST_CHANNEL			0x00000000000001f0ULL
#define USBN_DMA_TEST_BURST			0x000000000000000fULL

/* for USBN_DMA0_INB_CHN(0..7) */
#define USBN_DMA0_INB_CHNX_XXX_63_36		0xfffffff000000000ULL
#define USBN_DMA0_INB_CHNX_ADDR			0x0000000fffffffffULL

/* for USBN_DMA0_OUTB_CHN(0..7) */
#define USBN_DMA0_OUTB_CHNX_XXX_63_36		0xfffffff000000000ULL
#define USBN_DMA0_OUTB_CHNX_ADDR		0x0000000fffffffffULL

/* ---- %b format strings */

#define	USBN_INT_BITS \
	"\020"		/* hex display */ \
	"\x25"		"ND4O_DPF" \
	"\x24"		"ND4O_DPE" \
	"\x23"		"ND4O_RPF" \
	"\x22"		"ND4O_RPE" \
	"\x21"		"LTL_F_PF" \
	"\x20"		"LTL_F_PE" \
	"\x1f"		"U2N_C_PE" \
	"\x1e"		"U2N_C_PF" \
	"\x1d"		"U2N_D_PF" \
	"\x1c"		"U2N_D_PE" \
	"\x1b"		"N2U_PE" \
	"\x1a"		"N2U_PF" \
	"\x19"		"UOD_PF" \
	"\x18"		"UOD_PE" \
	"\x17"		"RQ_Q3_E" \
	"\x16"		"RQ_Q3_F" \
	"\x15"		"RQ_Q2_E" \
	"\x14"		"RQ_Q2_F" \
	"\x13"		"RG_FI_F" \
	"\x12"		"RG_FI_E" \
	"\x11"		"LT_FI_F" \
	"\x10"		"LT_FI_E" \
	"\x0f"		"L2C_A_F" \
	"\x0e"		"L2C_S_E" \
	"\x0d"		"DCRED_F" \
	"\x0c"		"DCRED_E" \
	"\x0b"		"LT_PU_F" \
	"\x0a"		"LT_PO_E" \
	"\x09"		"NT_PU_F" \
	"\x08"		"NT_PO_E" \
	"\x07"		"PT_PU_F" \
	"\x06"		"PT_PO_E" \
	"\x05"		"LR_PU_F" \
	"\x04"		"LR_PO_E" \
	"\x03"		"NR_PU_F" \
	"\x02"		"NR_PO_E" \
	"\x01"		"PR_PU_F" \
	"\x00"		"PR_PO_E"

#define	USBN_CLK_CTL_BITS \
	"\020"		/* hex display */ \
	"\x12"		"DIVIDE2_2" \
	"\x11"		"HCLK_RST" \
	"\x10"		"RAZ" \
	"\x0e"		"P_RTYPE_2" \
	"\x0d"		"P_COM_ON" \
	"\x0b"		"P_C_SEL_2" \
	"\x0a"		"CDIV_BYP" \
	"\x08"		"SD_MODE_2" \
	"\x07"		"S_BIST" \
	"\x06"		"POR" \
	"\x05"		"ENABLE" \
	"\x04"		"PRST" \
	"\x03"		"HRST" \
	"\x00"		"DIVIDE_3"

#define	USBN_USBP_CTL_STATUS_BITS \
	"\020"		/* hex display */ \
	"\x3f"		"TXRISETUNE" \
	"\x3b"		"TXVREFTUNE_4" \
	"\x37"		"TXFSLSTUNE_4" \
	"\x35"		"TXHSXVTUNE_2" \
	"\x32"		"SQRXTUNE_3" \
	"\x2f"		"COMPDISTUNE_3" \
	"\x2c"		"OTGTUNE_3" \
	"\x2b"		"OTGDISABLE" \
	"\x2a"		"PORTRESET" \
	"\x29"		"DRVVBUS" \
	"\x28"		"LSBIST" \
	"\x27"		"FSBIST" \
	"\x26"		"HSBIST" \
	"\x25"		"BIST_DONE" \
	"\x24"		"BIST_ERR" \
	"\x20"		"TDATA_OUT_4" \
	"\x1d"		"SPARES_3" \
	"\x1c"		"USBC_END" \
	"\x1b"		"USBP_BIST" \
	"\x1a"		"TCLK" \
	"\x19"		"DP_PULLD" \
	"\x18"		"DM_PULLD" \
	"\x17"		"HST_MODE" \
	"\x13"		"TUNING_4" \
	"\x12"		"TX_BS_ENH" \
	"\x11"		"TX_BS_EN" \
	"\x10"		"LOOP_ENB" \
	"\x0f"		"VTEST_ENB" \
	"\x0e"		"BIST_ENB" \
	"\x0d"		"TDATA_SEL" \
	"\x09"		"TADDR_IN_4" \
	"\x01"		"TDATA_IN_8" \
	"\x00"		"ATE_RESET"

#define	USBN_BIST_STATUS_BITS \
	"\020"		/* hex display */ \
	"\x06"		"U2NC_BIS" \
	"\x05"		"U2NF_BIS" \
	"\x04"		"E2HC_BIS" \
	"\x03"		"N2UF_BIS" \
	"\x02"		"USBC_BIS" \
	"\x01"		"NIF_BIS" \
	"\x00"		"NOF_BIS"

#define	USBN_CTL_STATUS_BITS \
	"\020"		/* hex display */ \
	"\x05"		"DMA_0PAG" \
	"\x04"		"DMA_STT" \
	"\x03"		"DMA_TEST" \
	"\x02"		"INV_A2" \
	"\x01"		"L2C_EMOD_1" \
	"\x00"		"L2C_EMOD_0"

#define	USBN_DMA_TEST_BITS \
	"\020"		/* hex display */ \
	"\x27"		"DONE" \
	"\x26"		"REQ" \
	"\x14"		"F_ADDR_18" \
	"\x09"		"COUNT_12" \
	"\x04"		"CHANNEL_5" \
	"\x00"		"BURST_4"

/* ---- bus_space */

#define	USBN_NUNITS				1
#define	USBN_BASE				0x0001180068000000ULL
#define USBN_SIZE				0x800

#define USBN_INT_SUM_OFFSET			0x00000000
#define USBN_INT_ENB_OFFSET			0x00000008
#define USBN_CLK_CTL_OFFSET			0x00000010
#define USBN_USBP_CTL_STATUS_OFFSET		0x00000018
#define USBN_BIST_STATUS_OFFSET			0x000007f8


/* ---- bus_space 2 */

#define	USBN_2_NUNITS				1
#define	USBN_2_BASE				0x00016F0000000800ULL
#define USBN_2_SIZE				0x098

#define USBN_CTL_STATUS_OFFSET			0x00000000
#define USBN_DMA_TEST_OFFSET			0x00000008
#define USBN_DMA0_INB_CHN0_OFFSET		0x00000018
#define USBN_DMA0_INB_CHN1_OFFSET		0x00000020
#define USBN_DMA0_INB_CHN2_OFFSET		0x00000028
#define USBN_DMA0_INB_CHN3_OFFSET		0x00000030
#define USBN_DMA0_INB_CHN4_OFFSET		0x00000038
#define USBN_DMA0_INB_CHN5_OFFSET		0x00000040
#define USBN_DMA0_INB_CHN6_OFFSET		0x00000048
#define USBN_DMA0_INB_CHN7_OFFSET		0x00000050
#define USBN_DMA0_OUTB_CHN0_OFFSET		0x00000058
#define USBN_DMA0_OUTB_CHN1_OFFSET		0x00000060
#define USBN_DMA0_OUTB_CHN2_OFFSET		0x00000068
#define USBN_DMA0_OUTB_CHN3_OFFSET		0x00000070
#define USBN_DMA0_OUTB_CHN4_OFFSET		0x00000078
#define USBN_DMA0_OUTB_CHN5_OFFSET		0x00000080
#define USBN_DMA0_OUTB_CHN6_OFFSET		0x00000088
#define USBN_DMA0_OUTB_CHN7_OFFSET		0x00000090



/*
 * Cavium Networks OCTEON CN30XX Hardware Reference Manual
 * CN30XX-HM-1.0
 * 21.9.2 USBC Registers
 */

/*
 * XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
 * XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
 */

/*
 * USBC Registers - control the USB core
 */
#define USBC_GOTGCTL				0x00016F0010000000ULL
#define USBC_GOTGINT				0x00016F0010000004ULL
#define USBC_GAHBCFG				0x00016F0010000008ULL
#define USBC_GUSBCFG				0x00016F001000000CULL
#define USBC_GRSTCTL				0x00016F0010000010ULL
#define USBC_GINTSTS				0x00016F0010000014ULL
#define USBC_GINTMSK				0x00016F0010000018ULL
#define USBC_GRXSTSRH				0x00016F001000001CULL
#define USBC_GRXSTSPH				0x00016F0010000020ULL
#define USBC_GRXFSIZ				0x00016F0010000024ULL
#define USBC_GNPTXFSIZ				0x00016F0010000028ULL
#define USBC_GNPTXSTS				0x00016F001000002CULL
#define USBC_GSNPSID				0x00016F0010000040ULL
#define USBC_GHWCFG1				0x00016F0010000044ULL
#define USBC_GHWCFG2				0x00016F0010000048ULL
#define USBC_GHWCFG3				0x00016F001000004CULL
#define USBC_GHWCFG4				0x00016F0010000050ULL
#define USBC_HPTXFSIZ				0x00016F0010000100ULL
#define USBC_DPTXFSIZ1				0x00016F0010000104ULL
#define USBC_DPTXFSIZ2				0x00016F0010000108ULL
#define USBC_DPTXFSIZ3				0x00016F001000010CULL
#define USBC_DPTXFSIZ4				0x00016F0010000110ULL
#define USBC_HCFG				0x00016F0010000400ULL
#define USBC_HFIR				0x00016F0010000404ULL
#define USBC_HFNUM				0x00016F0010000408ULL
#define USBC_HPTXSTS				0x00016F0010000410ULL
#define USBC_HAINT				0x00016F0010000414ULL
#define USBC_HAINTMSK				0x00016F0010000418ULL
#define USBC_HPRT				0x00016F0010000440ULL
#define USBC_HCCHAR0				0x00016F0010000500ULL
#define USBC_HCCHAR1				0x00016F0010000520ULL
#define USBC_HCCHAR2				0x00016F0010000540ULL
#define USBC_HCCHAR3				0x00016F0010000560ULL
#define USBC_HCCHAR4				0x00016F0010000580ULL
#define USBC_HCCHAR5				0x00016F00100005A0ULL
#define USBC_HCCHAR6				0x00016F00100005C0ULL
#define USBC_HCCHAR7				0x00016F00100005E0ULL
#define USBC_HCSPLT0				0x00016F0010000504ULL
#define USBC_HCSPLT1				0x00016F0010000524ULL
#define USBC_HCSPLT2				0x00016F0010000544ULL
#define USBC_HCSPLT3				0x00016F0010000564ULL
#define USBC_HCSPLT4				0x00016F0010000584ULL
#define USBC_HCSPLT5				0x00016F00100005A4ULL
#define USBC_HCSPLT6				0x00016F00100005C4ULL
#define USBC_HCSPLT7				0x00016F00100005E4ULL
#define USBC_HCINT0				0x00016F0010000508ULL
#define USBC_HCINT1				0x00016F0010000528ULL
#define USBC_HCINT2				0x00016F0010000548ULL
#define USBC_HCINT3				0x00016F0010000568ULL
#define USBC_HCINT4				0x00016F0010000588ULL
#define USBC_HCINT5				0x00016F00100005A8ULL
#define USBC_HCINT6				0x00016F00100005C8ULL
#define USBC_HCINT7				0x00016F00100005E8ULL
#define USBC_HCINTMSK0				0x00016F001000050CULL
#define USBC_HCINTMSK1				0x00016F001000052CULL
#define USBC_HCINTMSK2				0x00016F001000054CULL
#define USBC_HCINTMSK3				0x00016F001000056CULL
#define USBC_HCINTMSK4				0x00016F001000058CULL
#define USBC_HCINTMSK5				0x00016F00100005ACULL
#define USBC_HCINTMSK6				0x00016F00100005CCULL
#define USBC_HCINTMSK7				0x00016F00100005ECULL
#define USBC_HCTSIZ0				0x00016F0010000510ULL
#define USBC_HCTSIZ1				0x00016F0010000530ULL
#define USBC_HCTSIZ2				0x00016F0010000550ULL
#define USBC_HCTSIZ3				0x00016F0010000570ULL
#define USBC_HCTSIZ4				0x00016F0010000590ULL
#define USBC_HCTSIZ5				0x00016F00100005B0ULL
#define USBC_HCTSIZ6				0x00016F00100005D0ULL
#define USBC_HCTSIZ7				0x00016F00100005F0ULL
#define USBC_DCFG				0x00016F0010000800ULL
#define USBC_DCTL				0x00016F0010000804ULL
#define USBC_DSTS				0x00016F0010000808ULL
#define USBC_DIEPMSK				0x00016F0010000810ULL
#define USBC_DOEPMSK				0x00016F0010000814ULL
#define USBC_DAINT				0x00016F0010000818ULL
#define USBC_DAINTMSK				0x00016F001000081CULL
#define USBC_DTKNQR1				0x00016F0010000820ULL
#define USBC_DTKNQR2				0x00016F0010000824ULL
#define USBC_DTKNQR3				0x00016F0010000830ULL
#define USBC_DTKNQR4				0x00016F0010000834ULL
#define USBC_DIEPCTL0				0x00016F0010000900ULL
#define USBC_DIEPCTL1				0x00016F0010000920ULL
#define USBC_DIEPCTL2				0x00016F0010000940ULL
#define USBC_DIEPCTL3				0x00016F0010000960ULL
#define USBC_DIEPCTL4				0x00016F0010000980ULL
#define USBC_DIEPINT0				0x00016F0010000908ULL
#define USBC_DIEPINT1				0x00016F0010000928ULL
#define USBC_DIEPINT2				0x00016F0010000948ULL
#define USBC_DIEPINT3				0x00016F0010000968ULL
#define USBC_DIEPINT4				0x00016F0010000988ULL
#define USBC_DIEPTSIZ0				0x00016F0010000910ULL
#define USBC_DIEPTSIZ1				0x00016F0010000930ULL
#define USBC_DIEPTSIZ2				0x00016F0010000950ULL
#define USBC_DIEPTSIZ3				0x00016F0010000970ULL
#define USBC_DIEPTSIZ4				0x00016F0010000990ULL
#define USBC_OEPCTL0				0x00016F0010000B00ULL
#define USBC_OEPCTL1				0x00016F0010000B20ULL
#define USBC_OEPCTL2				0x00016F0010000B40ULL
#define USBC_OEPCTL3				0x00016F0010000B60ULL
#define USBC_OEPCTL4				0x00016F0010000B80ULL
#define USBC_OEPINT0				0x00016F0010000B08ULL
#define USBC_OEPINT1				0x00016F0010000B28ULL
#define USBC_OEPINT2				0x00016F0010000B48ULL
#define USBC_OEPINT3				0x00016F0010000B68ULL
#define USBC_OEPINT4				0x00016F0010000B88ULL
#define USBC_OEPTSIZ0				0x00016F0010000B10ULL
#define USBC_OEPTSIZ1				0x00016F0010000B30ULL
#define USBC_OEPTSIZ2				0x00016F0010000B50ULL
#define USBC_OEPTSIZ3				0x00016F0010000B70ULL
#define USBC_OEPTSIZ4				0x00016F0010000B90ULL
#define USBC_PCGCCTL				0x00016F0010000E00ULL
#define USBC_NPTXDFIFO0				0x00016F0010001000ULL
#define USBC_NPTXDFIFO1				0x00016F0010002000ULL
#define USBC_NPTXDFIFO2				0x00016F0010003000ULL
#define USBC_NPTXDFIFO3				0x00016F0010004000ULL
#define USBC_NPTXDFIFO4				0x00016F0010005000ULL
#define USBC_NPTXDFIFO5				0x00016F0010006000ULL
#define USBC_NPTXDFIFO6				0x00016F0010007000ULL
#define USBC_NPTXDFIFO7				0x00016F0010008000ULL
#define USBC_GRXSTSRD				0x00016F001004001CULL
#define USBC_GRXSTSPD				0x00016F0010040020ULL

/* ---- register bits */

#define USBC_GOTGCTL_XXX_31_21			0xffe00000
#define USBC_GOTGCTL_XXX_20			UINT32_C(0x00100000)
#define USBC_GOTGCTL_BSESVLD			UINT32_C(0x00080000)
#define USBC_GOTGCTL_ASESVLD			UINT32_C(0x00040000)
#define USBC_GOTGCTL_DBNCTIME			UINT32_C(0x00020000)
#define USBC_GOTGCTL_CONIDSTS			UINT32_C(0x00010000)
#define USBC_GOTGCTL_XXX_15_12			0x0000f000
#define USBC_GOTGCTL_DEVHNPEN			UINT32_C(0x00000800)
#define USBC_GOTGCTL_HSTSETHNPEN		UINT32_C(0x00000400)
#define USBC_GOTGCTL_HNPREQ			UINT32_C(0x00000200)
#define USBC_GOTGCTL_HSTNEGSCS			UINT32_C(0x00000100)
#define USBC_GOTGCTL_XXX_7_2			0x000000fc
#define USBC_GOTGCTL_SESREQ			UINT32_C(0x00000002)
#define USBC_GOTGCTL_SESREQSCS			UINT32_C(0x00000001)

#define USBC_GOTGINT_XXX_31_20			0xfff00000
#define USBC_GOTGINT_DBNCEDONE			UINT32_C(0x00080000)
#define USBC_GOTGINT_ADEVTOUTCHG		UINT32_C(0x00040000)
#define USBC_GOTGINT_HSTNEGDET			UINT32_C(0x00020000)
#define USBC_GOTGINT_XXX_16_10			0x0001fc00
#define USBC_GOTGINT_HSTNEGSUCSTSCHNG		UINT32_C(0x00000200)
#define USBC_GOTGINT_SESREQSUCSTSCHNG		UINT32_C(0x00000100)
#define USBC_GOTGINT_XXX_7_3			0x000000f8
#define USBC_GOTGINT_SESENDDET			UINT32_C(0x00000004)
#define USBC_GOTGINT_XXX_1			UINT32_C(0x00000002)
#define USBC_GOTGINT_XXX_0			UINT32_C(0x00000001)

#define USBC_GAHBCFG_XXX_31_9			0xfffffe00
#define USBC_GAHBCFG_PTXFEMPLVL			UINT32_C(0x00000100)
#define USBC_GAHBCFG_NPTXFEMPLVL		UINT32_C(0x00000080)
#define USBC_GAHBCFG_XXX_6			UINT32_C(0x00000040)
#define USBC_GAHBCFG_DMAEN			UINT32_C(0x00000020)
#define USBC_GAHBCFG_HBSTLEN			0x0000001e
#define USBC_GAHBCFG_HBSTLEN_OFFSET		1
#define USBC_GAHBCFG_GLBLINTRMSK		UINT32_C(0x00000001)

#define USBC_GUSBCFG_XXX_31_17			0xfffe0000
#define USBC_GUSBCFG_OTGI2CSEL			UINT32_C(0x00010000)
#define USBC_GUSBCFG_PHYLPWRCLKSEL		UINT32_C(0x00008000)
#define USBC_GUSBCFG_XXX_14			UINT32_C(0x00004000)
#define USBC_GUSBCFG_USBTRDTIM			0x00003c00
#define USBC_GUSBCFG_USBTRDTIM_OFFSET		10
#define USBC_GUSBCFG_HNPCAP			UINT32_C(0x00000200)
#define USBC_GUSBCFG_SRPCAP			UINT32_C(0x00000100)
#define USBC_GUSBCFG_DDRSEL			UINT32_C(0x00000080)
#define USBC_GUSBCFG_PHYSEL			UINT32_C(0x00000040)
#define USBC_GUSBCFG_FSINTF			UINT32_C(0x00000020)
#define USBC_GUSBCFG_ULPI_UTMI_SEL		UINT32_C(0x00000010)
#define USBC_GUSBCFG_PHYIF			UINT32_C(0x00000008)
#define USBC_GUSBCFG_TOUTCAL			0x00000007
#define USBC_GUSBCFG_TOUTCAL_OFFSET		0

#define USBC_GRSTCTL_AHBIDLE			UINT32_C(0x80000000)
#define USBC_GRSTCTL_DMAREQ			UINT32_C(0x40000000)
#define USBC_GRSTCTL_XXX_29_11			0x3ffff800
#define USBC_GRSTCTL_TXFNUM			0x000007c0
#define USBC_GRSTCTL_TXFNUM_OFFSET		6
#define USBC_GRSTCTL_TXFFLSH			UINT32_C(0x00000020)
#define USBC_GRSTCTL_RXFFLSH			UINT32_C(0x00000010)
#define USBC_GRSTCTL_INTKNQFLSH			UINT32_C(0x00000008)
#define USBC_GRSTCTL_FRMCNTRRST			UINT32_C(0x00000004)
#define USBC_GRSTCTL_HSFTRST			UINT32_C(0x00000002)
#define USBC_GRSTCTL_CSFTRST			UINT32_C(0x00000001)

#define USBC_GINTSTS_WKUPINT			UINT32_C(0x80000000)
#define USBC_GINTSTS_SESSREQINT			UINT32_C(0x40000000)
#define USBC_GINTSTS_DISCONNINT			UINT32_C(0x20000000)
#define USBC_GINTSTS_CONIDSTSCHNG		UINT32_C(0x10000000)
#define USBC_GINTSTS_XXX_27			UINT32_C(0x08000000)
#define USBC_GINTSTS_PTXFEMP			UINT32_C(0x04000000)
#define USBC_GINTSTS_HCHINT			UINT32_C(0x02000000)
#define USBC_GINTSTS_PRTINT			UINT32_C(0x01000000)
#define USBC_GINTSTS_XXX_23			UINT32_C(0x00800000)
#define USBC_GINTSTS_FETSUSP			UINT32_C(0x00400000)
#define USBC_GINTSTS_INCOMPLP			UINT32_C(0x00200000)
#define USBC_GINTSTS_INCOMPISOIN		UINT32_C(0x00100000)
#define USBC_GINTSTS_OEPINT			UINT32_C(0x00080000)
#define USBC_GINTSTS_IEPINT			UINT32_C(0x00040000)
#define USBC_GINTSTS_EPMIS			UINT32_C(0x00020000)
#define USBC_GINTSTS_XXX_16			UINT32_C(0x00010000)
#define USBC_GINTSTS_EOPF			UINT32_C(0x00008000)
#define USBC_GINTSTS_ISOOUTDROP			UINT32_C(0x00004000)
#define USBC_GINTSTS_ENUMDONE			UINT32_C(0x00002000)
#define USBC_GINTSTS_USBRST			UINT32_C(0x00001000)
#define USBC_GINTSTS_USBSUSP			UINT32_C(0x00000800)
#define USBC_GINTSTS_ERLYSUSP			UINT32_C(0x00000400)
#define USBC_GINTSTS_I2CINT			UINT32_C(0x00000200)
#define USBC_GINTSTS_ULPICKINT			UINT32_C(0x00000100)
#define USBC_GINTSTS_GOUTNAKEFF			UINT32_C(0x00000080)
#define USBC_GINTSTS_GINNAKEFF			UINT32_C(0x00000040)
#define USBC_GINTSTS_NPTXFEMP			UINT32_C(0x00000020)
#define USBC_GINTSTS_RXFLVL			UINT32_C(0x00000010)
#define USBC_GINTSTS_SOF			UINT32_C(0x00000008)
#define USBC_GINTSTS_OTGINT			UINT32_C(0x00000004)
#define USBC_GINTSTS_MODEMIS			UINT32_C(0x00000002)
#define USBC_GINTSTS_CURMOD			UINT32_C(0x00000001)
#define USBC_GINTSTS_CURMOD_OFFSET		0
#define  USBC_GINTSTS_CURMOD_DEVICE		0x0
#define  USBC_GINTSTS_CURMOD_HOST		0x1

#define USBC_GINTMSK_WKUPINTMSK			UINT32_C(0x80000000)
#define USBC_GINTMSK_SESSREQINTMSK		UINT32_C(0x40000000)
#define USBC_GINTMSK_DISCONNINTMSK		UINT32_C(0x20000000)
#define USBC_GINTMSK_CONIDSTSTCHNGMSK		UINT32_C(0x10000000)
#define USBC_GINTMSK_XXX_27			UINT32_C(0x08000000)
#define USBC_GINTMSK_PTXFEMPMSK			UINT32_C(0x04000000)
#define USBC_GINTMSK_HCHINTMSK			UINT32_C(0x02000000)
#define USBC_GINTMSK_PRTINTMSK			UINT32_C(0x01000000)
#define USBC_GINTMSK_XXX_23			UINT32_C(0x00800000)
#define USBC_GINTMSK_FETSUSPMSK			UINT32_C(0x00400000)
#define USBC_GINTMSK_INCOMPISOOUTMSK		UINT32_C(0x00200000)
#define USBC_GINTMSK_INCOMPISOINMSK		UINT32_C(0x00100000)
#define USBC_GINTMSK_OEPINTMSK			UINT32_C(0x00080000)
#define USBC_GINTMSK_INEPINTMSK			UINT32_C(0x00040000)
#define USBC_GINTMSK_EPMISMSK			UINT32_C(0x00020000)
#define USBC_GINTMSK_XXX_16			UINT32_C(0x00010000)
#define USBC_GINTMSK_EOPFMSK			UINT32_C(0x00008000)
#define USBC_GINTMSK_ISOOUTDROPMSK		UINT32_C(0x00004000)
#define USBC_GINTMSK_ENUMDONEMSK		UINT32_C(0x00002000)
#define USBC_GINTMSK_USBRSTMSK			UINT32_C(0x00001000)
#define USBC_GINTMSK_USBSUSPMSK			UINT32_C(0x00000800)
#define USBC_GINTMSK_ERLYSUSPMSK		UINT32_C(0x00000400)
#define USBC_GINTMSK_I2CINT			UINT32_C(0x00000200)
#define USBC_GINTMSK_ULPICKINTMSK		UINT32_C(0x00000100)
#define USBC_GINTMSK_GOUTNAKEFFMSK		UINT32_C(0x00000080)
#define USBC_GINTMSK_GINNAKEFFMSK		UINT32_C(0x00000040)
#define USBC_GINTMSK_NPTXFEMPMSK		UINT32_C(0x00000020)
#define USBC_GINTMSK_RXFLVLMSK			UINT32_C(0x00000010)
#define USBC_GINTMSK_SOFMSK			UINT32_C(0x00000008)
#define USBC_GINTMSK_OTGINTMSK			UINT32_C(0x00000004)
#define USBC_GINTMSK_MODEMISMSK			UINT32_C(0x00000002)
#define USBC_GINTMSK_XXX_0			UINT32_C(0x00000001)

#define USBC_GRXSTSRH_XXX_31_21			0xffe00000
#define USBC_GRXSTSRH_PKTSTS			0x001e0000
#define USBC_GRXSTSRH_PKTSTS_OFFSET		17
#define USBC_GRXSTSRH_DPID			0x00018000
#define USBC_GRXSTSRH_DPID_OFFSET		15
#define  USBC_GRXSTSRH_DPID_DATA0		0x00
#define  USBC_GRXSTSRH_DPID_DATA1		0x10
#define  USBC_GRXSTSRH_DPID_DATA2		0x01
#define  USBC_GRXSTSRH_DPID_MDATA		0x11
#define USBC_GRXSTSRH_BCNT			0x00007ff0
#define USBC_GRXSTSRH_BCNT_OFFSET		4
#define USBC_GRXSTSRH_CHNUM			0x0000000f
#define USBC_GRXSTSRH_CHNUM_OFFSET		0

#define USBC_GRXSTSPH_XXX_31_21			0xffe00000
#define USBC_GRXSTSPH_PKTSTS			0x001e0000
#define USBC_GRXSTSPH_PKTSTS_OFFSET		17
#define  USBC_GRXSTSPH_PKTSTS_IN_DATA_RECV	0x2
#define  USBC_GRXSTSPH_PKTSTS_IN_XFER_COMPL	0x3
#define  USBC_GRXSTSPH_PKTSTS_TGL_ERR		0x5
#define  USBC_GRXSTSPH_PKTSTS_CH_HLTD		0x7
#define USBC_GRXSTSPH_DPID			0x00018000
#define USBC_GRXSTSPH_DPID_OFFSET		15
#define  USBC_GRXSTSPH_DPID_DATA0		0x00
#define  USBC_GRXSTSPH_DPID_DATA1		0x10
#define  USBC_GRXSTSPH_DPID_DATA2		0x01
#define  USBC_GRXSTSPH_DPID_MDATA		0x11
#define USBC_GRXSTSPH_BCNT			0x00007ff0
#define USBC_GRXSTSPH_BCNT_OFFSET		4
#define USBC_GRXSTSPH_CHNUM			0x0000000f
#define USBC_GRXSTSPH_CHNUM_OFFSET		0

#define USBC_GRXSTSRD_XXX_31_25			0xfe000000
#define USBC_GRXSTSRD_FN			0x01e00000
#define USBC_GRXSTSRD_PKTSTS			0x001e0000
#define USBC_GRXSTSRD_DPID			0x00018000
#define USBC_GRXSTSRD_BCNT			0x00007ff0
#define USBC_GRXSTSRD_EPNUM			0x0000000f

#define USBC_GRXSTSPD_XXX_31_25			0xfe000000
#define USBC_GRXSTSPD_FN			0x01e00000
#define USBC_GRXSTSPD_PKTSTS			0x001e0000
#define USBC_GRXSTSPD_DPID			0x00018000
#define USBC_GRXSTSPD_BCNT			0x00007ff0
#define USBC_GRXSTSPD_EPNUM			0x0000000f

#define USBC_GRXFSIZ_XXX_31_16			0xffff0000
#define USBC_GRXFSIZ_RXFDEP			0x0000ffff

#define USBC_GNPTXFSIZ_NPTXFEDP			0xffff0000
#define USBC_GNPTXFSIZ_NPTXFEDP_OFFSET		16
#define USBC_GNPTXFSIZ_NPTXFSTADDR		0x0000ffff

#define USBC_GNPTXSTS_XXX_31			UINT32_C(0x80000000)
#define USBC_GNPTXSTS_NPTXQTOP_CHNUM		0x78000000
#define USBC_GNPTXSTS_NPTXQTOP_ENTRY		0x06000000
#define USBC_GNPTXSTS_NPTXQTOP_TERMINATE	UINT32_C(0x01000000)
#define USBC_GNPTXSTS_NPTXQSPCAVAIL		0x00ff0000
#define USBC_GNPTXSTS_NPTXQSPCAVAIL_OFFSET	16
#define USBC_GNPTXSTS_NPTXFSPCAVAIL		0x0000ffff
#define USBC_GNPTXSTS_NPTXFSPCAVAIL_OFFSET	0

#define USBC_GSNPSID_SYNOPSYSID			0xffffffff

#define USBC_GHWCFG1_EPDIR			0xffffffff

#define USBC_GHWCFG2_XXX_31			UINT32_C(0x80000000)
#define USBC_GHWCFG2_TKNQDEPTH			0x7c000000
#define USBC_GHWCFG2_PTXQDEPTH			0x03000000
#define USBC_GHWCFG2_PTXQDEPTH_OFFSET		24
#define USBC_GHWCFG2_NPTXQDEPTH			0x00c00000
#define USBC_GHWCFG2_NPTXQDEPTH_OFFSET		22
#define USBC_GHWCFG2_XXX_21_20			0x00300000
#define USBC_GHWCFG2_DYNFIFOSIZING		UINT32_C(0x00080000)
#define USBC_GHWCFG2_PERIOSUPPORT		UINT32_C(0x00040000)
#define USBC_GHWCFG2_NUMHSTCHN1			0x0003c000
#define USBC_GHWCFG2_NUMHSTCHN1_OFFSET		14
#define USBC_GHWCFG2_NUMDEVEPS			0x00003c00
#define USBC_GHWCFG2_FSPHYTYPE			0x00000300
#define USBC_GHWCFG2_HSPHYTYPE			0x000000c0
#define USBC_GHWCFG2_SINGPNT			UINT32_C(0x00000020)
#define USBC_GHWCFG2_OTGARCH			0x00000018
#define USBC_GHWCFG2_OTGARCH_OFFSET		3
#define  USBC_GHWCFG2_OTGARCH_SLAVEONLY		0x0
#define  USBC_GHWCFG2_OTGARCH_EXTERNALDMA	0x1
#define  USBC_GHWCFG2_OTGARCH_INTERNALDMA	0x2
#define  USBC_GHWCFG2_OTGARCH_RESERVED		0x3
#define USBC_GHWCFG2_OTGMODE			0x00000007

#define USBC_GHWCFG3_DFIFODEPTH			0xffff0000
#define USBC_GHWCFG3_DFIFODEPTH_OFFSET		16
#define USBC_GHWCFG3_XXX_15_13			0x0000e000
#define USBC_GHWCFG3_AHBPHYSYNC			UINT32_C(0x00001000)
#define USBC_GHWCFG3_RSTTYPE			UINT32_C(0x00000800)
#define USBC_GHWCFG3_OPTFEATURE			UINT32_C(0x00000400)
#define USBC_GHWCFG3_VENDOR_CONTROL_INTERFACE_SUPPORT	UINT32_C(0x00000200)
#define USBC_GHWCFG3_I2C_SELECTION		UINT32_C(0x00000100)
#define USBC_GHWCFG3_OTGEN			UINT32_C(0x00000080)
#define USBC_GHWCFG3_PKTSIZEWIDTH		0x00000070
#define USBC_GHWCFG3_XFERSIZEWIDTH		0x0000000f

#define USBC_GHWCFG4_XXX_31_25			0xfe000000
#define USBC_GHWCFG4_SESSENDFLTR		UINT32_C(0x01000000)
#define USBC_GHWCFG4_BVAILDFLTR			UINT32_C(0x01000000)
#define USBC_GHWCFG4_AVAILDFLTR			UINT32_C(0x00800000)
#define USBC_GHWCFG4_VBUSVALIDFLTR		UINT32_C(0x00400000)
#define USBC_GHWCFG4_IDDGFLTR			UINT32_C(0x00200000)
#define USBC_GHWCFG4_NUMCTLEPS			0x000f0000
#define USBC_GHWCFG4_PHYDATAWIDTH		0x0000c000
#define USBC_GHWCFG4_XXX_13_6			0x00003fc0
#define USBC_GHWCFG4_AHBFREQ			UINT32_C(0x00000020)
#define USBC_GHWCFG4_ENABLEPWROPT		UINT32_C(0x00000010)
#define USBC_GHWCFG4_NUMDEVPERIOEPS		0x0000000f

#define USBC_HPTXFSIZ_PTXFSIZE			0xffff0000
#define USBC_HPTXFSIZ_PTXFSIZE_OFFSET		16
#define	USBC_HPTXFSIZ_PTXFSTADDR		0x0000ffff
#define USBC_HPTXFSIZ_PTXFSTADDR_OFFSET		0

/* for USBC_DPTXFSIZ(1..4) */
#define USBC_DPTXFSIZX_DPTXFSIZE		0xffff0000
#define USBC_DPTXFSIZX_PTXFSTADDR		0x0000ffff

#define USBC_HCFG_XXX_31_3			0xfffffff8
#define USBC_HCFG_FSLSSUPP			UINT32_C(0x00000004)
#define USBC_HCFG_FSLSPCLKSEL			0x00000003
#define USBC_HCFG_FSLSPCLKSEL_OFFSET		0
#define  USBC_HCFG_FSLSPCLKSEL_30_60_MHZ	0x00
#define  USBC_HCFG_FSLSPCLKSEL_48_MHZ		0x01
#define  USBC_HCFG_FSLSPCLKSEL_6_MHZ		0x10

#define USBC_HFIR_XXX_31_16			0xffff0000
#define USBC_HFIR_FRINT				0x0000ffff
#define USBC_HFIR_FRINT_OFFSET			0

#define USBC_HFNUM_FRREM			0xffff0000
#define USBC_HFNUM_FRNUM			0x0000ffff

#define USBC_HPTXSTS_PTXQTOP			0xff000000
#define USBC_HPTXSTS_PTXQSPCAVAIL		0x00ff0000
#define USBC_HPTXSTS_PTXQSPCAVAIL_OFFSET	16
#define USBC_HPTXSTS_PTXFSPCAVAIL		0x0000ffff
#define USBC_HPTXSTS_PTXFSPCAVAIL_OFFSET	0

#define USBC_HAINT_XXX_31_16			0xffff0000
/* #define USBC_HAINT_HAINT			__BITS32(15, 0) */
#define USBC_HAINT_HAINT_F			UINT32_C(0x00008000)
#define USBC_HAINT_HAINT_E			UINT32_C(0x00004000)
#define USBC_HAINT_HAINT_D			UINT32_C(0x00002000)
#define USBC_HAINT_HAINT_C			UINT32_C(0x00001000)
#define USBC_HAINT_HAINT_B			UINT32_C(0x00000800)
#define USBC_HAINT_HAINT_A			UINT32_C(0x00000400)
#define USBC_HAINT_HAINT_9			UINT32_C(0x00000200)
#define USBC_HAINT_HAINT_8			UINT32_C(0x00000100)
#define USBC_HAINT_HAINT_7			UINT32_C(0x00000080)
#define USBC_HAINT_HAINT_6			UINT32_C(0x00000040)
#define USBC_HAINT_HAINT_5			UINT32_C(0x00000020)
#define USBC_HAINT_HAINT_4			UINT32_C(0x00000010)
#define USBC_HAINT_HAINT_3			UINT32_C(0x00000008)
#define USBC_HAINT_HAINT_2			UINT32_C(0x00000004)
#define USBC_HAINT_HAINT_1			UINT32_C(0x00000002)
#define USBC_HAINT_HAINT_0			UINT32_C(0x00000001)

#define USBC_HAINTMSK_XXX_31_16			0xffff0000
/*#define USBC_HAINTMSK_HAINTMSK			__BITS32(15, 0) */
#define USBC_HAINTMSK_HAINTMSK_F		UINT32_C(0x00008000)
#define USBC_HAINTMSK_HAINTMSK_E		UINT32_C(0x00004000)
#define USBC_HAINTMSK_HAINTMSK_D		UINT32_C(0x00002000)
#define USBC_HAINTMSK_HAINTMSK_C		UINT32_C(0x00001000)
#define USBC_HAINTMSK_HAINTMSK_B		UINT32_C(0x00000800)
#define USBC_HAINTMSK_HAINTMSK_A		UINT32_C(0x00000400)
#define USBC_HAINTMSK_HAINTMSK_9		UINT32_C(0x00000200)
#define USBC_HAINTMSK_HAINTMSK_8		UINT32_C(0x00000100)
#define USBC_HAINTMSK_HAINTMSK_7		UINT32_C(0x00000080)
#define USBC_HAINTMSK_HAINTMSK_6		UINT32_C(0x00000040)
#define USBC_HAINTMSK_HAINTMSK_5		UINT32_C(0x00000020)
#define USBC_HAINTMSK_HAINTMSK_4		UINT32_C(0x00000010)
#define USBC_HAINTMSK_HAINTMSK_3		UINT32_C(0x00000008)
#define USBC_HAINTMSK_HAINTMSK_2		UINT32_C(0x00000004)
#define USBC_HAINTMSK_HAINTMSK_1		UINT32_C(0x00000002)
#define USBC_HAINTMSK_HAINTMSK_0		UINT32_C(0x00000001)

#define USBC_HPRT_XXX_31_19			0xfff80000
#define USBC_HPRT_PRTSPD			0x00060000
#define USBC_HPRT_PRTSPD_OFFSET			17
#define  USBC_HPRT_PRTSPD_HIGH			0x0
#define  USBC_HPRT_PRTSPD_FULL			0x1
#define  USBC_HPRT_PRTSPD_LOW			0x2
#define  USBC_HPRT_PRTSPD_RESERVED		0x3
#define USBC_HPRT_PRTTSTCTL			0x0001e000
#define USBC_HPRT_PRTPWR			UINT32_C(0x00001000)
#define USBC_HPRT_PRTLNSTS			0x00000c00
#define USBC_HPRT_XXX_9				UINT32_C(0x00000200)
#define USBC_HPRT_PRTRST			UINT32_C(0x00000100)
#define USBC_HPRT_PRTSUSP			UINT32_C(0x00000080)
#define USBC_HPRT_PRTRES			UINT32_C(0x00000040)
#define USBC_HPRT_PRTOVRCURRCHNG		UINT32_C(0x00000020)
#define USBC_HPRT_PRTOVRCURRACT			UINT32_C(0x00000010)
#define USBC_HPRT_PRTENCHNG			UINT32_C(0x00000008)
#define USBC_HPRT_PRTENA			UINT32_C(0x00000004)
#define USBC_HPRT_PRTCONNDET			UINT32_C(0x00000002)
#define USBC_HPRT_PRTCONNSTS			UINT32_C(0x00000001)

/* for USBC_HCCHAR(0..7) */
#define USBC_HCCHARX_CHENA			UINT32_C(0x80000000)
#define USBC_HCCHARX_CHDIS			UINT32_C(0x40000000)
#define USBC_HCCHARX_ODDFRM			UINT32_C(0x20000000)
#define USBC_HCCHARX_DEVADDR			0x1fc00000
#define USBC_HCCHARX_DEVADDR_OFFSET		22
#define USBC_HCCHARX_EC				0x00300000
#define USBC_HCCHARX_EC_OFFSET			20
#define USBC_HCCHARX_EPTYPE			0x000c0000
#define USBC_HCCHARX_EPTYPE_OFFSET		18
#define  USBC_HCCHARX_EPTYPE_CONTROL		0x00
#define  USBC_HCCHARX_EPTYPE_ISOCHRONOUS	0x01
#define  USBC_HCCHARX_EPTYPE_BULK		0x02
#define  USBC_HCCHARX_EPTYPE_INTERRUPT		0x03
#define USBC_HCCHARX_LSPDDEV			UINT32_C(0x00020000)
#define USBC_HCCHARX_XXX_16			UINT32_C(0x00010000)
#define USBC_HCCHARX_EPDIR			UINT32_C(0x00008000)
#define USBC_HCCHARX_EPNUM			0x00007800
#define USBC_HCCHARX_EPNUM_OFFSET		11
#define USBC_HCCHARX_MPS			0x000007ff
#define USBC_HCCHARX_MPS_OFFSET			0

/* for USBC_HCSPLT(0..7) */
#define USBC_HCSPLTX_SPLTENA			UINT32_C(0x80000000)
#define USBC_HCSPLTX_XXX_30_17			0x7ffe0000
#define USBC_HCSPLTX_COMPSPLT			UINT32_C(0x00010000)
#define USBC_HCSPLTX_XACTPOS			0x0000c000
#define USBC_HCSPLTX_HUBADDR			0x00003f80
#define USBC_HCSPLTX_PRTADDR			0x0000007f

/* for USBC_HCINT(0..7) */
#define USBC_HCINTX_XXX_31_11			0xfffff800
#define	USBC_HCINTX_DATATGLERR			UINT32_C(0x00000400)
#define	USBC_HCINTX_FRMOVRUN			UINT32_C(0x00000200)
#define	USBC_HCINTX_BBLERR			UINT32_C(0x00000100)
#define	USBC_HCINTX_XACTERR			UINT32_C(0x00000080)
#define	USBC_HCINTX_NYET			UINT32_C(0x00000040)
#define	USBC_HCINTX_ACK				UINT32_C(0x00000020)
#define	USBC_HCINTX_NAK				UINT32_C(0x00000010)
#define	USBC_HCINTX_STALL			UINT32_C(0x00000008)
#define	USBC_HCINTX_AHBERR			UINT32_C(0x00000004)
#define	USBC_HCINTX_CHHLTD			UINT32_C(0x00000002)
#define	USBC_HCINTX_XFERCOMPL			UINT32_C(0x00000001)

/* for USBC_HCINTMSK(0..7) */
#define USBC_HCINTMSKX_XXX_31_11		0xfffff800
#define	USBC_HCINTMSKX_DATATGLERRMSK		UINT32_C(0x00000400)
#define	USBC_HCINTMSKX_FRMOVRUNMSK		UINT32_C(0x00000200)
#define	USBC_HCINTMSKX_BBLERRMSK		UINT32_C(0x00000100)
#define	USBC_HCINTMSKX_XACTERRMSK		UINT32_C(0x00000080)
#define	USBC_HCINTMSKX_NYETMSK			UINT32_C(0x00000040)
#define	USBC_HCINTMSKX_ACKMSK			UINT32_C(0x00000020)
#define	USBC_HCINTMSKX_NAKMSK			UINT32_C(0x00000010)
#define	USBC_HCINTMSKX_STALLMSK			UINT32_C(0x00000008)
#define	USBC_HCINTMSKX_AHBERRMSK		UINT32_C(0x00000004)
#define	USBC_HCINTMSKX_CHHLTDMSK		UINT32_C(0x00000002)
#define	USBC_HCINTMSKX_XFERCOMPLMSK		UINT32_C(0x00000001)

/* for USBC_HCTSIZ(0..7) */
#define USBC_HCTSIZX_DOPNG			UINT32_C(0x80000000)
#define USBC_HCTSIZX_PID			0x60000000
#define USBC_HCTSIZX_PID_OFFSET			29
#define  USBC_HCTSIZX_PID_DATA0			0x00
#define  USBC_HCTSIZX_PID_DATA2			0x01
#define  USBC_HCTSIZX_PID_DATA1			0x02
#define  USBC_HCTSIZX_PID_MDATA_SETUP		0x03
#define USBC_HCTSIZX_PKTCNT			0x1ff80000
#define USBC_HCTSIZX_PKTCNT_OFFSET		19
#define USBC_HCTSIZX_XFERSIZE			0x0007ffff
#define USBC_HCTSIZX_XFERSIZE_OFFSET		0

/* XXX Device Mode Registers */



/* for USBC_NPTXDFIFO(0..7) */
#define USBC_NPTXDFIFOX_DATA			0xffffffff

/* ---- bus_space */

#define	USBC_BASE				0x00016F0010000000ULL
#define USBC_SIZE				0x40020

#define USBC_GOTGCTL_OFFSET			0x00000000
#define USBC_GOTGINT_OFFSET			0x00000004
#define USBC_GAHBCFG_OFFSET			0x00000008
#define USBC_GUSBCFG_OFFSET			0x0000000C
#define USBC_GRSTCTL_OFFSET			0x00000010
#define USBC_GINTSTS_OFFSET			0x00000014
#define USBC_GINTMSK_OFFSET			0x00000018
#define USBC_GRXSTSRH_OFFSET			0x0000001C
#define USBC_GRXSTSPH_OFFSET			0x00000020
#define USBC_GRXFSIZ_OFFSET			0x00000024
#define USBC_GNPTXFSIZ_OFFSET			0x00000028
#define USBC_GNPTXSTS_OFFSET			0x0000002C
#define USBC_GSNPSID_OFFSET			0x00000040
#define USBC_GHWCFG1_OFFSET			0x00000044
#define USBC_GHWCFG2_OFFSET			0x00000048
#define USBC_GHWCFG3_OFFSET			0x0000004C
#define USBC_GHWCFG4_OFFSET			0x00000050
#define USBC_HPTXFSIZ_OFFSET			0x00000100
#define USBC_DPTXFSIZ1_OFFSET			0x00000104
#define USBC_DPTXFSIZ2_OFFSET			0x00000108
#define USBC_DPTXFSIZ3_OFFSET			0x0000010C
#define USBC_DPTXFSIZ4_OFFSET			0x00000110
#define USBC_HCFG_OFFSET			0x00000400
#define USBC_HFIR_OFFSET			0x00000404
#define USBC_HFNUM_OFFSET			0x00000408
#define USBC_HPTXSTS_OFFSET			0x00000410
#define USBC_HAINT_OFFSET			0x00000414
#define USBC_HAINTMSK_OFFSET			0x00000418
#define USBC_HPRT_OFFSET			0x00000440
#define USBC_HCCHAR0_OFFSET			0x00000500
#define USBC_HCCHAR1_OFFSET			0x00000520
#define USBC_HCCHAR2_OFFSET			0x00000540
#define USBC_HCCHAR3_OFFSET			0x00000560
#define USBC_HCCHAR4_OFFSET			0x00000580
#define USBC_HCCHAR5_OFFSET			0x000005A0
#define USBC_HCCHAR6_OFFSET			0x000005C0
#define USBC_HCCHAR7_OFFSET			0x000005E0
#define USBC_HCSPLT0_OFFSET			0x00000504
#define USBC_HCSPLT1_OFFSET			0x00000524
#define USBC_HCSPLT2_OFFSET			0x00000544
#define USBC_HCSPLT3_OFFSET			0x00000564
#define USBC_HCSPLT4_OFFSET			0x00000584
#define USBC_HCSPLT5_OFFSET			0x000005A4
#define USBC_HCSPLT6_OFFSET			0x000005C4
#define USBC_HCSPLT7_OFFSET			0x000005E4
#define USBC_HCINT0_OFFSET			0x00000508
#define USBC_HCINT1_OFFSET			0x00000528
#define USBC_HCINT2_OFFSET			0x00000548
#define USBC_HCINT3_OFFSET			0x00000568
#define USBC_HCINT4_OFFSET			0x00000588
#define USBC_HCINT5_OFFSET			0x000005A8
#define USBC_HCINT6_OFFSET			0x000005C8
#define USBC_HCINT7_OFFSET			0x000005E8
#define USBC_HCINTMSK0_OFFSET			0x0000050C
#define USBC_HCINTMSK1_OFFSET			0x0000052C
#define USBC_HCINTMSK2_OFFSET			0x0000054C
#define USBC_HCINTMSK3_OFFSET			0x0000056C
#define USBC_HCINTMSK4_OFFSET			0x0000058C
#define USBC_HCINTMSK5_OFFSET			0x000005AC
#define USBC_HCINTMSK6_OFFSET			0x000005CC
#define USBC_HCINTMSK7_OFFSET			0x000005EC
#define USBC_HCTSIZ0_OFFSET			0x00000510
#define USBC_HCTSIZ1_OFFSET			0x00000530
#define USBC_HCTSIZ2_OFFSET			0x00000550
#define USBC_HCTSIZ3_OFFSET			0x00000570
#define USBC_HCTSIZ4_OFFSET			0x00000590
#define USBC_HCTSIZ5_OFFSET			0x000005B0
#define USBC_HCTSIZ6_OFFSET			0x000005D0
#define USBC_HCTSIZ7_OFFSET			0x000005F0
#define USBC_DCFG_OFFSET			0x00000800
#define USBC_DCTL_OFFSET			0x00000804
#define USBC_DSTS_OFFSET			0x00000808
#define USBC_DIEPMSK_OFFSET			0x00000810
#define USBC_DOEPMSK_OFFSET			0x00000814
#define USBC_DAINT_OFFSET			0x00000818
#define USBC_DAINTMSK_OFFSET			0x0000081C
#define USBC_DTKNQR1_OFFSET			0x00000820
#define USBC_DTKNQR2_OFFSET			0x00000824
#define USBC_DTKNQR3_OFFSET			0x00000830
#define USBC_DTKNQR4_OFFSET			0x00000834
#define USBC_DIEPCTL0_OFFSET			0x00000900
#define USBC_DIEPCTL1_OFFSET			0x00000920
#define USBC_DIEPCTL2_OFFSET			0x00000940
#define USBC_DIEPCTL3_OFFSET			0x00000960
#define USBC_DIEPCTL4_OFFSET			0x00000980
#define USBC_DIEPINT0_OFFSET			0x00000908
#define USBC_DIEPINT1_OFFSET			0x00000928
#define USBC_DIEPINT2_OFFSET			0x00000948
#define USBC_DIEPINT3_OFFSET			0x00000968
#define USBC_DIEPINT4_OFFSET			0x00000988
#define USBC_DIEPTSIZ0_OFFSET			0x00000910
#define USBC_DIEPTSIZ1_OFFSET			0x00000930
#define USBC_DIEPTSIZ2_OFFSET			0x00000950
#define USBC_DIEPTSIZ3_OFFSET			0x00000970
#define USBC_DIEPTSIZ4_OFFSET			0x00000990
#define USBC_OEPCTL0_OFFSET			0x00000B00
#define USBC_OEPCTL1_OFFSET			0x00000B20
#define USBC_OEPCTL2_OFFSET			0x00000B40
#define USBC_OEPCTL3_OFFSET			0x00000B60
#define USBC_OEPCTL4_OFFSET			0x00000B80
#define USBC_OEPINT0_OFFSET			0x00000B08
#define USBC_OEPINT1_OFFSET			0x00000B28
#define USBC_OEPINT2_OFFSET			0x00000B48
#define USBC_OEPINT3_OFFSET			0x00000B68
#define USBC_OEPINT4_OFFSET			0x00000B88
#define USBC_OEPTSIZ0_OFFSET			0x00000B10
#define USBC_OEPTSIZ1_OFFSET			0x00000B30
#define USBC_OEPTSIZ2_OFFSET			0x00000B50
#define USBC_OEPTSIZ3_OFFSET			0x00000B70
#define USBC_OEPTSIZ4_OFFSET			0x00000B90
#define USBC_PCGCCTL_OFFSET			0x00000E00
#define USBC_NPTXDFIFO0_OFFSET			0x00001000
#define USBC_NPTXDFIFO1_OFFSET			0x00002000
#define USBC_NPTXDFIFO2_OFFSET			0x00003000
#define USBC_NPTXDFIFO3_OFFSET			0x00004000
#define USBC_NPTXDFIFO4_OFFSET			0x00005000
#define USBC_NPTXDFIFO5_OFFSET			0x00006000
#define USBC_NPTXDFIFO6_OFFSET			0x00007000
#define USBC_NPTXDFIFO7_OFFSET			0x00008000
#define USBC_GRXSTSRD_OFFSET			0x0004001C
#define USBC_GRXSTSPD_OFFSET			0x00040020


#endif /* _OCTHCIREGREG_H_ */
