require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_MACHINE_PARAM_H_)) {
    eval 'sub _MACHINE_PARAM_H_ () {1;}' unless defined(&_MACHINE_PARAM_H_);
    eval 'sub _MACHINE () { &sparc64;}' unless defined(&_MACHINE);
    eval 'sub MACHINE () {"sparc64";}' unless defined(&MACHINE);
    eval 'sub _MACHINE_ARCH () { &sparc64;}' unless defined(&_MACHINE_ARCH);
    eval 'sub MACHINE_ARCH () {"sparc64";}' unless defined(&MACHINE_ARCH);
    eval 'sub MID_MACHINE () { &MID_SPARC64;}' unless defined(&MID_MACHINE);
    eval 'sub PAGE_SHIFT () {13;}' unless defined(&PAGE_SHIFT);
    eval 'sub PAGE_SIZE () {(1<<  &PAGE_SHIFT);}' unless defined(&PAGE_SIZE);
    eval 'sub PAGE_MASK () {( &PAGE_SIZE - 1);}' unless defined(&PAGE_MASK);
    eval 'sub KERNBASE () {0x1000000;}' unless defined(&KERNBASE);
    if(defined(&_KERNEL)) {
	eval 'sub KERNEND () {0xe0000000;}' unless defined(&KERNEND);
	eval 'sub _MAXNBPG () {8192;}' unless defined(&_MAXNBPG);
	eval 'sub AUXREG_VA () {(  &KERNEND +  &_MAXNBPG);}' unless defined(&AUXREG_VA);
	eval 'sub TMPMAP_VA () {(  &AUXREG_VA +  &_MAXNBPG);}' unless defined(&TMPMAP_VA);
	eval 'sub MSGBUF_VA () {(  &TMPMAP_VA +  &_MAXNBPG);}' unless defined(&MSGBUF_VA);
	eval 'sub INTSTACK () {(  &KERNEND + 8* &_MAXNBPG);}' unless defined(&INTSTACK);
	eval 'sub EINTSTACK () {(  &INTSTACK + 2* &USPACE);}' unless defined(&EINTSTACK);
	eval 'sub CPUINFO_VA () {(  &EINTSTACK);}' unless defined(&CPUINFO_VA);
	eval 'sub NBPG () { &PAGE_SIZE;}' unless defined(&NBPG);
	eval 'sub PGSHIFT () { &PAGE_SHIFT;}' unless defined(&PGSHIFT);
	eval 'sub PGOFSET () { &PAGE_MASK;}' unless defined(&PGOFSET);
	eval 'sub UPAGES () {2;}' unless defined(&UPAGES);
	eval 'sub USPACE () {( &UPAGES *  &PAGE_SIZE);}' unless defined(&USPACE);
	eval 'sub USPACE_ALIGN () {0;}' unless defined(&USPACE_ALIGN);
	eval 'sub NMBCLUSTERS () {4096;}' unless defined(&NMBCLUSTERS);
	unless(defined(&MSGBUFSIZE)) {
	    eval 'sub MSGBUFSIZE () {(1*  &PAGE_SIZE);}' unless defined(&MSGBUFSIZE);
	}
	eval 'sub NKMEMPAGES_MAX_DEFAULT () {((128* 1024* 1024) >>  &PAGE_SHIFT);}' unless defined(&NKMEMPAGES_MAX_DEFAULT);
	unless(defined(&_LOCORE)) {
	    eval 'sub DELAY {
	        my($n) = @_;
    		eval q( &delay($n));
	    }' unless defined(&DELAY);
	    if(defined (&SUN4US) || defined (&SUN4V)) {
		eval 'sub CPU_ISSUN4U () {( &cputyp ==  &CPU_SUN4U);}' unless defined(&CPU_ISSUN4U);
		eval 'sub CPU_ISSUN4US () {( &cputyp ==  &CPU_SUN4US);}' unless defined(&CPU_ISSUN4US);
		eval 'sub CPU_ISSUN4V () {( &cputyp ==  &CPU_SUN4V);}' unless defined(&CPU_ISSUN4V);
	    } else {
		eval 'sub CPU_ISSUN4U () {(1);}' unless defined(&CPU_ISSUN4U);
		eval 'sub CPU_ISSUN4US () {(0);}' unless defined(&CPU_ISSUN4US);
		eval 'sub CPU_ISSUN4V () {(0);}' unless defined(&CPU_ISSUN4V);
	    }
	}
	eval 'sub CPU_SUN4 () {0;}' unless defined(&CPU_SUN4);
	eval 'sub CPU_SUN4C () {1;}' unless defined(&CPU_SUN4C);
	eval 'sub CPU_SUN4M () {2;}' unless defined(&CPU_SUN4M);
	eval 'sub CPU_SUN4U () {3;}' unless defined(&CPU_SUN4U);
	eval 'sub CPU_SUN4US () {4;}' unless defined(&CPU_SUN4US);
	eval 'sub CPU_SUN4V () {5;}' unless defined(&CPU_SUN4V);
	unless(defined(&_LOCORE)) {
	    require 'machine/cpu.ph';
	}
    }
}
1;
