Ext.namespace('Zarafa.plugins.titlecounter');

/**
 * @class Zarafa.plugins.titlecounter.ABOUT
 * @extends String
 *
 * The copyright string holding the copyright notice for the Zarafa titlecounter Plugin.
 */
Zarafa.plugins.titlecounter.ABOUT = ""
	+ "<p>Copyright (C) 2005 - 2015  Zarafa B.V. &lt;info@zarafa.com&gt; and its licensors</p>"

	+ "<p>This program is free software: you can redistribute it and/or modify "
	+ "it under the terms of the GNU Affero General Public License as "
	+ "published by the Free Software Foundation, either version 3 of the "
	+ "License, or (at your option) any later version.</p>"

	+ "<p>This program is distributed in the hope that it will be useful, "
	+ "but WITHOUT ANY WARRANTY; without even the implied warranty of "
	+ "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the "
	+ "GNU Affero General Public License for more details.</p>"

	+ "<p>You should have received a copy of the GNU Affero General Public License "
	+ "along with this program.  If not, see <a href=\"http://www.gnu.org/licenses/\">http://www.gnu.org/licenses/</a>.</p>";
Ext.namespace('Zarafa.plugins.titlecounter');

/**
 * @class Zarafa.plugins.titlecounter.TitleCounter
 * @extends Zarafa.core.Plugin
 *
 * Plugin is used to update the title of a browser window or tab based on the number of unread mail(s) in
 * Inbox folder of Hierarchy.
 */
Zarafa.plugins.titlecounter.TitleCounter = Ext.extend(Zarafa.core.Plugin, {

	/**
	 * Add listener for load and updateFolder event of {@link Zarafa.hierarchy.data.HierarchyStore HierarchyStore}.
	 * @protected
	 */
	initPlugin : function()
	{
		Zarafa.plugins.titlecounter.TitleCounter.superclass.initPlugin.apply(this, arguments);

		container.getHierarchyStore().on('load', this.updateTitle, this, { single: true });
		container.getHierarchyStore().on('updateFolder', this.updateTitle, this);
	},

	/**
	 * Append and update the browser tab title based on the unread counter of Inbox folder in hierarchy.
	 */
	updateTitle : function()
	{
		var unreadCounter = container.getHierarchyStore().getDefaultFolder('inbox').get('content_unread');

		Ext.getDoc().dom.title = _('Zarafa WebApp');

		if (unreadCounter > 0) {
			Ext.getDoc().dom.title += ' (' + unreadCounter + ')';
		}
	}
});

Zarafa.onReady(function() {
	container.registerPlugin(new Zarafa.core.PluginMetaData({
		name : 'titlecounter',
		displayName : _('Title Counter Plugin'),
		about : Zarafa.plugins.titlecounter.ABOUT,
		pluginConstructor : Zarafa.plugins.titlecounter.TitleCounter
	}));
});
