require 'r10k/git/shellgit'
require 'r10k/git/shellgit/base_repository'

# Create and manage Git bare repositories.
class R10K::Git::ShellGit::BareRepository < R10K::Git::ShellGit::BaseRepository

  # @return [Pathname] The path to this Git repository
  def git_dir
    @path
  end

  # @param basedir [String] The base directory of the Git repository
  # @param dirname [String] The directory name of the Git repository
  def initialize(basedir, dirname)
    @path = Pathname.new(File.join(basedir, dirname))
  end

  def clone(remote)
    git ['clone', '--mirror', remote, git_dir.to_s]
  end

  def fetch
    git ['fetch', '--prune'], :git_dir => git_dir.to_s
  end

  def exist?
    @path.exist?
  end
end
