/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.URLEncoder;

public class Remote {
    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            System.out.println("usage: Remote URL(http|bsh) file [ file ] ... ");
            System.exit(1);
        }
        String string = stringArray[0];
        String string2 = Remote.getFile(stringArray[1]);
        int n = Remote.eval(string, string2, null);
        System.exit(n);
    }

    public static int eval(String string, String string2, StringBuffer stringBuffer) throws IOException {
        String string3 = null;
        if (string.startsWith("http:")) {
            string3 = Remote.doHttp(string, string2);
        } else if (string.startsWith("bsh:")) {
            string3 = Remote.doBsh(string, string2);
        } else {
            throw new IOException("Unrecognized URL type.Scheme must be http:// or bsh://");
        }
        try {
            return Integer.parseInt(string3);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    static String doBsh(String string, String string2) {
        String string3 = "";
        String string4 = "";
        String string5 = "-1";
        String string6 = string;
        try {
            string = string.substring(6);
            int n = string.indexOf(":");
            string3 = string.substring(0, n);
            string4 = string.substring(n + 1, string.length());
        }
        catch (Exception exception) {
            System.err.println("Bad URL: " + string6 + ": " + exception);
            return string5;
        }
        try {
            String string7;
            System.out.println("Connecting to host : " + string3 + " at port : " + string4);
            Socket socket = new Socket(string3, Integer.parseInt(string4) + 1);
            OutputStream outputStream = socket.getOutputStream();
            InputStream inputStream = socket.getInputStream();
            Remote.sendLine(string2, outputStream);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string7 = bufferedReader.readLine()) != null) {
                System.out.println(string7);
            }
            string5 = "1";
            return string5;
        }
        catch (Exception exception) {
            System.err.println("Error communicating with server: " + exception);
            return string5;
        }
    }

    private static void sendLine(String string, OutputStream outputStream) throws IOException {
        outputStream.write(string.getBytes());
        outputStream.flush();
    }

    static String doHttp(String string, String string2) {
        String string3 = null;
        try {
            String string4;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("bsh.client=Remote");
            stringBuffer.append("&bsh.script=");
            stringBuffer.append(URLEncoder.encode(string2, "UTF-8"));
            String string5 = stringBuffer.toString();
            URL uRL = new URL(string);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter(httpURLConnection.getOutputStream(), "8859_1"), true);
            printWriter.print(string5);
            printWriter.flush();
            int n = httpURLConnection.getResponseCode();
            if (n != 200) {
                System.out.println("Error, HTTP response: " + n);
            }
            string3 = httpURLConnection.getHeaderField("Bsh-Return");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
            while ((string4 = bufferedReader.readLine()) != null) {
                System.out.println(string4);
            }
            System.out.println("Return Value: " + string3);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println(unsupportedEncodingException);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println(malformedURLException);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
        return string3;
    }

    static String getFile(String string) throws FileNotFoundException, IOException {
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        while ((string2 = bufferedReader.readLine()) != null) {
            stringBuffer.append(string2).append("\n");
        }
        return stringBuffer.toString();
    }
}

